/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.servlet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

import com.ibm.trl.tcg.pts.integrity.IntegrityReport;
import com.ibm.trl.tcg.pts.integrity.ReferenceManifest;
import com.ibm.trl.tcg.pts.integrity.VerificationResult;
import com.ibm.trl.tcg.pts.tools.Base64Tool;

/**
 * Client for PVA Servlet
 * 
 * TODO for demo/test
 * TODO Sessin not works yet. (Server side)
 * 
 * @author Seiji Munetoh
 *
 */
public class Client {

	String hostname = "localhost";
	int port = 8080;
	String sessionId;
	String nonce ="";
	
	Socket socket;
	BufferedReader reader;
	BufferedWriter writer;
	URL url ;
	HttpURLConnection con;
	HttpsURLConnection scon;
	PrintWriter out;
	private String username;
	
	public byte[] open(String ptsHostname,int port,String name) throws Exception {
		
		hostname = ptsHostname;
		String urlString = "http://" +  ptsHostname + ":" + port + 
		  "/pva/servlet/Validate010";
		
		url = new URL(urlString);
		
		System.out.println("urlString : " + urlString);
		
		con = (HttpURLConnection) url.openConnection();
		con.setRequestMethod("POST");
		
		con.setDoOutput(true);
		
		//PrintWriter 
		out = new PrintWriter(con.getOutputStream());
		//String postMsg = "account=munetoh";
		String postMsg = "account=" + name;
		out.print(postMsg);
		out.close();
		
		BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String line;
		while ((line = in.readLine()) != null) {
			
			//System.out.println(line);
			
			//          1         2         3         4         5         6         7
			//01234567890123456789012345678901234567890123456789012345678901234567890123456789
			//Set-Cookie: JSESSIONID=F8D29F38543668A41B1F91E1D12A6B3F; Path=/pva
			if (line.contains("Set-Cookie: JSESSIONID=")) {
				sessionId = line.substring(23, 55);
				System.out.println(line);
				System.out.println("sessionId " + sessionId);
			}
			//          1         2         3         4         5         6         7
			//01234567890123456789012345678901234567890123456789012345678901234567890123456789
			//<input type=text size=40 name=nonce value="8QQP7McWxYvAtYfAKGz60jAP1kI=">
			if (line.contains("<input type=text size=40 name=nonce value=")) {
				nonce = line.substring(43, 71);
				System.out.println(line);
				System.out.println("nonce " + nonce);
			}			
		}
		System.out.println("open - done");	
		//reader.close();
		//writer.close();
		//socket.close();
		in.close();
		con.disconnect();
		
		return Base64Tool.decode(nonce);
	}

	/**
	 * 
	 * SSL 
	 * - workaround CN error
	 * 
	 * @param ptsHostname
	 * @param name
	 * @param keystore
	 * @param password
	 * @return
	 * @throws Exception
	 */
	public byte[] sopen(String ptsHostname, String name,String keystore, String password) throws Exception {
		// 443 Only
		hostname = ptsHostname;
		String urlString = "https://" +  ptsHostname + "/pva/servlet/Validate010";
		url = new URL(urlString);
		username = name;
		System.out.println("DEBUG urlString : " + urlString);
		
		/* Keystore */
		// -Djavax.net.ssl.trustStore=
		// 07/12/14 move to COnfig.java to handle JRE and GCJ
		//System.setProperty("javax.net.ssl.trustStore" , keystore );
		//System.setProperty("javax.net.ssl.trustStorePassword",password);
		
		// Error..
		// javax.net.ssl.SSLHandshakeException: java.security.cert.CertificateException: 
		// No subject alternative names present
		// http://forum.java.sun.com/thread.jspa?threadID=5139951
		// http://saloon.javaranch.com/cgi-bin/ubb/ultimatebb.cgi?ubb=get_topic&f=65&t=001477
		// Use my HostnameVerifier.		
		
		javax.net.ssl.HostnameVerifier hv = new javax.net.ssl.HostnameVerifier() {
			public boolean verify(String hostName,javax.net.ssl.SSLSession session) {
				String ph = session.getPeerHost();
            	   
				if (ph.equals(hostName)) {
					// same CN
					return true;
            	}
				else {
					System.err.println("HostnameVerifier Bad CN ERROR");
					System.err.println("HostnameVerifier sessein  : " + ph);
					System.err.println("HostnameVerifier hostName : " + hostName);
					return false;
				}
			}
        };
        javax.net.ssl.HttpsURLConnection.setDefaultHostnameVerifier(hv);
        
		con = (HttpURLConnection) url.openConnection();

		con.setRequestMethod("POST");		
		con.setDoOutput(true);
		
		out = new PrintWriter(con.getOutputStream());
		String postMsg = "account=" + name;
		out.print(postMsg);
		out.close();
		
		
		BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String line;
		while ((line = in.readLine()) != null) {
			if (line.contains("Set-Cookie: JSESSIONID=")) {
				sessionId = line.substring(23, 55);
				System.out.println(line);
				System.out.println("sessionId " + sessionId);
			}
			if (line.contains("<input type=text size=40 name=nonce value=")) {
				nonce = line.substring(43, 71);
				System.out.println(line);
				System.out.println("nonce " + nonce);
			}			
		}
		System.out.println("open - done");	
		in.close();
		con.disconnect();
		
		return Base64Tool.decode(nonce);
	}

	public VerificationResult validate(IntegrityReport localIR, ReferenceManifest biosRM, ReferenceManifest runtimeRM, String string) 
	throws Exception {
		
		System.out.println("validate - start");	
		
		
		con = (HttpURLConnection) url.openConnection();
		con.setRequestMethod("POST");
		con.setDoOutput(true);
		
		String base64IR = localIR.getBase64String();
		String base64BiosRM = biosRM.getBase64String();
		String base64RuntimeRM = runtimeRM.getBase64String();
		
		//System.out.println("IR(base64) : " + base64IR);
		
		//String postMsg = "account=munetoh" +
		String postMsg = "account=" + username +
		"&nonce=" + nonce + 
		"&ir=" + base64IR +
		"&rm0=" + base64BiosRM +
		"&rm1=" + base64RuntimeRM +
		"&option=" + "";
		
		
		PrintWriter out = new PrintWriter(con.getOutputStream());
		//String postMsg = "account=munetoh";
		out.print(postMsg);
		out.close();

		String base64VR = "";
		BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String line;
		while ((line = in.readLine()) != null) {
			if (line.contains("vr=")) {
				base64VR = line.substring(3, line.length());
				System.out.println(line);
				System.out.println(base64VR);
			}
		}
		
		VerificationResult vr = new VerificationResult();
		vr.parseBase64String(base64VR);
		in.close();
		con.disconnect();
		
		System.out.println("validate - done");	
		
		return vr;
	}

}
