/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.tools;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author Seiji Munetoh
 * 
 */
public class DigestTool {

	// public static void main(String[] args) {
	// }

	/**
	 * @param mbr
	 * @return
	 * @throws NoSuchAlgorithmException
	 */
	public static byte[] SHA1(byte[] msg) {
		MessageDigest md;
		byte[] hash = null;
		try {
			md = MessageDigest.getInstance("SHA1");
			md.update(msg);
			hash = md.digest();
		} catch (NoSuchAlgorithmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return hash;
	}

	private MessageDigest _md;

	public void init() throws NoSuchAlgorithmException {
		_md = MessageDigest.getInstance("SHA1");
	}

	/**
	 * 
	 * @param len
	 * @param buf
	 * 
	 */
	public void update(int len, byte[] buf) {
		_md.update(buf, 0, len);
	}

	/**
	 * 
	 * @param buf
	 * @param offset
	 * @param len
	 */
	public void update(byte[] buf, int offset, int len) {
		_md.update(buf, offset, len);
	}

	public byte[] digest() {
		return _md.digest();
	}

}
