/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import com.ibm.trl.tcg.pts.eventlog.IML;
import com.ibm.trl.tcg.pts.integrity.IntegrityReport;
import com.ibm.trl.tcg.pts.integrity.ReferenceManifest;
import com.ibm.trl.tcg.pts.integrity.VerificationResult;
import com.ibm.trl.tcg.pts.integrity.iidb.IIDB;
import com.ibm.trl.tcg.pts.tools.Base64Tool;
import com.ibm.trl.tcg.pts.vulnerability.deb.CopyActualDebPackageData2DB;
import com.ibm.trl.tcg.pts.vulnerability.deb.GetInsertDebianDetailInfo;
import com.ibm.trl.tcg.pts.vulnerability.deb.GetInsertDebianInfo;
import com.ibm.trl.tcg.pts.vulnerability.deb.MakeTM3OfDebVulnerability;
import com.ibm.trl.tcg.pts.vulnerability.deb.SyncWithDSA;
import com.ibm.trl.tcg.pts.vulnerability.nvdcve.ReadNvdCveSAX;
import com.ibm.trl.tcg.pts.vulnerability.oval.ReadOvalRedhat;
import com.ibm.trl.tcg.pts.vulnerability.rpm.CopyActualRpmPackageData2DB;
import com.ibm.trl.tcg.pts.vulnerability.rpm.MakeTM3OfRpmVulnerability;
import com.ibm.trl.tcg.pts.vulnerability.tool.DbOperations;

// import com.ibm.trl.tcg.pts.tools.PcrComposite;

/**
 * TCG Platform Trust Service
 * 
 * 
 * 
 * @author Seiji Munetoh
 * 
 */
public class PlatformTrustServices {
	/* Logger */
	// Log log = LogFactory.getLog(this.getClass());
	// public static int dbIndex;

	private String ptsPropFilename = "/etc/OpenPlatformTrustServices.conf";

	private String ptsWorkDir = "/var/lib/pts";

	public PlatformTrustServices() {
		/* Check my properties */
		try {
			Properties prop = new Properties();
			prop.load(new FileInputStream(ptsPropFilename));
			ptsWorkDir = getProperties(ptsWorkDir, prop, "pts.work.dir");
			
		} catch (Exception e) {
			ptsWorkDir = "./";
		}
	}

	private String getProperties(String name, Properties prop, String key) {
		String value = prop.getProperty(key);
		if (value != null) {
			return value;
		} else {
			return name;
		}
	}

	private static void usage(String[] args) {
		System.out.println("Usage: openpts [COMMAND] [OPTION]");
		System.out.println(" COMMAND");
		System.out.println("  iml");
		System.out.println("  manifest");
		System.out.println("  report");
		System.out.println("  validate");
		System.out.println("  iidb");
		System.out.println("  dsainfo");
		System.out.println("  dsadetail");
		System.out.println("  dsasync");
		System.out.println("  debimport");
		System.out.println("  maketm3deb");
		System.out.println("  cve");
		System.out.println("  oval");
		System.out.println("  rpmimport");
		System.out.println("  maketm3rpm");
		System.out.println("  db");
	}

	private static String[] shiftArgs(String[] args) {
		if (args == null)
			return null;

		String[] args2 = new String[args.length - 1];
		for (int i = 0; i < args.length - 1; i++) {
			args2[i] = args[i + 1];
		}
		return args2;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args == null) {
			usage(args);
			return;
		}
		if (args.length == 0) {
			usage(args);
			return;
		}

		try {
			/* Check 1st arg */
			if (args[0].equals("iml")) {
				IML.main(shiftArgs(args));
			} else if (args[0].equals("manifest")) {
				ReferenceManifest.main(shiftArgs(args));
			} else if (args[0].equals("report")) {
				IntegrityReport.main(shiftArgs(args));
			} else if (args[0].equals("validate")) {
				VerificationResult.main(shiftArgs(args));
			} else if (args[0].equals("iidb")) {
				IIDB.main(shiftArgs(args));
			} else if (args[0].equals("dsainfo")) {
				GetInsertDebianInfo.main(shiftArgs(args));
			} else if (args[0].equals("dsadetail")) {
				GetInsertDebianDetailInfo.main(shiftArgs(args));
			} else if (args[0].equals("dsasync")) {
				SyncWithDSA.main(shiftArgs(args));
			} else if (args[0].equals("debimport")) {
				CopyActualDebPackageData2DB.main(shiftArgs(args));
			} else if (args[0].equals("maketm3deb")) {
				MakeTM3OfDebVulnerability.main(shiftArgs(args));
			} else if (args[0].equals("cve")) {
				ReadNvdCveSAX.main(shiftArgs(args));
			} else if (args[0].equals("oval")) {
				ReadOvalRedhat.main(shiftArgs(args));
			} else if (args[0].equals("rpmimport")) {
				CopyActualRpmPackageData2DB.main(shiftArgs(args));
			} else if (args[0].equals("maketm3rpm")) {
				MakeTM3OfRpmVulnerability.main(shiftArgs(args));
			} else if (args[0].equals("db")) {
				DbOperations.main(shiftArgs(args));
			} else {
				usage(args);
			}
		} catch (Exception e) {
			System.err.println("Sorry, Internal Error");
			e.printStackTrace();
		}

		// PlatformTrustServices pts = PlatformTrustService();
		// IML iml = new IML();
		// pts.generateIntegrityReport(iml);

	}

	// private boolean _verbose = false;

	// private int sizeOfSelect;

	// private String _base64PcrSelect;

	// private String _base64DigestValue;

	// private String _base64ExternalData;

	// private String _base64SignatureValue;

	// private byte[] _pubkey;

	// private int _pcrNums;

	// private int[] _pcrIndex;

	// private String[] _base64PcrValues;

	// private PcrComposite _pcrComposite;

	private String _validationMessageForValid = "Goood";

	private byte[] _nonce = null;

	// private void generateIntegrityReport(IML iml) {
	// // TODO Auto-generated method stub
	// }

	/**
	 * IR Validation
	 * 
	 * @param byteIR
	 * @param byteFSM
	 * @return
	 * @throws Exception
	 */
	public String validateIRfromMessage(String username, String base64IR,
			String[] base64RM) throws Exception {
		// choices
		// 1) create tmp Files and read them
		// 2) base64 string to input stream
		// first, try 1)

		/* Filename */
		Date date = new Date();
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd");
		String dirName = ptsWorkDir + "/" + sdf1.format(date);
		// create DIR
		File dir = new File(dirName);
		if (dir.exists()) {
			// OK use this
		} else {
			dir.mkdirs();

			if (dir.exists() == false) {
				throw new Exception("Create DIR was failed. dir = " + dirName);
			}
		}

		SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmssz");
		String fileBase = dirName + "/" + sdf2.format(date) + "-" + username;

		/* setup tmp filename */
		String irFilename = fileBase + "-ir.xml";
		String vrFilename = fileBase + "-vr.xml"; // plain

		Base64Tool.decodeToFile(base64IR, irFilename);

		String[] rmFiles = new String[base64RM.length];
		for (int i = 0; i < base64RM.length; i++) {
			rmFiles[i] = fileBase + "-rm" + i + ".xml";
			Base64Tool.decodeToFile(base64RM[i], rmFiles[i]);
		}

		// IntegrityReport ir = new IntegrityReport(irFilename);
		VerificationResult vr = new VerificationResult();
		vr.setIIDBIndex(2); // TODO Lock up IIDB index by Runtime RM 
		vr.validateIRfromFile(irFilename, _nonce, rmFiles, 0);// PLAIN
		//vr.validateIRfromFile(irFilename,_nonce, rmFiles,1);// GZIPPED
		

		if (vr.getResult().equals("VALID")) {
			// replace Reason to the simple string
			//_validationMessageForValid += "\nGoooood";
			vr.setReason(_validationMessageForValid);
		}
		else {
			// ELSE, keep the reason generated by FSM
		}

		vr.save(vrFilename);

		String base64VR = Base64Tool.encodeFromFile(vrFilename);

		return base64VR;
	}

	// public void verbose() {
	// _verbose = true;
	// }

	public void setValidationMessageForValid(String message) {
		_validationMessageForValid = message;

	}

	public void setNonce(byte[] nonce) {
		// FindBug _nonce = nonce;
		_nonce = new byte[nonce.length];
		System.arraycopy(nonce, 0, _nonce, 0, nonce.length);

	}

}
