/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.tools;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;

/**
 * Signature Tool
 * 
 * 
 * @author Seiji Munetoh
 * 
 */
public class SignatureTool {

	public static boolean validate(byte[] pubKey, byte[] message,
			byte[] signature) throws Exception {

		/* Setup RSA PubKey */
		byte[] pubExp = { 0x00, 0x01, 0x00, 0x01 };

		BigInteger biM = new BigInteger(pubKey);
		BigInteger biE = new BigInteger(pubExp);
		RSAPublicKeySpec rpks = new RSAPublicKeySpec(biM, biE);
		KeyFactory kf = KeyFactory.getInstance("RSA");

		PublicKey key = (PublicKey) kf.generatePublic(rpks);

		/* Verify Signature */

		Signature sig = Signature.getInstance("SHA1withRSA");
		sig.initVerify(key);
		sig.update(message);

		return sig.verify(signature);
	}
}
