/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.integrity;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.XMLReader;

public class TCGSchemas {
	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	private String _propFilename = "tcgschema.properties";

	// TODO where is a good place to put the schema?
	private String _schemasPath = "../tcg/schemas/";

	// private String _schemasPath = "C:/Documents and Settings/munetoh/My
	// Documents/Eclipse Workplace/3.2-meti/openpts/tcg/schemas";

	private String DS = "xmldsig-core-schema.xsd";

	// String DS = "Core_Integrity_Manifest_v16_ibm.xsd";
	private String CORE = "Core_Integrity_Manifest_v16_ibm.xsd";

	private String SO = "SimpleObject_v8_ibm.xsd";

	private String IR = "Integrity_Report_Manifest_v19_ibm.xsd";

	private String VR = "VerificationResult_v5_ibm.xsd";

	private String RM = "Reference_Integrity_Measurement_Manifest_v13_ibm.xsd";

	private int SCHEMA_NUM = 6;

	private String[] _schemas;

	private File[] _schemaFiles;

	/*
	 * TCGSchemas (String schemaPath) { _schemasPath = schemaPath; _schemas =
	 * new String[SCHEMA_NUM]; _schemaFiles = new File[SCHEMA_NUM]; try {
	 * setSchemaDir(_schemasPath); } catch (Exception e) { // TODO
	 * Auto-generated catch block e.printStackTrace(); } }
	 */

	// public Object getSchemaList() {
	// return _schemas;
	// }
	public TCGSchemas() {
		// TODO Auto-generated constructor stub
	}

	public Object getSchemaFiles() {
		return _schemaFiles;
	}

	public void setSchemaDir(String path) throws Exception {
		_schemasPath = path;
		_schemas[0] = _schemasPath + "/" + DS;
		_schemas[1] = _schemasPath + "/" + CORE;
		_schemas[2] = _schemasPath + "/" + SO;
		_schemas[3] = _schemasPath + "/" + IR;
		_schemas[4] = _schemasPath + "/" + VR;
		_schemas[5] = _schemasPath + "/" + RM;

		_schemaFiles[0] = new File(_schemas[0]);
		if (_schemaFiles[0].exists() == false) {
			throw new Exception("Schema file not found, " + _schemas[0]);
		}
		_schemaFiles[1] = new File(_schemas[1]);
		_schemaFiles[2] = new File(_schemas[2]);
		_schemaFiles[3] = new File(_schemas[3]);
		_schemaFiles[4] = new File(_schemas[4]);
		_schemaFiles[5] = new File(_schemas[5]);

	}

	public boolean validate(String filename) throws Exception {

		if (filename == null) {
			throw new Exception(
					"Sorry, only work for given XML file - TODO item");
		}

		/* Load Schemas */
		Properties prop = new Properties();
		// FileInputStream fis = new FileInputStream(_propFilename);
		ClassLoader cl = this.getClass().getClassLoader();
		InputStream ips = cl.getResourceAsStream(_propFilename);
		prop.load(ips);

		int num = new Integer(prop.getProperty("tcgschema.num")).intValue();

		String schemas[] = new String[num];
		for (int i = 0; i < num; i++) {
			String s = prop.getProperty("tcgschema." + i);
			URL url = cl.getResource(s);
			schemas[i] = url.toString();
		}

		if (log.isDebugEnabled()) {
			for (int i = 0; i < num; i++) {
				log.debug("schema " + i + " " + schemas[i]);
			}
		}

		/* SAX */

		SAXParserFactory f = SAXParserFactory.newInstance();
		f.setNamespaceAware(true);
		f.setValidating(true);

		SAXParser p = f.newSAXParser();
		p.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage",
				"http://www.w3.org/2001/XMLSchema");
		p.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource",
				schemas);
		// _tcgSchemas.getSchemaFiles());//.getSchemaList());

		XMLReader reader = p.getXMLReader();
		SaxErrorHandler eh = new SaxErrorHandler();
		reader.setErrorHandler(eh);

		reader.setFeature("http://xml.org/sax/features/validation", true);
		reader.setFeature("http://apache.org/xml/features/validation/schema",
				true);
		reader.setFeature("http://xml.org/sax/features/namespaces", true);

		/* Validate RIMM */
		reader.parse(filename);

		if (eh.rc == false) {
			return false;
		} else {
			return true;
		}
	}
}
