/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.vulnerability.deb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;

import javax.swing.text.html.parser.ParserDelegator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.vulnerability.tool.GetFileFromInternet;

/**
 * Insert metadata of Debian Security Advisory (this works on 2000-2007) 
 * Get files from internet and parse them.
 * 
 * @author Megumi Nakamura
 */
public class GetInsertDebianInfo {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	public GetInsertDebianInfo() {
	}

	/**
	 * Download Index file and Update vuldb.
	 * @param urlbaseString URL for Debian Security Advisory list page
	 * @throws Exception
	 */
	public void updateVuldb(String urlbaseString) throws Exception {
		updateVuldb(urlbaseString, null);
	}

	/**
	 * Download Index file and Update vuldb.
	 * @param urlbaseString URL for Debian Security Advisory list page
	 * @param tmpDirname Directory for output files
	 * @throws Exception
	 */
	public void updateVuldb(String urlbaseString, String tmpDirname)
			throws Exception {
		String urlString = urlbaseString + "index.en.html";
		String filename = new GetFileFromInternet().getFile(urlString,
				tmpDirname, true);
		Reader reader = new BufferedReader(new FileReader(filename));
		DebianListParser pc = new DebianListParser(urlbaseString);
		if (log.isDebugEnabled()) {
			log.debug("url :" + urlString);
			log.debug("file:" + filename);
		}
		new ParserDelegator().parse(reader, pc, true);
		reader.close();
	}
	
	/**
	 * @param args --url, --outdir, --detail
	 */
	public static void main (String[] args) {
		String urlbaseString = null;
		String tmpDirname = null;
		boolean detail = false; 
		
		for (int i = 0; i < args.length; ++i) {
			if ("--url".equals(args[i])) {
				urlbaseString = args[++i];
			} else if ("--outdir".equals(args[i])) {
				tmpDirname = args[++i];
			} else if ("--detail".equals(args[i])) {
				detail = true;
			} else {
				System.err.println("Unknown option " + args[i]);
				usage();
				return;
			}
		}
		
		try {
			if (urlbaseString != null) {
				new GetInsertDebianInfo().updateVuldb(urlbaseString, tmpDirname);
				if (detail) {
					new GetInsertDebianDetailInfo().updateVuldb(tmpDirname);
				}
			} else {
				usage();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

	}
	
	/**
	 * Usage.
	 */
	private static void usage() {
		System.out.println("Usage: dsainfo [OPTIONS]");
		System.out.println(" OPTIONS");
		System.out.println(" --url http://www.debian.org/security/2007/");
		System.out.println(" --outdir /tmp (optional: the directory to store the html files.)");
		System.out.println(" --detail (optional: update detailed info, right after storing dsa info.)");
	}

}
