/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.vulnerability.deb;

import java.sql.SQLException;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML.Tag;
import javax.swing.text.html.HTMLEditorKit.ParserCallback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibm.trl.tcg.pts.ibatis.SqlConfigVul;
import com.ibm.trl.tcg.pts.ibatis.dto.Debians;

/**
 * Parse detailed info of Debian Security Advisory (2000-2007). This class is
 * used in GetInsertDebianDetailInfo.
 * 
 * @author Megumi Nakamura
 */
public class DebianInfoParser extends ParserCallback {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	private boolean start = false;

	private boolean end = false;

	private boolean dt = false;

	private boolean dd = false;

	private boolean vul = false;

	private boolean cve = false;

	private boolean cvea = false;

	private String cveString = null;

	private Debians debians = null;

	private SqlMapClient sqlMapVul = SqlConfigVul.getSqlMapInstance();

	/**
	 * start tag handler of ParserCallback.
	 */
	public void handleStartTag(Tag tag, MutableAttributeSet attr, int pos) {
		if (tag.toString().equalsIgnoreCase("h2")) {
			start = true;
			debians = new Debians();
			try {
				sqlMapVul.startTransaction();
			} catch (SQLException ex) {
				do {
					log.error("SQLSTATE: " + ex.getSQLState());
					log.error("ERR-CODE: " + ex.getErrorCode());
					log.error("ERR-MSEG: " + ex.getMessage());
					ex = ex.getNextException();
				} while (null != ex);
			}
		} else if (tag.toString().equalsIgnoreCase("dt")) {
			dt = true;
		} else if (tag.toString().equalsIgnoreCase("dd")) {
			dd = true;
		} else if (tag.toString().equalsIgnoreCase("h3")) {
			end = true;
		} else if (cve && tag.toString().equalsIgnoreCase("a")) {
			cvea = true;
		}
	}

	/**
	 * end tag handler of ParserCallback.
	 */
	public void handleEndTag(Tag tag, int pos) {
		if (tag.toString().equalsIgnoreCase("dt")) {
			dt = false;
		} else if (tag.toString().equalsIgnoreCase("dt")) {
			dt = false;
		} else if (tag.toString().equalsIgnoreCase("dd")) {
			dd = false;
			cve = false;
		} else if (tag.toString().equalsIgnoreCase("a")) {
			cvea = false;
		}
	}

	/**
	 * simple tag handler of ParserCallback.
	 */
	public void handleSimpleTag(Tag tag, MutableAttributeSet attr, int pos) {
	}

	/**
	 * text handler of ParserCallback.
	 */
	public void handleText(char[] data, int pos) {
		String dataString = new String(data);
		if (start) {
			if (dataString.startsWith("Vulnerable")) {
				vul = true;
			} else if (vul && dd) {
				if (dataString.equalsIgnoreCase("Yes")) {
					debians.setDebianVulnerability(1);
				} else if (dataString.equalsIgnoreCase("No")) {
					debians.setDebianVulnerability(0);
				}
				vul = false;
			} else if (dt
					&& dataString.startsWith("Security database references")) {
				cve = true;
			} else if (cvea) {
				if (dataString.startsWith("CVE")) { // remove Bugtrack
					if (cveString == null) {
						cveString = dataString;
					} else {
						cveString = dataString + " " + cveString;
					}
				}
			} else if (cve) { // Don't erase!
			} else if (dataString
					.startsWith("These problems have been fixed in the")
					|| dataString.startsWith("For the stable distribution")
					|| dataString.startsWith("For the old stable distribution")
					|| dataString.startsWith("For the oldstable distribution")
					|| dataString.startsWith("For the unstable distribution")
					|| dataString
							.startsWith("For the upcoming stable distrubution")
					|| dataString.startsWith("This problem has been fixed")) {
				getVersionNumber(dataString);
			} else if (dt) { // Don't erase!
			} else if (dd) { // Don't erase!
			} else if (start && !end) {
				String[] all = dataString.split(" ");
				String version = all[0];
				all = version.split("-");
				String dsaId = all[0] + "-" + all[1];
				debians.setDebianDsaId(dsaId);

				if (all.length > 2) {
					String minorVersion = all[2];
					int mid = Integer.valueOf(minorVersion).intValue();
					debians.setDebianMid(mid);
				}
				end = true;
			} else if (start && end) {
				start = false;
				debians.setDebianCve(cveString);

				try {
					sqlMapVul.insert("updateDebian", debians);
					sqlMapVul.commitTransaction();
					sqlMapVul.endTransaction();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * Pick out version number from string, for etch, sarge, and sid.
	 * 
	 * @param dataString
	 *            The string which contains version number
	 */
	private void getVersionNumber(String dataString) {
		if (dataString.indexOf("etch") > 0) {
			debians.setDebianFixedEtch(searchDigit(dataString));
		} else if (dataString.indexOf("sarge") > 0) {
			debians.setDebianFixedSarge(searchDigit(dataString));
		} else if (dataString.indexOf("sid") > 0) {
			debians.setDebianFixedSid(searchDigit(dataString));
		}
	}

	/**
	 * Pick out digit string from one string.
	 * 
	 * @param dataString
	 *            The string which contains digit
	 * @return The digit string
	 */
	private String searchDigit(String dataString) {
		String result = null;
		String[] tmp = dataString.split(" ");
		for (int i = 0; i < tmp.length; i++) {
			if (tmp[i].matches(".+[0-9].+")) {
				result = tmp[i];
				result = removeEndDot(result);
			}
		}
		return result;
	}

	/**
	 * Remove dot at the end of line.
	 */
	private String removeEndDot(String dataString) {
		if (dataString.endsWith(".")) {
			dataString = dataString.substring(0, dataString.length() - 1);
		}
		return dataString;
	}

	/**
	 * comment handler of ParserCallback.
	 */
	public void handleComment(char[] data, int pos) {
	}
}
