/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import org.apache.commons.codec.binary.Base64;

//import sun.misc.BASE64Decoder;
//import sun.misc.BASE64Encoder;

/**
 * 
 * Base64 tool using sun.misc in JDK1.5
 * 
 * @author Seiji Munetoh
 * 
 */
public class Base64Tool {
	/**
	 * base64 encode from byte[] data to String
	 * 
	 * @param data
	 *            binary blob
	 * @return base64 string
	 */
	public static String encode(byte[] data) {
		// Apache CODEC
		byte[] out = Base64.encodeBase64(data);
		return new String(out);
		
		// SUN
		//BASE64Encoder encoder = new BASE64Encoder();
		//// 2007-12-10 Munetoh remove \n
		////return encoder.encode(data);
		//return encoder.encode(data).replaceAll("\\n", "");
	}

	/**
	 * decode base64 string to byte[]
	 * 
	 * @param string
	 * @return byte[]
	 * @throws IOException
	 */
	public static byte[] decode(String string) throws IOException {
		// Apache CODEC
		byte[] out = Base64.decodeBase64(string.getBytes());
		return out;
		// SUN
		//BASE64Decoder decoder = new BASE64Decoder();
		//if (string == null)
		//	return null;
		//return decoder.decodeBuffer(string);
	}

	/**
	 * 
	 * base64 string from file
	 * 
	 * @param filename
	 * @return
	 * @throws Exception
	 */
	public static String encodeFromFile(String filename) throws Exception {
		File file = new File(filename);
		FileInputStream fis = new FileInputStream(file);
		BufferedInputStream bis = new BufferedInputStream(fis);
		byte[] buf = new byte[(int) file.length()];

		int c;
		int i = 0;
		while ((c = bis.read()) != -1) {
			buf[i] = (byte) c;
			i++;
		}
		bis.close();
		fis.close();

		String base64 = Base64Tool.encode(buf);
		return base64;
	}

	/**
	 * decode base64 string and save to file
	 * 
	 * @param base64str
	 * @param filename
	 * @throws Exception
	 */
	public static void decodeToFile(String base64str, String filename)
			throws Exception {
		FileOutputStream fos = new FileOutputStream(filename);
		OutputStreamWriter osw = new OutputStreamWriter(fos);

		byte[] buf = Base64Tool.decode(base64str);
		if (buf != null) {
			for (int i = 0; i < buf.length; i++) {
				osw.write(buf[i]);
			}
		}
		osw.close();
		fos.close();
	}

}
