package com.ibm.trl.tcg.pts.eventlog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SMBIOS {

	private String _BiosVersion = "unknown";

	private String _ProductName = "unknown";

	private String _BiosVendor = "unknown";

	// private String _BiosDateStr;
	private Date _BiosDate;

	private String _ManufacturerName = "unknown";

	public SMBIOS() {
		_BiosDate = new Date();
	}

	/**
	 * 
	 * Load dmidecode output filename and find out some info which are required
	 * to create a manifest.
	 * 
	 * @param dmidecodeFilename
	 * @throws Exception
	 */
	public void loadDmidecodeOutput(String dmidecodeFilename) throws Exception {

		File file = new File(dmidecodeFilename);
		FileInputStream fis = new FileInputStream(file);
		InputStreamReader isr = new InputStreamReader(fis);
		BufferedReader br = new BufferedReader(isr);

		String line;
		int section = 0;

		SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");

		while ((line = br.readLine()) != null) {
			String[] words = line.split(": ");

			/* Section check */
			if (line.contains("BIOS Information")) {
				section = 1;
			} else if (line.contains("System Information")) {
				section = 2;
			} else if (line.contains("Base Board Information")) {
				section = 3;
			}

			/* String check */
			// BIOS Information
			if ((section == 1) && (line.contains("Version:"))) {
				_BiosVersion = words[1];
				// System.out.println("BIOS Version: " + _BiosVersion);
			} else if ((section == 1) && (line.contains("Vendor:"))) {
				_BiosVendor = words[1];
				// System.out.println("BIOS Vendor: " + _BiosVendor);
			} else if ((section == 1) && (line.contains("Release Date:"))) {
				String biosDateStr = words[1];
				if (biosDateStr.equals("Not Specified")) {
					// TODO how to?
				} else {
					_BiosDate = format.parse(biosDateStr);
				}
				// System.out.println("BIOS Date: " + biosDateStr);
				// System.out.println("BIOS Date: " + _BiosDate.toString());
			}
			// System Information
			else if ((section == 2) && (line.contains("Product Name:"))) {
				_ProductName = words[1];
				// System.out.println("Product Name: " + _ProductName);
			} else if ((section == 2) && (line.contains("Manufacturer:"))) {
				_ManufacturerName = words[1];
				// System.out.println("Product Name: " + _ProductName);
			}
			// else
			else {
				// ignore
			}

		}

		br.close();
		isr.close();
		fis.close();

	}

	public String getManufacturerName() {
		return _ManufacturerName;
	}

	public String getProductName() {
		return _ProductName;
	}

	public String getBIOSVendorName() {
		return _BiosVendor;
	}

	public String getBIOSVersion() {
		return _BiosVersion;
	}

	public Date getBIOSDate() {
		return _BiosDate;
	}

}
