/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.engine;

/**
 * 
 * Property type name value CODEDIGEST code name hexdigest INTEGRITY any name
 * true/false PROPERTY any name any value
 * 
 * recommendation/evaluation
 * 
 * 
 * @author Seiji Munetoh
 * 
 */
public class PlatformProperty {

	/* Poroperty type */
	public static final long PROPERTY = 0;

	public static final long INTEGRITY = 1;

	public static final long CODEDIGEST = 2;

	/* recommendation by TCG IWG */
	public static final long VALID = 0;

	public static final long INVALID = 1;

	public static final long UNVERIFIED = 2;

	private long _type = PROPERTY;

	private String _name = null;

	private String _value = null;

	private String _expectedValue = null;

	// public long flag; // 0: internal, 1:output
	// public long recommendation = UNVERIFIED;
	private long _evaluation = UNVERIFIED;

	private String _comment = null;

	public PlatformProperty() {
		_evaluation = UNVERIFIED;
	}

	public PlatformProperty(String name, String value) {
		_type = PROPERTY;
		_name = name;
		_value = value;
	}

	public PlatformProperty(long type, String name, String value) {
		_type = type;
		_name = name;
		_value = value;
	}

	/**
	 * @param string
	 * @param string2
	 */
	public void set(String name, String value) {
		_type = PROPERTY;
		_name = name;
		_value = value;
	}

	/**
	 * @param string
	 * @param string2
	 */
	public void setValidProperty(String name, String value) {
		_type = PROPERTY;
		_name = name;
		_value = value;
		_evaluation = VALID;
	}

	/**
	 * @return
	 */
	public String getName() {
		return _name;
	}

	public boolean equals(String name) {
		if (name.equals(_name))
			return true;
		else
			return false;
	}

	/**
	 * @param name
	 * @param value
	 * @return
	 */
	public boolean equals(String name, String value) {
		if (name.equals(_name) && value.equals(_value))
			return true;
		return false;
	}

	/**
	 * @return
	 */
	public String getValue() {
		return _value;
	}

	/**
	 * 
	 */
	public void setValid() {
		_evaluation = VALID;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isValid() {
		if (_evaluation == VALID)
			return true;
		else
			return false;
	}

	/**
	 * 
	 * 
	 */
	public void setInvalid() {
		_evaluation = INVALID;
	}

	/**
	 * 
	 * @param expectedValue
	 */
	public void setInvalid(String ev) {
		_evaluation = INVALID;
		_expectedValue = ev;
	}

	/**
	 * @param fileName
	 */
	public void setName(String name) {
		_name = name;
	}

	/**
	 * @param string
	 */
	public void setValue(String value) {
		_value = value;
	}

	/**
	 * @param value
	 */
	public void changeValue(String value) {
		_value = value;
	}

}
