#!/usr/bin/perl

##
## Licensed Materials - Property of IBM
## Open Platform Trust Services - An open source TCG PTS
## (C) Copyright International Business Machines Corp. 2007
##

$DPKGI = "dpkg --info";

$EXT = "metadata";

if(@ARGV < 1){
	print "USAGE: perl $0 [input dir] [output dir (optional)]\n\n";
	exit;
} else {
	$INDIR = $ARGV[0];
	$OUTDIR = $ARGV[1];
	if(!-d $OUTDIR){
		mkdir -p $OUTDIR;
	}
}

opendir DIR, $INDIR;
@lines = grep { !m/^(\.|\.\.)$/g } readdir DIR;
close DIR;

foreach $line(@lines){
	#print "> $line\n\n";

	##
	## File
	##

	$FILENAME = $line;
	$FILENAME =~ s/[\r\s\n\t]//i;
	$FILENAME = "$FILENAME.$EXT";
	if(@ARGV < 1){
		open(DATA, ">> $FILENAME");
	} else {
		open(DATA, ">> $OUTDIR/$FILENAME");
	}

	##
	## dpkg --info
	##

	@infos = `$DPKGI $INDIR/$line`;

	$START = 0;
	foreach $info(@infos){
		$info =~ s/[\r\s\n\t]//i;

		if(index("$info", "Description:") >= 0){
			$START = 1;
			$tmp = "$info";
			$tmp =~ s/\n//;
		} elsif($START == 1) {
			$tmp = "$tmp $info";
			$tmp =~ s/\n//;
		} else {
			print DATA "$info";
		}

	}
	print DATA "$tmp";

	close(DATA);
}

sub getversion(){
	@infos = `$DPKG -s $package`;
	foreach $info(@infos){
		$info =~ s/[\r\s\n\t]//i;
		if(index("$info", "Version:") >= 0){
			$info =~ s/:/_/g;
			return substr($info, 8);
		}
	}
}

