#
# Create MySQL tables for "vul" schema
#
# 2007-10-17 Nakamura
# 2007-02-12 Munetoh 
# 2007-02-06 Munetoh 
# 2006-12-25 Nakamura
#


DROP TABLE IF EXISTS `oval_definitions`;
CREATE TABLE oval_definitions(
	id int(11) NOT NULL auto_increment,
	definition_id varchar(100) NOT NULL,
	title varchar(150) NOT NULL,
	description varchar(500) NOT NULL,
	cve varchar(500),
	PRIMARY KEY (id),
	UNIQUE KEY definition_id (definition_id)
);

DROP TABLE IF EXISTS `oval_tests`;
CREATE TABLE oval_tests(
	id int(11) NOT NULL auto_increment,
	test_id varchar(100) NOT NULL,
	definition_id varchar(100) NOT NULL,
	object_id varchar(100) NOT NULL,
	state_id varchar(100) NOT NULL,
	PRIMARY KEY (id),
	UNIQUE KEY test_id (test_id)
);

DROP TABLE IF EXISTS `oval_objects`;
CREATE TABLE oval_objects(
	id int(11) NOT NULL auto_increment,
	object_id varchar(100) NOT NULL,
	name varchar(45) NOT NULL,
	PRIMARY KEY (id),
	UNIQUE KEY object_id (object_id)
);

DROP TABLE IF EXISTS `cve_definitions`;
CREATE TABLE cve_definitions(
	id int(11) NOT NULL auto_increment,
	cve_id varchar(100) NOT NULL default '',
	url varchar(255) default NULL,
	published_on date default NULL,
	modified_on date default NULL,
	nvd_severity varchar(45) default NULL,
	nvd_cvss_score varchar(45) default NULL,
	nvd_cvss_vector varchar(100) default NULL,
	nvd_description varchar(3000) default NULL,
	nvd_solution varchar(500) default NULL,
	PRIMARY KEY (id),
	UNIQUE KEY cve_id (cve_id)
);

DROP TABLE IF EXISTS `debian_security_advisories`;
CREATE TABLE debian_security_advisories(
        id int(11) NOT NULL auto_increment,
        dsa_id VARCHAR(100) NOT NULL,
        url VARCHAR(255) default NULL,
        mid int(11) default 0,
        package_name VARCHAR(100),
        reported_on DATE default NULL,
        summary VARCHAR(255) default NULL,
        vulnerability int(1) default 0,
        cve VARCHAR(500) default NULL,
        fixed_version_sarge VARCHAR(50) default NULL,
        fixed_version_etch VARCHAR(50) default NULL,
        fixed_version_sid VARCHAR(50) default NULL,
	PRIMARY KEY (id),
	UNIQUE KEY dsa_id (dsa_id)
);

