/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresMeasureMemberDAO.java
 *  FW[o[IuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/07
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import openolap.viewer.Axis;
import openolap.viewer.Measure;
import openolap.viewer.MeasureMember;
import openolap.viewer.MeasureMemberType;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;

/**
 *  NXFPostgresMeasureMemberDAO<br>
 *  FW[o[IuWFNg̉iǗNXłB
 */
public class PostgresMeasureMemberDAO extends PostgresAxisMemberDAO implements MeasureMemberDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresMeasureMemberDAO.class.getName());

	// ********** RXgN^ **********

	/**
	 *  W[o[IuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresMeasureMemberDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * W[o[킷IuWFNg̏Wf[^\[X苁߂B
	 * @param cubeSeq L[uV[PXԍ
	 * @param commonSettings AvP[V̋ʐݒ
	 * @return W[o[IuWFNg̃Xg
	 * @exception SQLException ɗO
	 */
	public ArrayList selectMeasureMembers(String cubeSeq, CommonSettings commonSettings)  throws SQLException {

		// W[o擾
		ArrayList measureMemberList = new ArrayList();
		MeasureMember measureMem = null;
		String SQL = "";
		Statement stmt = null;
		ResultSet rs = null;

		SQL =   "";
		SQL +=	"select ";
		SQL +=	"    distinct c.measure_seq,m.name  ";
		SQL +=	"from ";
		SQL +=	"    oo_info_mes c,(select measure_seq,name from oo_measure union select formula_seq as measure_seq,name from oo_formula) m ";
		SQL +=	"where ";
		SQL +=	"c.cube_seq = " + cubeSeq + " and  ";
		SQL +=	"c.measure_seq=m.measure_seq ";
		SQL +=	"order by c.measure_seq ";

		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select measure members )F\n" + SQL);
			}
			rs   = stmt.executeQuery(SQL);

			int i=0;
			while ( rs.next() ) {
				measureMem = new MeasureMember(Integer.toString(i), 						// id
												rs.getString("name"), 						// measureName
												commonSettings.getFirstMeasureMemberType(), // measureMemberType
												Integer.toString(i+1), 						// uniqueName
												rs.getString("measure_seq"));				// measureSeq
//System.out.println("ID:" + Integer.toString(i) + "\nNAME:" + rs.getString("name") + "\nTYPE:" + commonSettings.getFirstMeasureMemberType().getName() );
				i++;
				measureMemberList.add(measureMem);
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return measureMemberList;
	}


	/**
	 * ^ꂽ|[gIuWFNg̃W[o[f[^\[XɕۑĂƂɂCB
	 * CLɋL܂B
	 *   EZNgꂽǂ
	 *   EW[o[^Cv
	 * @param report |[gIuWFNg
	 * @param axis 킷IuWFNg
	 * @param commonSettings AvP[V̋ʐݒ
	 * @exception SQLException ɗO
	 */
	public void applyAxis(Report report, Axis axis, CommonSettings commonSettings) throws SQLException {

		String SQL = null;
		ResultSet rs = null;
		Statement stmt = null;
		try {
			SQL = DAOFactory.getDAOFactory().getAxisMemberDAO(conn,axis).selectSaveDataSQL(report, axis);
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select measure members )F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);

			Measure Mem = (Measure) axis;
			ArrayList measureMemList = axis.getAxisMemberList();

			int i = 0;
			while ( rs.next() ) {

				// ZNgꂽǂAW[o[^CvXV
				MeasureMember measureMember = (MeasureMember)measureMemList.get(i);
				measureMember.setIsSelected(CommonUtils.FLGTobool(rs.getString("selectedFLG")));
				String measureMemberTypeID = rs.getString("measure_member_type_id");
				MeasureMemberType newMeasureMemberType = commonSettings.getMeasureMemberTypeByID(measureMemberTypeID);
				measureMember.setMeasureMemberType(newMeasureMemberType);

				i++;
			}

		} catch (SQLException e) {
			throw e;
		} finally {
		
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

	}

	/**
	 * W[o[̃W[o[^CvNCAg^ꂽƂɍXVB
	 * NCAg^ꂽF"measureMemberTypes"p[^
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings 킷IuWFNg
	 */
	public void registMeasureMemberType(RequestHelper helper, CommonSettings commonSettings) {

		HttpServletRequest request = helper.getRequest();
		String measureTypes = (String)request.getParameter("measureTypes");

		Report report = (Report)helper.getRequest().getSession().getAttribute("report");
	
		ArrayList measureMemberIDTypeIDPairList = StringUtil.splitString(measureTypes,",");
		Iterator it = measureMemberIDTypeIDPairList.iterator();
		while (it.hasNext()) {
			String measureMemberIDTypeIDPair = (String) it.next();
			ArrayList measureMemberIDTypeIDList = StringUtil.splitString(measureMemberIDTypeIDPair,":");

			String measureMemberID =(String)measureMemberIDTypeIDList.get(0);
			String measureMemberTypeID = (String) measureMemberIDTypeIDList.get(1);

			MeasureMember measureMember = (MeasureMember) report.getMeasure().getAxisMemberByUniqueName(measureMemberID);
			MeasureMemberType newMeasureMemberType = commonSettings.getMeasureMemberTypeByID(measureMemberTypeID);

			measureMember.setMeasureMemberType(newMeasureMemberType);

//System.out.println(measureMember.getMeasureMemberType().getName());
			
		}

	}

	/**
	 * W[o[IuWFNgiB
	 * @param report |[gIuWFNg
	 * @param reportID |[gID
	 *                ̃p[^NULL̏ꍇAReportIuWFNg|[gIDŎo[ۑB
	 *                  NULLł͂Ȃꍇ́AreportIDp[^̒lŎo[ۑB

	 * @param axis IuWFNg
	 * @param conn ConnectionIuWFNg
	 */
	public void saveAxisMember(Report report, String reportID, Axis axis, Connection conn) throws SQLException {

		// |[gIDݒ
		String reportIDValue = null;
		if (reportID == null) {
			reportIDValue = report.getReportID();
		} else {
			reportIDValue = reportID;
		}

		Measure measure = null;
		if (axis instanceof Measure) {
			measure = (Measure) axis;
		} else {
			throw new IllegalArgumentException();
		}

		String SQL = "";
		Statement stmt = conn.createStatement();

		try {
			Iterator meaIt = measure.getAxisMemberList().iterator();
			while (meaIt.hasNext()) {
				MeasureMember measureMember = (MeasureMember) meaIt.next();
				
				SQL =  "";
				SQL += "UPDATE oo_v_axis_member set";
				SQL += "    dimension_seq=" + measureMember.getMeasureSeq() + ", ";
				SQL += "    selectedFLG=" + CommonUtils.boolToFLG(measureMember.isSelected()) + ", ";
				SQL += "    measure_member_type_id=" + measureMember.getMeasureMemberType().getId();
				SQL += "WHERE ";
				SQL += "    report_id=" + reportIDValue + " and ";
				SQL += "    axis_id=" + axis.getId() + " and ";
				SQL += "    member_key=" + measureMember.getUniqueName();

				if(log.isInfoEnabled()) {
					log.info("SQL(update measure members )F\n" + SQL);
				}
				int updateCount = stmt.executeUpdate(SQL);
	
				// update0̏ꍇAVɃR[h쐬
				if (updateCount == 0) {
					SQL = "";
					SQL += "INSERT INTO ";
					SQL += "    oo_v_axis_member ";
					SQL += "       (report_id, axis_id, dimension_seq, member_key, selectedflg, drilledflg, measure_member_type_id) ";
					SQL += "values ( ";
					SQL +=                reportIDValue + ", ";					// report_id
					SQL +=                axis.getId() + ", ";					// axis_id
					SQL +=                measureMember.getMeasureSeq()	+ ", ";	// measure_seq
					SQL +=                measureMember.getUniqueName() + ", ";	// member_key
					SQL +=                "'" + CommonUtils.boolToFLG(measureMember.isSelected()) +  "', ";	// selectedFLG
					SQL +=                "'0', ";								// drilledFLG false(-)BW[͊KwȂׁAh邱ƂłȂ
					SQL +=                measureMember.getMeasureMemberType().getId();	// measureMemberType id
					SQL +=         ")";

					if(log.isInfoEnabled()) {
						log.info("SQL(insert measure members )F\n" + SQL);
					}
					int insertCount = stmt.executeUpdate(SQL);
					if (insertCount != 1) {
						throw new IllegalStateException();
					}
	
				}
			}
		} catch (IllegalStateException e) {
			throw e;
		} catch (SQLException e) {
			throw e;
		} finally {
					if (stmt != null) {
				stmt.close();
			}
		}
	}

}
