/*
 * 쐬: 2004/07/26
 *
 */
package openolap.viewer.chart;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import openolap.viewer.XMLConverter;

public class ChartXMLReader {

	public ChartCreator createChartByXML(String xmlFile) throws IllegalAccessException, NoSuchFieldException, ParserConfigurationException, SAXException, IOException{
		
//		try {
//			FileWriter fp = new FileWriter("abcde.txt");
//			fp.write("test String");
//			fp.close();
//		} catch (IOException e) {
//			System.out.println("O - " + e);
//		}

		XMLConverter xmlConverter = new XMLConverter();

		// XMLt@Cǂݍ
		Document doc = xmlConverter.readFile(xmlFile);

//		Element root = doc.getDocumentElement();
//System.out.println(root.getTagName());

		//`[gXMLݒ
		ChartCreator chartCreator = new ChartCreator();
		chartCreator.setChartByDoc(doc);
		
		//`[g^Cg̕FXMLݒ
		chartCreator.setChartTitleColorByDoc(doc);

		//`[g̃tHgݒ
		chartCreator.setChartTitleFont(doc);
		
		//`[gwiFXMLݒ
		chartCreator.setBackgroundColorByDoc(doc);
		
		//rXMLݒ
		chartCreator.setLegendByDoc(doc);
		
		//vbgGAwiF̐ݒ
		chartCreator.setPlotBackgroundColorByDoc(doc);
		
		//_E܂Eʃ`[g
		if(chartCreator.getPlot() instanceof CategoryPlot) {

			//JeS̐ݒ
			chartCreator.setCategoryAxisByDoc(doc);

			//Seriesݒ
			chartCreator.setSeriesAxisByDoc(doc);

//			//h_Eݒ
//			enableDrillDown(renderer,(DefaultCategoryDataset)helper.codeDataset);

		//~`[g
		} else if ((chartCreator.getPlot() instanceof PiePlot) ||
		             (chartCreator.getPlot() instanceof MultiplePiePlot)){

			//vbgGAwiFݒi~`[gpj
			chartCreator.setMultiPiePlotBGColor(doc);
		
			//~`[gpxݒ
			chartCreator.setPieLabel(doc);
			
			//c[`bv̐ݒ
			chartCreator.setToolTipForPie(doc);
			
			//tHg̐ݒ
			chartCreator.setPieFont(doc);
			
			//h_Eݒ
//			enableDrillDown(piePlot,(DefaultPieDataset)helper.codeDataset);			//~	
//			enableDrillDown(piePlot,(DefaultCategoryDataset)helper.codeDataset);	//~			
			
		}
		
		
		
		return chartCreator;
		
	}




}
