/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetDataInfoCommand.java
 *  FlXMLŏo͂y[WdispatchNXłB
 *
 *  쐬: 2004/01/05
 */

package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import java.util.ArrayList;

import javax.naming.NamingException;
import javax.servlet.ServletException;

import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.CellDataDAO;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.manager.CellDataManager;

/**
 *  NXFGetColorInfoCommand<br>
 *  FlXMLŏo͂y[WdispatchNXłB
 */
public class GetDataInfoCommand implements Command {

	// ********** CX^Xϐ **********

	/** RequestHelperIuWFNg */
	private RequestHelper requestHelper = null;

	/** DAOFactoryIuWFNg */
	private DAOFactory daoFactory = null;

	// ********** \bh **********

	/**
	 * lXMLŏo͂y[Wdispatch܂B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 * @exception NamingException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException, SQLException, NamingException {

		this.requestHelper = helper;
		this.daoFactory = DAOFactory.getDAOFactory();

		Connection conn = null;
		conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
										(String)helper.getRequest().getSession().getAttribute("searchPathName"));

		try {
			// ^ꂽ擾ƂCellDataIuWFNgXg(l̓tH[}bgt)擾requestIuWFNgɈꎞۑ
			//  iSQL^CvƂĂ͕WIj
			ArrayList cellDataList = CellDataManager.selectCellDatas(this.requestHelper, conn, true, CellDataDAO.normalSQLTypeString);

			helper.getRequest().setAttribute("cellDataList", cellDataList);

		} catch (SQLException e) {
			throw e;
		} finally {
			// RlNV̊J
			try {
				if(conn != null) {
					conn.close();
				}
			} catch (SQLException e) {
				throw e;
			}

		}

		// SessionAf[^擾p̃^폜
		CellDataManager.clearRequestParamForGetDataInfo(this.requestHelper); 

		return "/spread/dataInfo.jsp";
	}

}
