/*
 * 쐬: 2004/07/08
 * R[hŃh_Eł悤ɁAIMAGEMAP
 * R[hDataset̒lo͂B
 */

package openolap.viewer.chart;
import java.io.Serializable;
import org.jfree.data.CategoryDataset;
import org.jfree.util.ObjectUtils;
import org.jfree.chart.urls.*;

public class CustomCategoryURLGenerator implements CategoryURLGenerator, 
                                                     Cloneable, Serializable {

	// ********** CX^Xϐ **********

    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

	/** R[hpDataset */
	public CategoryDataset codeDataset;

	// ********** RXgN^ **********

	/**
	 *  CustomCategoryURLGeneratorIuWFNg𐶐B
	 *  @param codeDataset R[hpDataset
	 */
    public CustomCategoryURLGenerator(CategoryDataset codeDataset) {

        super();

		//R[hpDataset
		this.codeDataset = codeDataset;

    }

	// ********** \bh **********
	
	/**
	 *  IMAGEMAP閈ɁAJFreeChart肱̃\bhĂяoĂ
	 *  @return R[hpDataset̒l
	 */
    public String generateURL(CategoryDataset dataset, int series, int category) {

		   return (String)this.codeDataset.getRowKey(series) + "," + (String)this.codeDataset.getColumnKey(category);

    }

    public Object clone() throws CloneNotSupportedException {
    
        // all attributes are immutable, so we can just return the super.clone()
        return super.clone();
        
    }
    
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomCategoryURLGenerator)) {
            return false;
        }
        CustomCategoryURLGenerator generator = (CustomCategoryURLGenerator) obj;
        if (!ObjectUtils.equal(this.prefix, generator.prefix)) {
            return false;
        }

        if (!ObjectUtils.equal(this.seriesParameterName, generator.seriesParameterName)) {
            return false;
        }
        if (!ObjectUtils.equal(this.categoryParameterName, generator.categoryParameterName)) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result;
        result = (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 29 * result 
            + (this.seriesParameterName != null ? this.seriesParameterName.hashCode() : 0);
        result = 29 * result 
            + (this.categoryParameterName != null ? this.categoryParameterName.hashCode() : 0);
        return result;
    }
    
}
