package designer;

import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import java.io.*;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PostgreSqlGenerator{
	XMLConverter xmlCon;
	Document xmlDoc;

	public PostgreSqlGenerator() {
		try {
			xmlCon = new XMLConverter();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public String getTableSQL(String xmlString) {
		try {
			xmlDoc = xmlCon.toXMLDocument(xmlString);
			String sqlString = "";
			sqlString += getSelectStr("all");
			sqlString += getFromStr();
			sqlString += getWhereStr("","all");
			sqlString += getGroupByStr("all");
			sqlString += getOrderByStr("all");
			sqlString += getLimitStr();
			return sqlString;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getSQL(String xmlString) {
		try {
			xmlDoc = xmlCon.toXMLDocument(xmlString);
			String sqlString = "";
			sqlString += getSelectStr("all");
			sqlString += getFromStr();
//			sqlString += getJoinStr();
			sqlString += getWhereStr(getJoinStr(),"all");
			sqlString += getGroupByStr("all");
			sqlString += getOrderByStr("all");
			sqlString += getLimitStr();
			return sqlString;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getScreenSQL(String xmlString) {
		try {
			xmlDoc = xmlCon.toXMLDocument(xmlString);
			String sqlString = "";
			sqlString += getSelectStr("use_flg");
			sqlString += getFromStr();
//			sqlString += getJoinStr();
			sqlString += getWhereStr(getJoinStr(),"use_flg");
			sqlString += getGroupByStr("use_flg");
			sqlString += getOrderByStr("use_flg");
			sqlString += getLimitStr();
			return sqlString;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public Document readFile(String filepath) {
		try {
			xmlDoc = xmlCon.readFile(filepath);
			return xmlDoc;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getSelectStr(String kind) {
		try {
			String strSelect = "select "+"\n";
			Node xmlNode = xmlCon.selectSingleNode(xmlDoc,"//db_table");
			NodeList nodelist=null;
			Node tempNode = null;

			if(kind.equals("all")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/select_clause/logical_column[@dispflg='true']");
			}else if(kind.equals("use_flg")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/select_clause/logical_column[@dispflg='true' and @use_flg='1']");
			}
//System.out.println(nodelist.getLength());
			for(int i=0;i<nodelist.getLength();i++){
				//SortȂ̂ŁAԍĂ鑮w肵āASelectSingleNodeB
				if(kind.equals("all")){
					tempNode = nodelist.item(i);
				}else if(kind.equals("use_flg")){
					tempNode = xmlCon.selectSingleNode(xmlDoc,"//db_table/logical_model/select_clause/logical_column[@use_order='"+i+"' and @dispflg='true' and @use_flg='1']");
				}
//System.out.println(tempNode);
				if(tempNode!=null){//OdȂꍇNullƂȂB
					if(strSelect.equals("select "+"\n")){
						strSelect += "     " + xmlCon.selectSingleNode(tempNode,".//sql").getFirstChild().getNodeValue();
						strSelect += " as " + xmlCon.selectSingleNode(tempNode,".//name").getFirstChild().getNodeValue()+"\n";
					}else{
						strSelect += "    ," + xmlCon.selectSingleNode(tempNode,".//sql").getFirstChild().getNodeValue();
						strSelect += " as " + xmlCon.selectSingleNode(tempNode,".//name").getFirstChild().getNodeValue()+"\n";
					}
				}
			}
			return strSelect;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getFromStr() {
		try {
			String strFrom = "from "+"\n";
			Node xmlNode = xmlCon.selectSingleNode(xmlDoc,"//db_table");
			NodeList nodelist = xmlCon.selectNodes(xmlNode,"//db_table");

			for(int i=0;i<nodelist.getLength();i++){
				if(i==0){
					strFrom += "     " + ((Element)nodelist.item(i)).getAttribute("name")+"\n";
				}else{
					strFrom += "    ," + ((Element)nodelist.item(i)).getAttribute("name")+"\n";
				}
			}
			return strFrom;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getWhereStr(String whereStr,String kind) {
		try {
			String strWhere = "";
			if(whereStr==""){
//				strWhere = "where 'mode'!='viewer' "+"\n";
				strWhere = "where 1=1 "+"\n";
			}else{
				strWhere = whereStr;
			}

			Node xmlNode = xmlCon.selectSingleNode(xmlDoc,"//db_table");
			NodeList nodelist = null;

			if(kind.equals("all")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/where_clause/logical_condition");
			}else if(kind.equals("use_flg")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/where_clause/logical_condition[@use_flg='1']");
			}

			//PȂAWhere폜āAReturn
			if (nodelist.getLength()==0){
				return whereStr;
			}

			//@Ăꍇ́ATvSQLł́ARgɂB
			//ۂɔsꍇ́AuďB
			String sqlStr="";
			int whereCnt = 0;
			for(int i=0;i<nodelist.getLength();i++){
				if(i==0){
					if(whereStr==""){
						sqlStr = "    and " + xmlCon.selectSingleNode(nodelist.item(i),".//sql").getFirstChild().getNodeValue()+"\n";
					}else{
						sqlStr = "    and " + xmlCon.selectSingleNode(nodelist.item(i),".//sql").getFirstChild().getNodeValue()+"\n";
					}
					if (sqlStr.indexOf("@")==-1){
						strWhere += sqlStr;
						whereCnt++;
					}else{
						strWhere += "--" + sqlStr;
					}
				}else{
					sqlStr = "    and " + xmlCon.selectSingleNode(nodelist.item(i),".//sql").getFirstChild().getNodeValue()+"\n";
					if (sqlStr.indexOf("@")==-1){
						strWhere += sqlStr;
						whereCnt++;
					}else{
						strWhere += "--" + sqlStr;
					}
				}
			}
			//S@Ăꍇ́AWhereRgɂB
//			if (whereCnt==0){
//				strWhere = "-- " + strWhere;
//			}

			return strWhere;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getJoinStr() {
		try {
//			String strJoin = "where 'mode'!='viewer' "+"\n";
			String strJoin = "where 1=1 "+"\n";
			Node xmlNode = xmlCon.selectSingleNode(xmlDoc,"//RDBModel");
			NodeList nodelist = xmlCon.selectNodes(xmlNode,"//RDBModel/joins/join");

			for(int i=0;i<nodelist.getLength();i++){
//				xmlCon.selectSingleNode(nodelist.item(i),"//table1");
				if(i==0){
					strJoin += "    and " + getJoinTableStr(nodelist.item(i))+"\n";
				}else{
					strJoin += "    and " + getJoinTableStr(nodelist.item(i))+"\n";
				}
			}
			return strJoin;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getJoinTableStr(Node node) {
		try {
			String strJoin = " ";
			Node tableNode1 = xmlCon.selectSingleNode(node,".//table1");
			strJoin =((Element)tableNode1).getAttribute("tablename");
			tableNode1 = xmlCon.selectSingleNode(tableNode1,".//join_column");
			strJoin+="."+tableNode1.getFirstChild().getNodeValue();

			Node tableNode2 = xmlCon.selectSingleNode(node,".//table2");
			strJoin += " = " + ((Element)tableNode2).getAttribute("tablename");
			tableNode2 = xmlCon.selectSingleNode(tableNode2,".//join_column");
			strJoin+="."+tableNode2.getFirstChild().getNodeValue();
			return strJoin;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getGroupByStr(String kind) {
		try {
			String strGroupBy = "group by "+"\n";
			Node xmlNode = xmlCon.selectSingleNode(xmlDoc,"//db_table");
			NodeList nodelist = null;
			Node tempNode=null;

			//Selectɑ̂܂Ƃ߂Ď擾ii荞݂́ASortŁBj
			if(kind.equals("all")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/select_clause/logical_column[@groupbyflg='true']");//
			}else if(kind.equals("use_flg")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/select_clause/logical_column[@use_flg='1']");//@groupbyflg='true' and 
			}

			if(nodelist.getLength()==0){//ꍇ́AԂȂiFactTablepj
				return "";
			}

			boolean first_flg=true;
			for(int i=0;i<nodelist.getLength();i++){
//System.out.println(xmlCon.toXMLText(nodelist.item(i)));
				//SortȂ̂ŁAԍĂ鑮w肵āASelectSingleNodeB
				if(kind.equals("all")){
					tempNode = nodelist.item(i);
				}else if(kind.equals("use_flg")){
					tempNode = xmlCon.selectSingleNode(xmlDoc,"//db_table/logical_model/select_clause/logical_column[@use_order='"+i+"' and @groupbyflg='true' and @use_flg='1']");
				}
				if(tempNode!=null){
					if(first_flg==true){
						strGroupBy += "     " + xmlCon.selectSingleNode(tempNode,".//sql").getFirstChild().getNodeValue()+"\n";
						first_flg=false;
					}else{
						strGroupBy += "    ," + xmlCon.selectSingleNode(tempNode,".//sql").getFirstChild().getNodeValue()+"\n";
					}
				}
			}
			return strGroupBy;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getOrderByStr(String kind) {
		try {
			String strOrderBy = "order by "+"\n";
			Node xmlNode = xmlCon.selectSingleNode(xmlDoc,"//db_table");
			NodeList nodelist = null;
			Node tempNode=null;

			if(kind.equals("all")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/select_clause/logical_column[@groupbyflg='true']");//
			}else if(kind.equals("use_flg")){
				nodelist = xmlCon.selectNodes(xmlNode,"//db_table/logical_model/select_clause/logical_column[@use_flg='1']");//@groupbyflg='true' and 
			}

			if(nodelist.getLength()==0){//ꍇ́AԂȂiFactTablepj
				return "";
			}

			boolean first_flg=true;
			for(int i=0;i<nodelist.getLength();i++){
				if(kind.equals("all")){
					tempNode = nodelist.item(i);
				}else if(kind.equals("use_flg")){
					tempNode = xmlCon.selectSingleNode(xmlDoc,"//db_table/logical_model/select_clause/logical_column[@use_order='"+i+"' and @groupbyflg='true' and @use_flg='1']");
				}
				if(tempNode!=null){
					if(first_flg==true){
						strOrderBy += "     " + xmlCon.selectSingleNode(tempNode,".//sql").getFirstChild().getNodeValue()+"\n";
						first_flg=false;
					}else{
						strOrderBy += "    ," + xmlCon.selectSingleNode(tempNode,".//sql").getFirstChild().getNodeValue()+"\n";
					}
				}
			}
			return strOrderBy;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String getLimitStr() {
		try {
			String strFrom = " limit 10000 "+"\n";
			return strFrom;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}


}
