/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresAxisDAO.java
 *  FIuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/13
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import openolap.viewer.Axis;
import openolap.viewer.AxisMember;
import openolap.viewer.Dimension;
import openolap.viewer.Edge;
import openolap.viewer.Measure;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.Constants;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;


/**
 *  NXFPostgresAxisDAO<br>
 *  FIuWFNg̉iǗNXłB
 */
public class PostgresAxisDAO implements AxisDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	// ********** RXgN^ **********

	/**
	 * IuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresAxisDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * NCAg瑗Mꂽp[^ƂɁÃõZN^IAh𔽉fB
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registSelectedMemberAndDrillStat(RequestHelper helper, CommonSettings commonSettings) {

		HttpServletRequest request = helper.getRequest();
		Report report = (Report)helper.getRequest().getSession().getAttribute("report");

		String axisID = null;
		for (int i = 0; i < report.getTotalDimensionNumber()+1; i++ ) {	// fBV{P(W[)s

			if (i == report.getTotalDimensionNumber()) {	// W[
				axisID = Constants.MeasureID;
			} else {										// fBV
				axisID = Integer.toString(i+1);				// ID1start̂߁A␳B
			}

			String selectedMemberAndDrillStat = (String)request.getParameter("dim" + axisID);	// NCAg̑MĂp[^擾

			// axiso[̑I󋵂ɍXV
			Axis axis = report.getAxisByID(axisID);

			// ZN^IAhIuWFNgɃZbg
			if (!selectedMemberAndDrillStat.equals("")) {	// ZN^I̓h̗͂XVꂽ

				// 鎲̑Iς݂ł郁oKey,̃hԂvalueƂHashMap𐶐
				HashMap memberNameDrillMap = new HashMap();
				ArrayList selectedMemberAndDrillStatList = StringUtil.splitString(selectedMemberAndDrillStat,",");
				Iterator it = selectedMemberAndDrillStatList.iterator();
				while (it.hasNext()) {
					String aSelectedMemberAndDrillStat = (String) it.next();
					ArrayList aSelectedMemberAndDrillStatList = StringUtil.splitString(aSelectedMemberAndDrillStat,":");
				
					String selectedMemberUniqueName = (String) aSelectedMemberAndDrillStatList.get(0); // Iς݃õj[N
					String selectedMemberDrillStat  = (String) aSelectedMemberAndDrillStatList.get(1); // h(1:h,0:h)
					memberNameDrillMap.put(selectedMemberUniqueName, selectedMemberDrillStat);
				}

				// o[AhXV
				if(axis instanceof Dimension){	// fBV
					Dimension dim = (Dimension)axis;
					dim.setSelectedMemberDrillStat(memberNameDrillMap);
				} else if (axis instanceof Measure){// W[FW[oɑ΂AZN^őIꂽoǂɐݒ肵Ă
					Iterator axisMemIt = axis.getAxisMemberList().iterator();
					while (axisMemIt.hasNext()) {
						AxisMember axisMember = (AxisMember) axisMemIt.next();
						if (memberNameDrillMap.containsKey(axisMember.getUniqueName())) {	// ZN^őIꂽo
							axisMember.setIsSelected(true);
						} else {															// ZN^őIȂo
							axisMember.setIsSelected(false);
						}
					}
				}

				// ftHgo[XV(ftHgoZN^ŊOꂽꍇAftHgoݒ)
				axis.modifyDefaultMember(memberNameDrillMap);

			} else {	// ̎ɂẮAZN^IAh񂪍XVȂ
				// Ȃ
			}
		}
	}


	/**
	 * f[^\[X擾|[gݒfɔfB
	 * @param report ReportIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void applyAxis(Report report, CommonSettings commonSettings, Connection conn) throws SQLException {

		ArrayList colIdList = new ArrayList();
		ArrayList rowIdList = new ArrayList();
		ArrayList pageIdList = new ArrayList();
	
		String SQL = "";
		SQL += "select ";
		SQL += "    axis_id, ";
		SQL += "    dimension_seq, ";
		SQL += "    default_mem_key, ";
		SQL += "    selecter_usedFLG, ";
		SQL += "    edge_type, ";
		SQL += "    in_edge_index, ";
		SQL += "    disp_mem_name_type ";
		SQL += "from ";
		SQL += "    oo_v_axis ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID() + " ";
		SQL += "order by ";
		SQL += "    edge_type,in_edge_index";
//System.out.println("apply axis SQL:" + SQL);
	
		Statement stmt = null;
		ResultSet rs = null;
	
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);
			while ( rs.next() ) {

				String axisID = rs.getString("axis_id");

				// zuꏊ擾
				if (Constants.Col.equals(rs.getString("edge_type"))) {
					colIdList.add(axisID);	
				} else if (Constants.Row.equals(rs.getString("edge_type"))) {
					rowIdList.add(axisID);
				} else if (Constants.Page.equals(rs.getString("edge_type"))) {
					pageIdList.add(axisID);
				} else {
					throw new IllegalStateException();
				}

				// defaultMemberKeyAisUsedSelecterAdispMemberNameType̍XV
				Axis axis = report.getAxisByID(axisID);
				axis.setDefaultMemberKey(rs.getString("default_mem_key"));
				axis.setUsedSelecter(CommonUtils.FLGTobool(rs.getString("selecter_usedFLG")));
				if(!axis.isMeasure()) {
					((Dimension)axis).setDispMemberNameType(rs.getString("disp_mem_name_type"));
				}

				// o̍XV
				AxisMemberDAO axisMemberDAO = DAOFactory.getDAOFactory().getAxisMemberDAO(conn,axis);
				axisMemberDAO.applyAxis(report, axis, commonSettings);

			}

			// zuꏊXV
			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			daoFactory.getReportDAO(conn).registAxisPosition(colIdList, rowIdList, pageIdList, report);

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

	}

	/**
	 * NCAg瑗Mꂽp[^ƂɁAf̎o[̃ftHgoXVB
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registDefaultMember(RequestHelper helper, CommonSettings commonSettings) {
		
		HttpServletRequest request = helper.getRequest();
		String defaultMembers = (String)request.getParameter("defaultMembers");
		if ( (defaultMembers == null) || (defaultMembers == "")) {
			throw new IllegalStateException();
		}
		// FID.UNaměJԂ(J}؂AID̏)
		// @@@F1.0,2.NA,16.0
		//@@@@@@1.0:AxisID=1̃fBṼftHgoUName
		//@@@@@@2.NA:AxisID=2̃fBṼftHgoUNameiݒ̏ꍇ́ANAƂj
		//@@@@@@16.0:AxisID=16(W[)̃ftHgoUName

		Report report = (Report)helper.getRequest().getSession().getAttribute("report");

		ArrayList defaultMemberList = StringUtil.splitString(defaultMembers, ",");
		Iterator it = defaultMemberList.iterator();
		int measureIndex = defaultMemberList.size();
//System.out.println("measureIndex:" + measureIndex);

		while (it.hasNext()) {

			//AftHgo擾
			String axisIdAndDefaultMemberString = (String) it.next();
			ArrayList axisIdAndDefaultMemberList = StringUtil.splitString(axisIdAndDefaultMemberString, ".");
			String axisID = (String) axisIdAndDefaultMemberList.get(0);
			String defaultMember = (String) axisIdAndDefaultMemberList.get(1);
		
			//ftHgoݒ肳ĂȂԂClientł́AuNAvŕ\B
			if (defaultMember.equals("NA")) {
				defaultMember = null;
			}

//System.out.println("axisDAO axisID" + axisID);
			report.getAxisByID(axisID).setDefaultMemberKey(defaultMember);	// ftHgoXV

		}
	}

	/**
	 * f[^\[X֕ۑB
	 * @param report ReportIuWFNg
	 * @param reportID |[gID
	 *                ̃p[^NULL̏ꍇAReportIuWFNg|[gIDŎۑB
	 *                  NULLł͂Ȃꍇ́AreportIDp[^̒lŎۑB
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void saveAxis(Report report, String reportID, Connection conn) throws SQLException {

		// ۑΏۂƂȂ郌|[gID߂
		String reportIDValue = null;
		if (reportID == null) {
			reportIDValue = report.getReportID();
		} else {
			reportIDValue = reportID;
		}
		
		String SQL = "";
		Statement stmt = null;
		stmt = conn.createStatement();

		try {
		
			Iterator edgeIt = report.getEdgeList().iterator();
			while (edgeIt.hasNext()) {
				Edge edge = (Edge) edgeIt.next();
				Iterator axisIt = edge.getAxisList().iterator();
	
				int axisIndex = 0;
				while (axisIt.hasNext()) {
					Axis axis = (Axis) axisIt.next();
	
					String dispMemberNameType;
					String dimensionSeq;
					if(axis instanceof Dimension){
						dispMemberNameType = "'" + ((Dimension)axis).getDispMemberNameType() + "'";
						dimensionSeq = ((Dimension)axis).getDimensionSeq();
					} else {
						dispMemberNameType = "null";
						dimensionSeq = "0";
					}
	
					SQL =  "";
					SQL += "UPDATE oo_v_axis set";	
					SQL += "    default_mem_key=" + axis.getDefaultMemberKey() + ", ";
					SQL += "    dimension_seq=" + dimensionSeq + ", ";
					SQL += "    selecter_usedFLG='" + CommonUtils.boolToFLG(axis.isUsedSelecter()) + "', ";
					SQL += "    edge_type='" + edge.getPosition() + "', ";
					SQL += "    in_edge_index=" + axisIndex + ", ";
					SQL += "    disp_mem_name_type=" + dispMemberNameType + " ";
					SQL += "WHERE ";
					SQL += "    report_id=" + reportIDValue + " and ";
					SQL += "    axis_id=" + axis.getId();
//System.out.println("update report:" + SQL);
	
						int updateCount = stmt.executeUpdate(SQL);
	
						// update0̏ꍇAVɃR[h쐬
						if (updateCount == 0) {
	
							SQL = "";
							SQL += "INSERT INTO ";
							SQL += "    oo_v_axis ";
							SQL += "       (report_id, axis_id, dimension_seq, name, default_mem_key, selecter_usedflg, edge_type, in_edge_index, disp_mem_name_type) ";
							SQL += "values ( ";
							SQL +=                reportIDValue + ", ";
							SQL +=                axis.getId() + ", ";
							SQL +=                dimensionSeq + ", ";
							SQL +=          "'" + axis.getName() + "', ";
							SQL +=                axis.getDefaultMemberKey() + ", ";
							SQL +=          "'" + CommonUtils.boolToFLG(axis.isUsedSelecter()) + "', ";
							SQL +=          "'" + edge.getPosition() + "', ";
							SQL +=                axisIndex + ", ";
							SQL +=                dispMemberNameType;
							SQL +=         ")";
//System.out.println("saveAxis:" + SQL);
		
							int insertCount = stmt.executeUpdate(SQL);
							if (insertCount != 1) {
								throw new IllegalStateException();
							}
						}

					// o[̕ۑ
					DAOFactory daoFactory = DAOFactory.getDAOFactory();
					AxisMemberDAO axisMemDAO = daoFactory.getAxisMemberDAO(conn, axis);
					axisMemDAO.saveAxisMember(report, reportID, axis, conn);

					axisIndex++;
				}
			}

		} catch (SQLException e) {
			throw e;
		} catch (IllegalStateException e) {
			throw e;
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}

		
		
		
	}

	/**
	 * ^ꂽ|[g̑SĂ̎̏f[^\[X폜B
	 * @param report ReportIuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteAxes(Report report, Connection conn) throws SQLException {

		// ̍폜
		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_axis ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID();

		Statement stmt = null;
		try {
			stmt = conn.createStatement();
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}

		// o̍폜
		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		AxisMemberDAO axisMemDAO = daoFactory.getAxisMemberDAO(conn, null);
		axisMemDAO.deleteAxisMember(report, conn);

	}

	/**
	 * ^ꂽ̏f[^\[X폜B
	 * @param report |[gIuWFNg
	 * @param axis IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteAxis(Report report, Axis axis, Connection conn) throws SQLException {

		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_axis ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID() + " and ";
		SQL += "    axis_id=" + axis.getId();

		Statement stmt = null;
		try {
			stmt = conn.createStatement();
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}

	}

}
