#include "ja_config_gtk.h"

/*
OpenOffice.org ܸƳץ

"JCP_"ǻϤޤja_config.hƤޤ
*/

int main(int argc, char *argv[])
{
  /* ᥤ󥦥ɥ */
  GtkWidget *window;

  /* ᥤ󥳥ƥ(եåɥƥ) */
  GtkWidget *main_container;

  /* ¦ɽط */
  GtkWidget *logo;
  GdkPixmap *logo_pixmap;
  GdkBitmap *logo_mask;
  GtkStyle *logo_style;

  /* ɥɽܥ  */
  GtkWidget *button_prev;  /* ""ܥ */
  GtkWidget *button_next;  /* ""ܥ */
  GtkWidget *button_exit;  /* "λ"ܥ */

  /*--------------------------------------------------*/
  /* gtkν */
  /*--------------------------------------------------*/
  
  /*  */
  gtk_set_locale();

  /* gtk+Ϣΰ */
  gtk_init(&argc, &argv);

  /*--------------------------------------------------*/
  /* ᥤ󥦥ɥ˴ؤ */
  /*--------------------------------------------------*/

  /* ɥκ */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  /* ȥ */
  gtk_window_set_title(GTK_WINDOW(window), "OpenOffice.orgܸƳץ");
  /* ٥Ȥ(ɥĤ饢ץꥱλ) */
  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(close_application), NULL);
  /* ܡ0 */
  gtk_container_set_border_width(GTK_CONTAINER(window), 0);
  /* 桼ˤäƥɥꥵʤ褦 */
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, TRUE);
  /* ɥΥ */
  gtk_widget_set_usize(window, JCP_WINDOW_WIDTH, JCP_WINDOW_HEIGHT);  
  /* ɥɽ */
  gtk_widget_show(window);

  /*--------------------------------------------------*/
  /* եåɥƥʤǤᥤ󥳥ƥʤ */
  /*--------------------------------------------------*/

  /* եåɥƥʤκ */
  main_container = gtk_fixed_new();

  /* ᥤ󥦥ɥ֡ɽ */
  gtk_container_add(GTK_CONTAINER(window), main_container);
  gtk_widget_show(main_container);

  /*--------------------------------------------------*/
  /* "logo.xmp"ɤ߹XPMΥ˴ؤ */
  /*--------------------------------------------------*/

  /* 롢ԥޥåפåȤ */
  logo_style = gtk_widget_get_style(window);
  logo_pixmap = gdk_pixmap_create_from_xpm(window->window, &logo_mask, &logo_style->bg[GTK_STATE_NORMAL], JCP_LOGO_FILE);
  logo = gtk_pixmap_new(logo_pixmap, logo_mask);

  /*  */
  gtk_widget_set_usize(logo, JCP_LOGO_WIDTH, JCP_LOGO_HEIGHT);

  /* ᥤ󥳥ƥʤκɽ */
  gtk_fixed_put(GTK_FIXED(main_container), logo, JCP_LOGO_X, JCP_LOGO_Y);
  gtk_widget_show(logo);

  /*--------------------------------------------------*/
  /* ɥΥܥ˴ؤ */
  /*--------------------------------------------------*/

  /* ""ܥꤷơᥤ󥳥ƥʤɽ */
  button_prev = gtk_button_new_with_label(JCP_BUTTON_PREV_LABEL);
  gtk_widget_set_usize(button_prev, JCP_BUTTON_PREV_WIDTH, JCP_BUTTON_PREV_HEIGHT);
  gtk_fixed_put(GTK_FIXED(main_container), button_prev, JCP_BUTTON_PREV_X, JCP_BUTTON_PREV_Y);
  gtk_widget_show(button_prev);

  /* ""ܥ󤬥å줿ե졼Υƥåפˤprev_frameƤӽФ */
  gtk_signal_connect(GTK_OBJECT(button_prev), "clicked", GTK_SIGNAL_FUNC(prev_frame), GTK_OBJECT(main_container));

  /* ""ܥꤷơᥤ󥳥ƥʤɽ */
  button_next = gtk_button_new_with_label(JCP_BUTTON_NEXT_LABEL);
  gtk_widget_set_usize(button_next, JCP_BUTTON_NEXT_WIDTH, JCP_BUTTON_NEXT_HEIGHT);
  gtk_fixed_put(GTK_FIXED(main_container), button_next, JCP_BUTTON_NEXT_X, JCP_BUTTON_NEXT_Y);  
  gtk_widget_show(button_next);

  /* ""ܥ󤬥å줿ե졼򼡤Υƥåפˤnext_frameƤӽФ */
  gtk_signal_connect(GTK_OBJECT(button_next), "clicked", GTK_SIGNAL_FUNC(next_frame), GTK_OBJECT(main_container));

  /* "λ"ܥꤷơᥤ󥳥ƥʤɽ */
  button_exit = gtk_button_new_with_label(JCP_BUTTON_EXIT_LABEL);
  gtk_widget_set_usize(button_exit, JCP_BUTTON_EXIT_WIDTH, JCP_BUTTON_EXIT_HEIGHT);
  gtk_fixed_put(GTK_FIXED(main_container), button_exit, JCP_BUTTON_EXIT_X, JCP_BUTTON_EXIT_Y);  
  gtk_widget_show(button_exit);

  /* "λ"ܥ󤬥å줿ɽƥץꥱλclose_applicationƤӽФ */
  gtk_signal_connect(GTK_OBJECT(button_exit), "clicked",
		     GTK_SIGNAL_FUNC(close_application), NULL);

  /*--------------------------------------------------*/
  /* Step1Υե졼ɽ */
  /*--------------------------------------------------*/
  change_frame(main_container, 0);

  /*--------------------------------------------------*/
  /* gtk+ˤᥤ롼פ */
  /*--------------------------------------------------*/
  gtk_main();

  return(0);
}

void next_frame(GtkObject *object){
  change_frame(GTK_WIDGET(object), 1);
}

void prev_frame(GtkObject *object){
  change_frame(GTK_WIDGET(object), -1);
}

void change_frame(GtkWidget *main_container, gint n){
  /* ߤΥƥåֹŪ˵ */
  static int step_num = 0;

  /* Step1 */
  static GtkWidget *frame1;
  static GtkWidget *frame1_vbox_container;
  static GtkWidget *frame1_label_thanks;

  /* Step2 */
  static GtkWidget *frame2;
  static GtkWidget *frame2_hbox_container;
  static GtkWidget *frame2_text_lisence;
  static GtkWidget *frame2_text_vscrollbar;

  /* Step3 */
   static GtkWidget *frame3;
   static GtkWidget *frame3_vbox_container;
   static GtkWidget *frame3_label_ooo_dir;
   static GtkWidget *frame3_entry_ooo_dir;
   static GtkWidget *frame3_label_gothic_font;
   static GtkWidget *frame3_entry_gothic_font;
   static GtkWidget *frame3_label_mincho_font;
   static GtkWidget *frame3_entry_mincho_font;
   static GtkWidget *frame3_label_ui_font;
   static GtkWidget *frame3_entry_ui_font;
   static GtkWidget *frame3_label_notice;

   char command[1024];

   /* Step4 */
   static GtkWidget *frame4;
   static GtkWidget *frame4_vbox_container;
   static GtkWidget *frame4_label_finish;
  
  if(step_num != 0){  /* Ǥ˽Ƥ */
    /* ɽƤ륹ƥåפΥե졼ɽˤ */
    switch(step_num){
    case 1:
      gtk_widget_hide(frame1);
      gtk_widget_hide(frame1_vbox_container);
      gtk_widget_hide(frame1_label_thanks);
      break;
    case 2:
      gtk_widget_hide(frame2);
      gtk_widget_hide(frame2_hbox_container);
      gtk_widget_hide(frame2_text_lisence);
      gtk_widget_hide(frame2_text_vscrollbar);
      break;
    case 3:
      /* ja_configץȤ˽Ϥ */
      if(n == 1){/* ּءץܥ򲡤ˤΤ */
	sprintf(command, "./ja_config -g %s -m %s -u %s %s",
		gtk_entry_get_text(GTK_ENTRY(frame3_entry_gothic_font)),
		gtk_entry_get_text(GTK_ENTRY(frame3_entry_mincho_font)),
		gtk_entry_get_text(GTK_ENTRY(frame3_entry_ui_font)),
		gtk_entry_get_text(GTK_ENTRY(frame3_entry_ooo_dir)));
	system(command);
      }

      gtk_widget_hide(frame3);
      gtk_widget_hide(frame3_vbox_container);
      gtk_widget_hide(frame3_label_ooo_dir);
      gtk_widget_hide(frame3_entry_ooo_dir);
      gtk_widget_hide(frame3_label_gothic_font);
      gtk_widget_hide(frame3_entry_gothic_font);
      gtk_widget_hide(frame3_label_mincho_font);
      gtk_widget_hide(frame3_entry_mincho_font);
      gtk_widget_hide(frame3_label_ui_font);
      gtk_widget_hide(frame3_entry_ui_font);
      gtk_widget_hide(frame3_label_notice);
      break;
    case 4:
      gtk_widget_hide(frame4);
      gtk_widget_hide(frame4_vbox_container);
      gtk_widget_hide(frame4_label_finish);
    }
  }

  if(n == 0 || step_num == 0){  /* Ƥʤ䡢ꥻåȤ褦n0Ϳ줿 */
    /* ƥåֹꥻå */
    step_num = 1;
    
    /*--------------------------------------------------*/
    /* ƥե졼ν */
    /*--------------------------------------------------*/
    
    /*##################################################*/
    /* Step1 */
    /*  OpenOffice.orgܸΤΥץǤ뤳Ȥ  */
    /*##################################################*/
    /* ե졼 */
    frame1 = gtk_frame_new(NULL);
  
    /* դǡ٥"Step1"Ⱥüɽ褦 */
    gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_OUT);
    gtk_frame_set_label(GTK_FRAME(frame1), "Step1");
    gtk_frame_set_label_align(GTK_FRAME(frame1), 0.0, 0.0);
    
    /*  */
    gtk_widget_set_usize(frame1, JCP_FRAME_WIDTH, JCP_FRAME_HEIGHT);
    
    /* ܡ0 */
    gtk_container_set_border_width(GTK_CONTAINER(frame1), 0);
    
    /* ᥤ󥳥ƥʤ */
    gtk_fixed_put(GTK_FIXED(main_container), frame1, JCP_FRAME_X, JCP_FRAME_Y);
    
    /*..................................................*/
    /* Step1Υե졼Υƥʤľܥå */
    /*..................................................*/
    /* ľƥʤκ */
    frame1_vbox_container = gtk_vbox_new(FALSE, 0);

    /* ܡ8 */
    gtk_container_set_border_width(GTK_CONTAINER(frame1_vbox_container), 8);
    
    /* Step1Υե졼 */
    gtk_container_add(GTK_CONTAINER(frame1), frame1_vbox_container);
    
    /*..................................................*/
    /* Step1Υե졼˥å */
    /*..................................................*/
    /* "OpenOffice.org ܸƳץ..."ɽ٥ */
    frame1_label_thanks = gtk_label_new(JCP_TEXT_THANKS);
    
    /* ƥȤιԤưŪޤ֤ɽ֤¦ˡ380 */
    gtk_label_set_line_wrap(GTK_LABEL(frame1_label_thanks), TRUE);
    gtk_label_set_justify(GTK_LABEL(frame1_label_thanks), GTK_JUSTIFY_LEFT);
    gtk_widget_set_usize(frame1_label_thanks, 360, 0);

    /* Step1Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame1_vbox_container), frame1_label_thanks, TRUE, TRUE, 0);

    /*##################################################*/
    /* Step2 */
    /*  饤󥹤ɽ  */
    /*##################################################*/
    /* ե졼 */
    frame2 = gtk_frame_new(NULL);
  
    /* դǡ٥"Step2"Ⱥüɽ褦 */
    gtk_frame_set_shadow_type(GTK_FRAME(frame2), GTK_SHADOW_OUT);
    gtk_frame_set_label(GTK_FRAME(frame2), "Step2");
    gtk_frame_set_label_align(GTK_FRAME(frame2), 0.0, 0.0);
    
    /*  */
    gtk_widget_set_usize(frame2, JCP_FRAME_WIDTH, JCP_FRAME_HEIGHT);
    
    /* ܡ0 */
    gtk_container_set_border_width(GTK_CONTAINER(frame2), 0);
    
    /* ᥤ󥳥ƥʤ */
    gtk_fixed_put(GTK_FIXED(main_container), frame2, JCP_FRAME_X, JCP_FRAME_Y);
    
    /*..................................................*/
    /* Step2Υե졼Υƥʤʿܥå */
    /*..................................................*/
    /* ʿܥåκ */
    frame2_hbox_container = gtk_hbox_new(FALSE,0);

    /* ܡ8 */
    gtk_container_set_border_width(GTK_CONTAINER(frame2_hbox_container), 8);
    
    /* Step2Υե졼 */
    gtk_container_add(GTK_CONTAINER(frame2), frame2_hbox_container);
    
    /*..................................................*/
    /* Step2Υե졼˥å */
    /*..................................................*/

    /* "OpenOffice.org ܸƳץ..."ɽƥȥܥå */
    frame2_text_lisence = gtk_text_new(NULL, NULL);
    
    /* ƥȤԽԲĤˤưԤ褦ˤ */
    gtk_text_set_editable(GTK_TEXT(frame2_text_lisence), FALSE);
    gtk_text_set_word_wrap(GTK_TEXT(frame2_text_lisence), TRUE);

    /* ɽƥȤ */
    gtk_text_insert(GTK_TEXT(frame2_text_lisence), NULL, NULL, NULL, JCP_TEXT_LISENCE, -1);

    /* Step2Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame2_hbox_container), frame2_text_lisence, TRUE, TRUE, 0);

    /* ƥȥܥåοľС */
    frame2_text_vscrollbar = gtk_vscrollbar_new(GTK_TEXT(frame2_text_lisence)->vadj);
    gtk_box_pack_start(GTK_BOX(frame2_hbox_container), frame2_text_vscrollbar, FALSE, FALSE, 0);

    /*##################################################*/
    /* Step3 */
    /*  OpenOffice.orgΥ󥹥ȡǥ쥯ȥꤵ  */
    /*##################################################*/
    /* ե졼 */
    frame3 = gtk_frame_new(NULL);
  
    /* դǡ٥"Step3"Ⱥüɽ褦 */
    gtk_frame_set_shadow_type(GTK_FRAME(frame3), GTK_SHADOW_OUT);
    gtk_frame_set_label(GTK_FRAME(frame3), "Step3");
    gtk_frame_set_label_align(GTK_FRAME(frame3), 0.0, 0.0);
    
    /*  */
    gtk_widget_set_usize(frame3, JCP_FRAME_WIDTH, JCP_FRAME_HEIGHT);
    
    /* ܡ0 */
    gtk_container_set_border_width(GTK_CONTAINER(frame3), 0);
    
    /* ᥤ󥳥ƥʤ */
    gtk_fixed_put(GTK_FIXED(main_container), frame3, JCP_FRAME_X, JCP_FRAME_Y);
    
    /*..................................................*/
    /* Step3Υե졼Υƥʤľܥå */
    /*..................................................*/
    /* ľƥʤκ */
    frame3_vbox_container = gtk_vbox_new(FALSE, 0);

    /* ܡ8 */
    gtk_container_set_border_width(GTK_CONTAINER(frame3_vbox_container), 8);
    
    /* Step3Υե졼 */
    gtk_container_add(GTK_CONTAINER(frame3), frame3_vbox_container);
    
    /*..................................................*/
    /* Step3Υե졼˥å */
    /*..................................................*/

    /* "OpenOffice.org 󥹥ȡѥ"ɽ٥ */
    frame3_label_ooo_dir = gtk_label_new(JCP_TEXT_OOO_DIR);
    
    /* ƥȤιԤưŪޤ֤ɽ֤¦ */
    gtk_label_set_line_wrap(GTK_LABEL(frame3_label_ooo_dir), FALSE);
    gtk_label_set_justify(GTK_LABEL(frame3_label_ooo_dir), GTK_JUSTIFY_LEFT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_label_ooo_dir, TRUE, FALSE, 0);

    /* OpenOffice.org 󥹥ȡѥɽƥȥܥå */
    frame3_entry_ooo_dir = gtk_entry_new();

    /* ɽƥȤ */
    gtk_entry_set_text(GTK_ENTRY(frame3_entry_ooo_dir), JCP_DEFAULT_OOO_DIR);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_entry_ooo_dir, TRUE, FALSE, 0);

    /* "åե"ɽ٥ */
    frame3_label_gothic_font = gtk_label_new(JCP_TEXT_GOTHIC_FONT);
    
    /* ƥȤιԤưŪޤ֤ɽ֤¦ */
    gtk_label_set_line_wrap(GTK_LABEL(frame3_label_gothic_font), FALSE);
    gtk_label_set_justify(GTK_LABEL(frame3_label_gothic_font), GTK_JUSTIFY_LEFT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_label_gothic_font, TRUE, FALSE, 0);

    /* OpenOffice.org 󥹥ȡѥɽƥȥܥå */
    frame3_entry_gothic_font = gtk_entry_new();

    /* ɽƥȤ */
    gtk_entry_set_text(GTK_ENTRY(frame3_entry_gothic_font), JCP_DEFAULT_GOTHIC_FONT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_entry_gothic_font, TRUE, FALSE, 0);

    /* "īե"ɽ٥ */
    frame3_label_mincho_font = gtk_label_new(JCP_TEXT_MINCHO_FONT);
    
    /* ƥȤιԤưŪޤ֤ɽ֤¦ */
    gtk_label_set_line_wrap(GTK_LABEL(frame3_label_mincho_font), FALSE);
    gtk_label_set_justify(GTK_LABEL(frame3_label_mincho_font), GTK_JUSTIFY_LEFT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_label_mincho_font, TRUE, FALSE, 0);

    /* OpenOffice.org 󥹥ȡѥɽƥȥܥå */
    frame3_entry_mincho_font = gtk_entry_new();

    /* ɽƥȤ */
    gtk_entry_set_text(GTK_ENTRY(frame3_entry_mincho_font), JCP_DEFAULT_MINCHO_FONT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_entry_mincho_font, TRUE, FALSE, 0);

    /* "UIե"ɽ٥ */
    frame3_label_ui_font = gtk_label_new(JCP_TEXT_UI_FONT);
    
    /* ƥȤιԤưŪޤ֤ɽ֤¦ */
    gtk_label_set_line_wrap(GTK_LABEL(frame3_label_ui_font), FALSE);
    gtk_label_set_justify(GTK_LABEL(frame3_label_ui_font), GTK_JUSTIFY_LEFT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_label_ui_font, TRUE, FALSE, 0);

    /* OpenOffice.org 󥹥ȡѥɽƥȥܥå */
    frame3_entry_ui_font = gtk_entry_new();

    /* ɽƥȤ */
    gtk_entry_set_text(GTK_ENTRY(frame3_entry_ui_font), JCP_DEFAULT_UI_FONT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_entry_ui_font, TRUE, FALSE, 0);

    /* "ּءץܥ򲡤ȼºݤ꤬Ϥޤ"ɽ٥ */
    frame3_label_notice = gtk_label_new(JCP_TEXT_NOTICE);

    /* ƥȤιԤưŪޤ֤ɽ֤¦ */
    gtk_label_set_line_wrap(GTK_LABEL(frame3_label_notice), FALSE);
    gtk_label_set_justify(GTK_LABEL(frame3_label_notice), GTK_JUSTIFY_LEFT);

    /* Step3Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame3_vbox_container), frame3_label_notice, TRUE, FALSE, 0);

    /*##################################################*/
    /* Step4 */
    /*  OpenOffice.orgܸΤΥץǤ뤳Ȥ  */
    /*##################################################*/
    /* ե졼 */
    frame4 = gtk_frame_new(NULL);
  
    /* դǡ٥"Step4"Ⱥüɽ褦 */
    gtk_frame_set_shadow_type(GTK_FRAME(frame4), GTK_SHADOW_OUT);
    gtk_frame_set_label(GTK_FRAME(frame4), "Step1");
    gtk_frame_set_label_align(GTK_FRAME(frame4), 0.0, 0.0);
    
    /*  */
    gtk_widget_set_usize(frame4, JCP_FRAME_WIDTH, JCP_FRAME_HEIGHT);
    
    /* ܡ0 */
    gtk_container_set_border_width(GTK_CONTAINER(frame4), 0);
    
    /* ᥤ󥳥ƥʤ */
    gtk_fixed_put(GTK_FIXED(main_container), frame4, JCP_FRAME_X, JCP_FRAME_Y);
    
    /*..................................................*/
    /* Step4Υե졼Υƥʤľܥå */
    /*..................................................*/
    /* ľƥʤκ */
    frame4_vbox_container = gtk_vbox_new(FALSE, 0);

    /* ܡ8 */
    gtk_container_set_border_width(GTK_CONTAINER(frame4_vbox_container), 8);
    
    /* Step4Υե졼 */
    gtk_container_add(GTK_CONTAINER(frame4), frame4_vbox_container);
    
    /*..................................................*/
    /* Step4Υե졼˥å */
    /*..................................................*/
    /* "ܸϽλޤ..."ɽ٥ */
    frame4_label_finish = gtk_label_new(JCP_TEXT_FINISH);
    
    /* ƥȤιԤưŪޤ֤ɽ֤¦ˡ380 */
    gtk_label_set_line_wrap(GTK_LABEL(frame4_label_finish), TRUE);
    gtk_label_set_justify(GTK_LABEL(frame4_label_finish), GTK_JUSTIFY_LEFT);
    gtk_widget_set_usize(frame4_label_finish, 360, 0);

    /* Step4Υե졼Υƥʤ */
    gtk_box_pack_start(GTK_BOX(frame4_vbox_container), frame4_label_finish, TRUE, TRUE, 0);
    
  }else if(n == 1){
    /* ߤΥƥåֹ椬JCP_MAX_STEPǤʤХƥåֹ䤹 */
    step_num = (step_num >= JCP_MAX_STEP) ? (JCP_MAX_STEP) : (step_num + 1);
  }else if(n == -1){
    /* ߤΥƥåֹ椬1ǤʤХƥåֹĸ餹 */
    step_num = (step_num <= 1) ? (1) : (step_num - 1);
  }

  switch(step_num){
  case 1:
    /* Step1ʤɽ */
    gtk_widget_show(frame1);
    gtk_widget_show(frame1_vbox_container);
    gtk_widget_show(frame1_label_thanks);
    break;
  case 2:
    /* Step2ʤɽ */
    gtk_widget_show(frame2);
    gtk_widget_show(frame2_hbox_container);
    gtk_widget_show(frame2_text_lisence);
    gtk_widget_show(frame2_text_vscrollbar);
    break;
  case 3:
    /* Step3ʤɽ */
    gtk_widget_show(frame3);
    gtk_widget_show(frame3_vbox_container);
    gtk_widget_show(frame3_label_ooo_dir);
    gtk_widget_show(frame3_entry_ooo_dir);
    gtk_widget_show(frame3_label_gothic_font);
    gtk_widget_show(frame3_entry_gothic_font);
    gtk_widget_show(frame3_label_mincho_font);
    gtk_widget_show(frame3_entry_mincho_font);
    gtk_widget_show(frame3_label_ui_font);
    gtk_widget_show(frame3_entry_ui_font);
    gtk_widget_show(frame3_label_notice);
    break;
  case 4:
    /* Step4ʤɽ */
    gtk_widget_show(frame4);
    gtk_widget_show(frame4_vbox_container);
    gtk_widget_show(frame4_label_finish);
    break;
  }
}

void close_application(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  /* ᥤ */
  GtkWidget *dialog;

  /* "OK"ܥ */
  GtkWidget *button_ok;

  /* "󥻥"ܥ */
  GtkWidget *button_cancel;

  /* "..."٥ */
  GtkWidget *label;

  /* ⡼ꤷơɽ */
  dialog = gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_widget_show(dialog);

  /* "OK"ܥaction_areaɽ */
  button_ok = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_ok, TRUE, TRUE, 0);
  gtk_widget_show(button_ok);

  /* "OK"ܥ󤬥å줿顢ץꥱλexit_applicationƤӽФ */
  gtk_signal_connect(GTK_OBJECT(button_ok), "clicked",
		     GTK_SIGNAL_FUNC(exit_application), NULL);  

  /* "󥻥"ܥaction_areaɽ */
  button_cancel = gtk_button_new_with_label("󥻥");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_cancel, TRUE, TRUE, 0);
  gtk_widget_show(button_cancel);

  /* "󥻥"ܥ󤬥å줿顢Ĥclose_dialog֥ȤϤƸƤӽФ */
  gtk_signal_connect_object(GTK_OBJECT(button_cancel), "clicked",
		     GTK_SIGNAL_FUNC(close_dialog), GTK_OBJECT(dialog));

  /* "..."٥vboxɽ */
  label = gtk_label_new("˽λƤǤ");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     label, TRUE, TRUE, 10);
  gtk_widget_show(label);
}

void close_dialog(GtkObject *object)
{
  /* Ĥ */
  GtkWidget *dialog = (GtkWidget *)object;
  
  /* ⡼ */
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

  /* ɥĤ */
  gtk_widget_destroy(dialog);
}

void exit_application(GtkWidget *widget, GdkEvent *event, gpointer data)
{

  /* ˥륹ץȤƤӽФ */
  /*system("./test.sh");*/

  gtk_main_quit();
}
