#!/bin/sh

echo "==== Installing Qt libraries required for Kylix_2-built Applications ===="
#---- Checking Current Directory ------
Folder=`find  .  -type d  -name "installing_qt_libraries" -print`
if test "$Folder" != ""; then
  cd $Folder
else
  Folder=`find  .  -type f  -name "libqt.so.2.3.0" -print`
  if test "$Folder" = ""; then
    echo "Please retry after changing current directory to 'installing_qt_libraries'."
    exit
  fi
fi
#----- Asking Target Directory -----
QTLIBDIR=/usr/libqt2
ans="n"
while test "$ans" != "y"; do
  echo "This software will be installed in '${QTLIBDIR}'"
  echo -n "Is that ok? (y/n)"  > /dev/stderr
  read ans
  if test "$ans" != "y"; then
    echo -n "Please input the target directory: " > /dev/stderr
    read QTLIBDIR
  fi
done
#------ Implement -------------------
mkdir  -p  $QTLIBDIR
mv -fv  * $QTLIBDIR
cd  $QTLIBDIR
ln  -s  $QTLIBDIR/libqtintf-6.5.0-qt2.3.so  $QTLIBDIR/libqtintf-6.5-qt2.3.so
ln  -s  $QTLIBDIR/libqt.so.2.3.0  $QTLIBDIR/libqt.so.2

echo "Installation has been completed."
