/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TreeElement<T>
implements Iterable<TreeElement<T>>,
Comparable<TreeElement<T>> {
    private T value;
    private TreeElement<T> parent = null;
    private List<TreeElement<T>> children = new ArrayList<TreeElement<T>>();

    public TreeElement() {
    }

    public TreeElement(T value) {
        this.value = value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public TreeElement<T> getParent() {
        return this.parent;
    }

    public TreeElement<T> getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public TreeElement<T> addChild(TreeElement<T> child) {
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        this.children.add(child);
        child.parent = this;
        return this;
    }

    public TreeElement<T> addChild(int index, TreeElement<T> child) {
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        this.children.add(index, child);
        child.parent = this;
        return this;
    }

    public TreeElement<T> getChild(int index) {
        if (index < 0 || index >= this.children.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.children.get(index);
    }

    public TreeElement<T>[] getChildren() {
        TreeElement[] array = new TreeElement[this.children.size()];
        int index = 0;
        while (index < this.children.size()) {
            array[index] = this.children.get(index);
            ++index;
        }
        return array;
    }

    public TreeElement<T>[] getSpecifiedLayerElements(int layer) {
        TreeElement[] array = new TreeElement[this.size(layer)];
        if (layer == 0) {
            array[0] = this;
        } else {
            int counter = 0;
            for (TreeElement<T> child : this.children) {
                TreeElement<T>[] treeElementArray = child.getSpecifiedLayerElements(layer - 1);
                int n = treeElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeElement<T> e;
                    array[counter] = e = treeElementArray[n2];
                    ++counter;
                    ++n2;
                }
            }
        }
        return array;
    }

    public TreeElement<T> removeChild(int index) {
        if (index < 0 || index >= this.children.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.children.get((int)index).parent = null;
        return this.children.remove(index);
    }

    public boolean removeChild(TreeElement<T> e) {
        if (this.children.contains(e)) {
            e.parent = null;
        }
        return this.children.remove(e);
    }

    public boolean remove(TreeElement<T> e) {
        if (this.removeChild(e)) {
            return true;
        }
        for (TreeElement<T> child : this.children) {
            if (!child.remove(e)) continue;
            return true;
        }
        return false;
    }

    public void clearChildren() {
        for (TreeElement<T> child : this.children) {
            child.parent = null;
        }
        this.children.clear();
    }

    public int size() {
        int counter = 1;
        for (TreeElement<T> child : this.children) {
            counter += child.size();
        }
        return counter;
    }

    public int size(int layer) {
        if (layer < 0) {
            throw new IllegalArgumentException();
        }
        if (layer == 0) {
            return 1;
        }
        int counter = 0;
        for (TreeElement<T> child : this.children) {
            counter += child.size(layer - 1);
        }
        return counter;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean contains(TreeElement<T> e) {
        if (this.equals(e)) {
            return true;
        }
        for (TreeElement<T> child : this.children) {
            if (!child.contains(e)) continue;
            return true;
        }
        return false;
    }

    public int layer() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.layer() + 1;
    }

    public String path(String separator) {
        if (this.parent == null) {
            return this.value.toString();
        }
        return String.valueOf(this.parent.path(separator)) + separator + this.value.toString();
    }

    @Override
    public Iterator<TreeElement<T>> iterator() {
        return new Itr(this);
    }

    public TreeElement<T>[] getAllElements() {
        TreeElement[] array = new TreeElement[this.size()];
        array[0] = this;
        int counter = 1;
        for (TreeElement<T> child : this.children) {
            TreeElement<T>[] treeElementArray = child.getAllElements();
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeElement<T> e;
                array[counter] = e = treeElementArray[n2];
                ++counter;
                ++n2;
            }
        }
        return array;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }

    public int hashCode() {
        int hash = 0;
        for (TreeElement<T> child : this.children) {
            hash += child.hashCode();
        }
        return this.value.hashCode() + hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TreeElement)) {
            return false;
        }
        TreeElement e = (TreeElement)obj;
        if (this.value != null ? !this.value.equals(e.value) : e.value != null) {
            return false;
        }
        return this.children.equals(e.children);
    }

    @Override
    public int compareTo(TreeElement<T> o) {
        if (this.value == null) {
            throw new NullPointerException();
        }
        if (!(this.value instanceof Comparable)) {
            return 0;
        }
        Comparable v = (Comparable)this.value;
        return v.compareTo(o.value);
    }

    private class Itr
    implements Iterator<TreeElement<T>> {
        private TreeElement<T>[] list;
        private int index = 0;

        public Itr(TreeElement<T> e) {
            this.list = e.getAllElements();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.length;
        }

        @Override
        public TreeElement<T> next() {
            if (this.index >= this.list.length) {
                throw new NoSuchElementException();
            }
            TreeElement e = this.list[this.index];
            ++this.index;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

