/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.ui.swing;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.black_cow.opennip.opennipcore.NipManager;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.ui.swing.MouseClickInfo;
import net.black_cow.opennip.ui.swing.UIConstant;

public class BoardLabel
extends JLabel
implements MouseListener {
    private Image white = new ImageIcon(this.getClass().getClassLoader().getResource("White.gif")).getImage();
    private Image black = new ImageIcon(this.getClass().getClassLoader().getResource("Black.gif")).getImage();
    private Point[][] points = new Point[8][8];
    private MouseClickInfo info;

    BoardLabel(ImageIcon icon, MouseClickInfo info) {
        super(icon);
        this.init();
        this.info = info;
        this.addMouseListener(this);
    }

    private void init() {
        this.points[0][2] = new Point(UIConstant.POS_COL[3], UIConstant.POS_ROW[1]);
        this.points[0][3] = new Point(UIConstant.POS_COL[4], UIConstant.POS_ROW[0]);
        this.points[0][4] = new Point(UIConstant.POS_COL[5], UIConstant.POS_ROW[0]);
        this.points[0][5] = new Point(UIConstant.POS_COL[6], UIConstant.POS_ROW[1]);
        int j = 1;
        while (j <= 6) {
            this.points[1][j] = new Point(UIConstant.POS_COL[j + 1], UIConstant.POS_ROW[2]);
            this.points[6][j] = new Point(UIConstant.POS_COL[j + 1], UIConstant.POS_ROW[7]);
            ++j;
        }
        this.points[2][0] = new Point(UIConstant.POS_COL[1], UIConstant.POS_ROW[3]);
        this.points[3][0] = new Point(UIConstant.POS_COL[0], UIConstant.POS_ROW[4]);
        this.points[4][0] = new Point(UIConstant.POS_COL[0], UIConstant.POS_ROW[5]);
        this.points[5][0] = new Point(UIConstant.POS_COL[1], UIConstant.POS_ROW[6]);
        int i = 2;
        while (i <= 5) {
            int j2 = 1;
            while (j2 <= 6) {
                this.points[i][j2] = new Point(UIConstant.POS_COL[j2 + 1], UIConstant.POS_ROW[i + 1]);
                ++j2;
            }
            ++i;
        }
        this.points[2][7] = new Point(UIConstant.POS_COL[8], UIConstant.POS_ROW[3]);
        this.points[3][7] = new Point(UIConstant.POS_COL[9], UIConstant.POS_ROW[4]);
        this.points[4][7] = new Point(UIConstant.POS_COL[9], UIConstant.POS_ROW[5]);
        this.points[5][7] = new Point(UIConstant.POS_COL[8], UIConstant.POS_ROW[6]);
        this.points[7][2] = new Point(UIConstant.POS_COL[3], UIConstant.POS_ROW[8]);
        this.points[7][3] = new Point(UIConstant.POS_COL[4], UIConstant.POS_ROW[9]);
        this.points[7][4] = new Point(UIConstant.POS_COL[5], UIConstant.POS_ROW[9]);
        this.points[7][5] = new Point(UIConstant.POS_COL[6], UIConstant.POS_ROW[8]);
    }

    void refresh(NipManager manager) {
        this.paintComponent(this.getGraphics());
        int i = 0;
        while (i <= 7) {
            int j = 0;
            while (j <= 7) {
                if ((i != 0 && i != 7 || j > 1 && j < 6) && (i != 1 && i != 6 || j != 0 && j != 7)) {
                    this.getGraphics().drawImage(this.convertColorToImage(manager.getCellColor(i, j)), this.points[i][j].x + -48, this.points[i][j].y + -48, this);
                }
                ++j;
            }
            ++i;
        }
    }

    void paint(int row, int column, NipStone.Color color) {
        this.getGraphics().drawImage(this.convertColorToImage(color), this.points[row][column].x + -48, this.points[row][column].y + -48, this);
    }

    private Image convertColorToImage(NipStone.Color color) {
        if (color == null) {
            return null;
        }
        return color.equals((Object)NipStone.Color.BLACK) ? this.black : this.white;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int[] nearestPoint = this.getNearestPoint(e.getX(), e.getY());
        this.info.setInfo(nearestPoint[0], nearestPoint[1]);
    }

    private int[] getNearestPoint(int x, int y) {
        int i = 0;
        while (i <= 7) {
            int j = 0;
            while (j <= 7) {
                if (this.points[i][j] != null && this.points[i][j].isInArea(x, y)) {
                    return new int[]{i, j};
                }
                ++j;
            }
            ++i;
        }
        return new int[2];
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class Point {
        int x;
        int y;

        private Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        boolean isInArea(int a, int b) {
            return -25 < this.x - a && this.x - a < 25 && -25 < this.y - b && this.y - b < 25;
        }
    }
}

