/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.opennipcore.NipStrategy;
import net.black_cow.opennip.opennipcore.NipTable;
import net.black_cow.opennip.opennipcore.NipTableUtil;
import net.black_cow.util.TreeElement;

public class MiniMaxStrategy
implements NipStrategy {
    private int depth;
    private Random rand;

    public MiniMaxStrategy(int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException();
        }
        this.depth = depth;
        this.rand = new Random();
    }

    @Override
    public int[] decide(NipTable table, NipStone stone) {
        TreeElement<State> e = new TreeElement<State>(new State(table, stone));
        this.serch(e, this.depth, stone.getColor());
        ArrayList<int[]> bestWays = new ArrayList<int[]>();
        int bestScore = -2;
        TreeElement<State>[] treeElementArray = e.getChildren();
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeElement<State> child = treeElementArray[n2];
            if (child.getValue().score > bestScore) {
                bestWays.clear();
                bestWays.add(child.getValue().hand);
                bestScore = child.getValue().score;
            } else if (child.getValue().score == bestScore) {
                bestWays.add(child.getValue().hand);
            }
            ++n2;
        }
        return (int[])bestWays.get(this.rand.nextInt(bestWays.size()));
    }

    private void serch(TreeElement<State> parent, int depth, NipStone.Color color) {
        if (depth == 0) {
            return;
        }
        State state = parent.getValue();
        List<int[]> possibilities = NipTableUtil.getCanPutStoneCellList(state.table, state.stone);
        if (possibilities.size() == 0) {
            possibilities = NipTableUtil.getCanPutStoneCellList(state.table, NipTableUtil.differentColorStone(state.stone));
            if (possibilities.size() == 0) {
                return;
            }
            state.stone = NipTableUtil.differentColorStone(state.stone);
        }
        for (int[] possibility : possibilities) {
            NipTable table = NipTableUtil.ifYouPutStoneAt(state.table, possibility[0], possibility[1], state.stone);
            TreeElement<State> e = new TreeElement<State>(new State(table, NipTableUtil.differentColorStone(state.stone)));
            e.getValue().hand = possibility;
            parent.addChild(e);
            this.serch(e, depth - 1, color);
            if (!e.hasChildren()) {
                this.evaluate(e, color);
                continue;
            }
            if (color.equals((Object)e.getValue().stone.getColor())) {
                this.max(e);
                continue;
            }
            this.min(e);
        }
    }

    private void evaluate(TreeElement<State> e, NipStone.Color color) {
        int blank = NipTableUtil.getStoneCount(e.getValue().table, null);
        int score = NipTableUtil.getStoneCount(e.getValue().table, color);
        int otherScore = 52 - blank - score;
        if (NipTableUtil.isFinished(e.getValue().table)) {
            if (score > otherScore) {
                e.getValue().score = 52;
            } else if (score == otherScore) {
                e.getValue().score = 0;
            } else {
                e.getValue().score = -1;
            }
            return;
        }
        e.getValue().score = NipTableUtil.getStoneCount(e.getValue().table, color);
    }

    private void max(TreeElement<State> e) {
        int maxScore = -2;
        TreeElement<State>[] treeElementArray = e.getChildren();
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeElement<State> child = treeElementArray[n2];
            if (child.getValue().score > maxScore) {
                maxScore = child.getValue().score;
            }
            ++n2;
        }
        e.getValue().score = maxScore;
    }

    private void min(TreeElement<State> e) {
        int minScore = 53;
        TreeElement<State>[] treeElementArray = e.getChildren();
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeElement<State> child = treeElementArray[n2];
            if (child.getValue().score < minScore) {
                minScore = child.getValue().score;
            }
            ++n2;
        }
        e.getValue().score = minScore;
    }

    private class State {
        private NipTable table;
        private NipStone stone;
        private int score;
        private int[] hand;

        private State(NipTable table, NipStone stone) {
            this.table = table;
            this.stone = stone;
        }
    }
}

