/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.opennipcore;

import java.util.ArrayList;
import java.util.List;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.opennipcore.NipTable;

public class NipTableUtil {
    public static boolean canPutStone(NipTable table, NipStone stone) {
        return table.canPutStone(stone);
    }

    public static boolean isFinished(NipTable table) {
        return !table.canPutStone(new NipStone(NipStone.Color.BLACK)) && !table.canPutStone(new NipStone(NipStone.Color.WHITE));
    }

    public static List<int[]> getCanPutStoneCellList(NipTable table, NipStone stone) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        int i = 0;
        while (i <= 7) {
            int j = 0;
            while (j <= 7) {
                if (table.canPutStoneAt(i, j, stone)) {
                    list.add(new int[]{i, j});
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static int getCanPutStoneCellCount(NipTable table, NipStone stone) {
        int counter = 0;
        int i = 0;
        while (i <= 7) {
            int j = 0;
            while (j <= 7) {
                if (table.canPutStoneAt(i, j, stone)) {
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        return counter;
    }

    public static int getStoneCount(NipTable table, NipStone.Color color) {
        if (color == null) {
            return table.getBlankCellCount();
        }
        return table.getStoneCount(color);
    }

    public static NipTable ifYouPutStoneAt(NipTable table, int row, int column, NipStone stone) {
        NipTable copy = table.getCopy();
        copy.putStoneAt(row, column, stone);
        return copy;
    }

    public static NipStone newStone(NipStone.Color color) {
        return new NipStone(color);
    }

    public static NipStone differentColorStone(NipStone stone) {
        return new NipStone(stone.getColor().equals((Object)NipStone.Color.BLACK) ? NipStone.Color.WHITE : NipStone.Color.WHITE);
    }

    public static int evaluate(NipTable table, NipStone.Color color, int[][] map) {
        int evaluation = 0;
        int i = 0;
        while (i <= 7) {
            int j = 0;
            while (j <= 7) {
                if ((i != 0 && i != 7 || j > 1 && j < 6) && (i != 1 && i != 6 || j != 0 && j != 7) && table.getCellColor(i, j) != null) {
                    evaluation += table.getCellColor(i, j).equals((Object)color) ? map[i][j] : -map[i][j];
                }
                ++j;
            }
            ++i;
        }
        return evaluation;
    }
}

