/*
 * OpenI2CRADIO
 * Menu sub-routines.
 * Copyright (C) 2013-06-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"
#include "backlight.h"

void toggle_amfm(void)
{
    unsigned int freq;
    if(setup.fm != 0){
        setup.fm = 0;
        setup.fmfreq_bank[setup.fmband] = setup.fmfreq;
  //      akc6955_set_amband(amband);
        freq = setup.amfreq_bank[setup.amband];
    } else {
        setup.fm = 0xff;
        setup.amfreq_bank[setup.amband] = setup.amfreq;
//        akc6955_set_fmband(fmband);
        freq = setup.fmfreq_bank[setup.fmband];
    }
    akc6955_chg_fm(setup.fm, freq);
    idle_time_ms(500);
//    akc6955_set_freq(freq);
}



void set_stereomode(void)
{
    __bitops_t mode;
    mode.byte = 0x00;
    if(setup.stereo == 0x00){
            mode.b0 = 1; // Force mono
    } else if(setup.stereo < 0x80){
            mode.b1 = 1; // Force stereo
    }
    akc6955_set_stereomode(mode.byte);
}

void set_stereo(void)
{
    
    if(setup.stereo == 0xff) {// Force Mono
        setup.stereo = 0x00;
    } else if(setup.stereo == 0x00) { //Mono->Stereo
        setup.stereo = 0x7f;
    } else { // Default, Stereo->auto
        setup.stereo = 0xff;
    }
    set_stereomode();
}

void setfreq_direct(void)
{
    unsigned long val;
    _CLS();
    _LOCATE(0,0);
    printstr("Set Freq:");
    _LOCATE(0,1);
    if(setup.fm != 0){
        // FM
        printstr("FM ");
        val = setup.fmfreq;
        val = read_numeric(val, 5, 7, 1);
        if((val & 0x80000000) != 0) return;
        setup.fmfreq = val;
    } else {
        // FM
        printstr("AM ");
        val = setup.amfreq;
        val = read_numeric(val, 5, 7, 1);
        if((val & 0x80000000) != 0) return;
        setup.amfreq = val;
    }
    akc6955_set_freq(val);
}

void setband_direct(void)
{
    unsigned long band;
    unsigned char band2;
    unsigned int freq;
    _CLS();
    _LOCATE(0,0);
    if(setup.fm != 0){
       printstr("Set Band:FM#");
       band2 = setup.fmband & 7;
       setup.fmfreq_bank[setup.fmband] = setup.fmfreq;
       band2 = pollkey_numeric(band2);
       setup.fmband = band2 & 7;
       if(setup.fmband == AKC6955_BAND_FMUSER) {
	  setup.fmfreq = setup.fm_usrbands[setup.fm_userbandnum].freq;
       } else {
	  setup.fmfreq = setup.fmfreq_bank[setup.fmband];
       }
       akc6955_set_fmband(setup.fmband);
       freq = setup.fmfreq;
    } else {
        printstr("Set Band:AM#");
        band = setup.amband & 0x1f;
        setup.amfreq_bank[setup.amband] = setup.amfreq;
        band = read_numeric(band, 2, 7, 1);
        if((band & 0x80000000) != 0) return;
        setup.amband = band & 0x1f;
        switch(setup.amband) {
	 case AKC6955_BAND_LW:
	 case AKC6955_BAND_MW2:
	   setup.am_mode3k = 0xff;
	   break;
	 case AKC6955_BAND_AMUSER:
	   setup.am_mode3k = setup.am_usrbands[setup.am_userbandnum].mode3k;
	   break;
	 default:
	   setup.am_mode3k = 0;
	   break;
	}
        if(setup.amband == AKC6955_BAND_AMUSER) {
	   setup.amfreq = setup.am_usrbands[setup.am_userbandnum].freq;
	} else {
	   setup.amfreq = setup.amfreq_bank[setup.amband];
	}
       
        akc6955_set_amband(setup.amband);
        akc6955_mode3k(setup.am_mode3k);
        freq = setup.amfreq;
    }
    akc6955_do_tune();
    akc6955_set_freq(freq);
}

void menu_poweroff(void)
{
    unsigned char c;
    c = printhelp_2lines("Poweroff", "A=Yes");
    if(c == charcode_a) {
        shutdown(1);
    }
}

void menu_setfmresolution(void)
{
   unsigned char c;
    if(setup.fm != 0){
       _CLS();
       _LOCATE(0,0);
        c = akc6955_get_scanrate_fm();
        printstr("FM pitch:");
        c = pollkey_numeric(c);
        setup.fm_tunepitch = c & 3;
        akc6955_set_scanrate_fm(c);
        _CLS();
        _LOCATE(0,0);
    }
}

        


void setup_akc6955(void)
{
    akc6955_writecmd(AKC6955_POWER, 0xc0);  // You musto *not* mute, set b2 to '0".
    akc6955_writecmd(AKC6955_VOLUME, 0xc0); // You must select to radio(b1 = '0).
    if(setup.fm == 0) {
        akc6955_set_amband(setup.amband);
        if(setup.amband == AKC6955_BAND_AMUSER) call_userband(setup.am_userbandnum);
        setup.amfreq = setup.amfreq_bank[setup.amband];
        akc6955_chg_fm(0, setup.amfreq); // Set to AM
        akc6955_set_freq(setup.amfreq);
    } else {
        akc6955_set_fmband(setup.fmband);
        if(setup.fmband == AKC6955_BAND_FMUSER) call_userband(setup.fm_userbandnum);
        setup.fmfreq = setup.fmfreq_bank[setup.fmband];
        akc6955_chg_fm(0xff, setup.fmfreq); // Set to AM
        akc6955_set_freq(setup.fmfreq);
    }// Dummy, TBS (954KHz)
    akc6955_set_power(0xff); // Power ON
    akc6955_setvolume(36); // Temporally
    akc6955_set_thresh_fmcnr(setup.threshold_fmcnr);
    akc6955_set_thresh_amcnr(setup.threshold_amcnr);
    akc6955_set_thresh_width(setup.threshold_width);
    akc6955_set_thresh_fmstereo(setup.threshold_fmstereo);
    akc6955_setvolumemode(0);
    akc6955_set_lowboost(setup.lowboost);
    akc6955_set_scanrate_fm(setup.fm_tunepitch & 3);
    set_stereomode();
}

/*
 * Main Menu : initial-screen -> 'F'.
 */
void main_menu(void)
{
    unsigned char c;
    unsigned char d;
    unsigned int val;
    unsigned int freq;

    printhelp_2lines("Menu:F=HELP", "B=CANCEL");
    c = pollkey_single(); // 1012ms
    switch(c) {
        case charcode_1:
            // Band
            setband_direct();
            break;
        case charcode_3:
            // Band
            setfreq_direct();
            break;
        case charcode_4:
            on_call_userfreq();
            break;
            // Scan
        case charcode_5:
            break;
        case charcode_6:
            on_set_userfreq();
            break;
            // Scan
        case charcode_7:
            menu_poweroff();
            break;
        case charcode_8:
            // Set volume
            set_volume();
            break;
        case charcode_9:
            freq = akc6955_get_freq();
            akc6955_set_freq(freq);
            break;
        case charcode_0:
            // Setup Menu
            setup_menu();
            break;
        case charcode_a:
            toggle_amfm();
            break;
        case charcode_c:
            set_userband();
            break;
        case charcode_d:
            input_userband();
            break;
        case charcode_e:
            menu_setfmresolution();
            break;
     case charcode_f:
            mainmenu_help();
            // HELP
            break;
        default:
            break;
        }
       _CLS();
       _LOCATE(0,0);
}

