<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<!-- 2017/10/20 T.OTA 05100-170908-06 クラウド上で動作する場合は、ストレージからダウンロードサーブレットに遷移するように対応。 -->

<og:head headType="init" />
<og:requestCache cacheKey="{@GUI.KEY}" />

<og:fileUD typeDownload="true">
	<!-- 元がリクエストでなく、LASTSQLがnullでなければ、元のDBTableModelを、scope="request" に、コピー(ポインタのみ)している。 -->
	<og:query
		command		= "NEW"
		maxRowCount	= "0"
		quotCheck	= "false"
		scope		= "request"
		mainTrans	= "false"
		queryType	= "{@USER.LASTSQLTYPE}"
		names		= "{@USER.LASTNAMES}">
			{@USER.LASTSQL}
	</og:query>
</og:fileUD>

<og:value command="SET" key="MODELNAME">
	<og:userInfo command="GET" key="REPORT_DEFAULT_MODELNAME_{@GAMENID}" />
</og:value>

<og:equals val1="{@MODELNAME}" isNull="true">
	<og:value command="SET" key="MODELNAME" value="{@SYS.TABLE_WRITER_DEFAULT_CLASS}" defaultVal="Default" />
</og:equals>

<!-- 8.0.1.1 (2021/11/12) MODELNAMEのｺｰﾄﾞﾘｿｰｽの名前(短)に拡張子を記述している -->
<og:value command="SET" key="MDLCODE" value="MODELNAME.{@MODELNAME}" />
<og:value command="SET" key="SUFIX"   value="{@LBL.@MDLCODE %R}" />		<!-- %R はﾗﾍﾞﾙ短の生ﾃﾞｰﾀ -->

<!-- 6.2.0.0 (2015/02/27) EXCELファイルの形式(xls/xlsx)を、個人設定可 に変更 -->
<og:equals val1="{@SUFIX}" isNull="true">
	<og:value command="SET" key="SUFIX" value="{@SYS.TABLE_WRITER_EXCEL_TYPE}" defaultVal="xlsx" />
</og:equals>

<!-- 8.0.1.1 (2021/11/12) MODELNAMEの対応表は無くす -->
<!-- ただし、互換性の観点から、XLSNR だけは、当面残しておく -->
<og:equals val1="XLSNR" val2="{@MODELNAME}">
	<og:value command="SET" key="MODELNAME"	value="Excel" />
	<og:value command="SET" key="SUFIX"		value="xlsx" />
</og:equals>

<og:equals val1="{@MODELNAME}" val2="Renderer" contains="true">
	<og:value command="SET" key="CLMS"		value="{@DB.CLM_NAMES}"/>
</og:equals>

<!-- 7.2.5.0 (2020/06/01) 最初に既存のﾌｧｲﾙを消しておきます。 -->
<og:file action="delete" useLocal="true" fileURL="{@USER.ID}" file1="fileout.{@SUFIX}" useStop="false" />

<og:writeTable
	writerClass	= "{@MODELNAME}"
	fileURL		= "{@USER.ID}"
	filename	= "fileout.{@SUFIX}"
	columns		= "{@CLMS}"
	encode		= "{@SYS.FILE_ENCODE}"
	scope		= "request"
	useLocal	= "true"
/>

<!-- 7.2.5.0 (2020/06/01) ﾌｧｲﾙが存在しなければ、ここで停止します。 -->
<og:file action="exists" useLocal="true" fileURL="{@USER.ID}" file1="fileout.{@SUFIX}" >
	<og:message lbl="ERR0042" />
</og:file>

<!-- ﾀﾞｳﾝﾛｰﾄﾞｻｰﾌﾞﾚｯﾄは、ｸﾗｳﾄﾞ経由しない(useLocal=true) -->
<og:forward page="{@SYS.JSP}/fileDownload" useRedirect="true"
	keys="file,name,useLocal"
	vals="{@SYS.FILE_URL}{@USER.ID}/fileout.{@SUFIX},{@filename}.{@SUFIX},true" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
