/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.util.Set;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.Shell;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ShellTag
extends CommonTagSupport {
    private static final String VERSION = "7.1.0.0 (2020/01/20)";
    private static final long serialVersionUID = 710020200120L;
    public static final String ACT_RUN = "RUN";
    public static final String ACT_SET = "SET";
    public static final String ACT_GET = "GET";
    public static final String ACT_REMOVE = "REMOVE";
    private static final Set<String> ACTION_SET = new ArraySet((Object[])new String[]{"RUN", "SET", "GET", "REMOVE"});
    private static final String RTN_CODE = "SHELL.RTN_CODE";
    private String program;
    private boolean useBatch;
    private boolean stdout;
    private boolean stderr;
    private boolean wait = true;
    private boolean info;
    private boolean display = true;
    private String action = "RUN";
    private File workDir;
    private String[] envKeys;
    private String[] envVals;
    private boolean useStop = true;
    private int timeout = HybsSystem.sysInt("SHELL_TIMEOUT");

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        int n = this.actionExec(this.action);
        if (this.isDebug()) {
            this.jspPrint("Return Code=[" + n + "]");
        }
        this.setRequestAttribute(RTN_CODE, String.valueOf(n));
        if (this.useStop && n < 0) {
            return 5;
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.program = null;
        this.useBatch = false;
        this.stdout = false;
        this.stderr = false;
        this.wait = true;
        this.action = ACT_RUN;
        this.info = false;
        this.display = true;
        this.useStop = true;
        this.timeout = HybsSystem.sysInt("SHELL_TIMEOUT");
    }

    private int actionExec(String string) {
        int n = 1;
        if (ACT_RUN.equals(string)) {
            n = this.shellRun();
        } else if (ACT_SET.equals(string)) {
            n = this.shellSet();
        } else if (ACT_GET.equals(string)) {
            n = this.shellGet();
        } else if (ACT_REMOVE.equals(string)) {
            n = this.shellRemove();
        }
        return n;
    }

    private Shell makeShell() {
        Shell shell = new Shell();
        shell.setCommand(this.program, this.useBatch);
        shell.setWait(this.wait);
        shell.setTimeout(this.timeout);
        shell.setWorkDir(this.workDir);
        shell.setEnvP(this.makeEnvpArray(this.envKeys, this.envVals));
        if (this.isDebug()) {
            this.jspPrint(shell.getCommand() + BR);
        }
        return shell;
    }

    private String[] makeEnvpArray(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0) {
            return new String[0];
        }
        if (stringArray.length != stringArray2.length) {
            String string = "\u30ad\u30fc\u3068\u30d0\u30ea\u30e5\u30fc\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + CR + " keys.length=[" + stringArray.length + "]  vals.length=[" + stringArray2.length + "]" + CR + " keys=" + StringUtil.array2csv((String[])stringArray) + CR + " vals=" + StringUtil.array2csv((String[])stringArray2);
            throw new HybsSystemException(string);
        }
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray[i] + "=" + stringArray2[i];
        }
        return stringArray3;
    }

    private int shellRun() {
        Shell shell = this.makeShell();
        int n = shell.exec();
        this.shellView(shell);
        return n;
    }

    private int shellSet() {
        int n;
        Shell shell = (Shell)this.getSessionAttribute("h_shKeepKey");
        if (shell == null || shell.isEnd()) {
            shell = this.makeShell();
            n = shell.exec();
            this.setSessionAttribute("h_shKeepKey", shell);
        } else {
            n = shell.exitValue();
        }
        this.shellView(shell);
        return n;
    }

    private int shellGet() {
        int n = 0;
        Shell shell = (Shell)this.getSessionAttribute("h_shKeepKey");
        if (shell != null) {
            n = shell.exitValue();
        }
        this.shellView(shell);
        return n;
    }

    private int shellRemove() {
        int n = 0;
        Shell shell = (Shell)this.getSessionAttribute("h_shKeepKey");
        if (shell != null) {
            shell.destroy();
            n = shell.exitValue();
        }
        this.shellView(shell);
        this.removeSessionAttribute("h_shKeepKey");
        return n;
    }

    private void shellView(Shell shell) {
        if (shell == null) {
            this.jspPrint(this.getResource().getLabel("MSG0066", new String[0]));
            return;
        }
        int n = shell.exitValue();
        String string = switch (n) {
            case 0 -> "MSG0063";
            case 1 -> "MSG0067";
            case 9 -> "MSG0069";
            default -> "MSG0068";
        };
        if (this.display) {
            this.jspPrint(this.getResource().getLabel(string, new String[0]) + BR);
            if (this.info) {
                this.jspPrint(shell.toString());
            }
            if (this.stdout) {
                this.jspPrint(StringUtil.htmlFilter((String)shell.getStdoutData()));
            }
            if (this.stderr) {
                this.jspPrint("<div class=\"row_mark\">");
                this.jspPrint(StringUtil.htmlFilter((String)shell.getStderrData()));
                this.jspPrint("</div>");
            }
        }
    }

    public void setProgram(String string) {
        this.program = this.getRequestParameter(string);
    }

    public void setUseBatch(String string) {
        this.useBatch = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useBatch);
    }

    public void setStdout(String string) {
        this.stdout = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stdout);
    }

    public void setStderr(String string) {
        this.stderr = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stderr);
    }

    public void setWait(String string) {
        this.wait = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.wait);
    }

    public void setTimeout(String string) {
        this.timeout = StringUtil.nval((String)this.getRequestParameter(string), (int)this.timeout);
    }

    public void setInfo(String string) {
        this.info = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.info);
    }

    public void setDisplay(String string) {
        this.display = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.display);
    }

    public void setAction(String string) {
        this.action = StringUtil.nval((String)this.getRequestParameter(string), (String)this.action);
        if (!this.check(this.action, ACTION_SET)) {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "action=[" + this.action + "] " + CR + "actionList=" + String.join((CharSequence)", ", ACTION_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setWorkDir(String string) {
        String string2 = HybsSystem.url2dir(this.getRequestParameter(string));
        this.workDir = new File(string2);
        if (!this.workDir.isDirectory()) {
            String string3 = "\u6307\u5b9a\u306e\u4f5c\u696d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "workDir=[" + this.workDir + "] " + CR;
            throw new HybsSystemException(string3);
        }
    }

    public void setEnvKeys(String string) {
        this.envKeys = this.getCSVParameter(string);
    }

    public void setEnvVals(String string) {
        this.envVals = this.getCSVParameter(string);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("program", (Object)this.program).println("useBatch", (Object)this.useBatch).println("stdout", (Object)this.stdout).println("stderr", (Object)this.stderr).println("wait", (Object)this.wait).println("info", (Object)this.info).println("display", (Object)this.display).println("action", (Object)this.action).println("workDir", (Object)this.workDir).println("envKeys", (Object[])this.envKeys).println("envVals", (Object[])this.envVals).println("timeout", (Object)this.timeout).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

