/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.opengion.fukurou.db.ResultSetValue;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBErrMsg;
import org.opengion.hayabusa.io.HybsFileOperationFactory;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class DirectWriteTableTag
extends CommonTagSupport {
    private static final String VERSION = "8.0.1.0 (2021/10/29)";
    private static final long serialVersionUID = 801020211029L;
    private static final String TAB_SEPARATOR = "\t";
    private static final String ERR_MSG_ID = "h_errMsg";
    private final int DB_MAX_QUERY_TIMEOUT = HybsSystem.sysInt("DB_MAX_QUERY_TIMEOUT");
    private static final String ARG_ARRAY = "ARG_ARRAY";
    private static final String ERR_MSG = "ERR_MSG";
    private static final String ERR_MSG_ARRAY = "ERR_MSG_ARRAY";
    private String dbid;
    private String separator = "\t";
    private boolean useHeader = true;
    private boolean useQuote;
    private boolean useQuoteEscape = true;
    private boolean useReturnQuote = true;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String sql;
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private boolean fileAppend;
    private boolean zip;
    private String zipFilename;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String notfoundMsg = "MSG0077";
    private long dyStart;
    private boolean useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
    private int fetchSize = 251;
    private boolean useNumber = true;
    private String replaceFrom;
    private String replaceTo;
    private boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private boolean queryType = true;
    private String names;
    private int errCode = 0;
    private transient ErrorMessage errMessage;
    private boolean useSLabel;
    private boolean useLocal;
    private String mapObjKey;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.dyStart = System.currentTimeMillis();
            this.useXssCheck(this.xssCheck);
            if (!(this.replaceFrom == null && this.replaceTo == null || this.replaceFrom != null && this.replaceTo != null && this.replaceFrom.length() == this.replaceTo.length())) {
                String string = "\u7f6e\u63db\u5143\u6587\u5b57\u3068\u7f6e\u63db\u5148\u6587\u5b57\u306e\u6587\u5b57\u6570\u304c\u7570\u306a\u308a\u307e\u3059\uff61" + CR + " replaceFrom=[" + this.replaceFrom + "] , replaceTo=[" + this.replaceTo + "]" + CR;
                throw new HybsSystemException(string);
            }
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.useQuotCheck(this.quotCheck);
        this.sql = this.getBodyString();
        if (this.sql == null || this.sql.isEmpty()) {
            throw new HybsSystemException("BODY \u90e8\u306e\u691c\u7d22\u7528 Select\u6587\u306f\uff64\u5fc5\u9808\u3067\u3059\uff61");
        }
        this.sql = this.sql.trim();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        int n;
        Object object;
        File file;
        PrintWriter printWriter;
        block16: {
            this.debugPrint();
            if (!this.useTag()) {
                return 6;
            }
            printWriter = null;
            file = this.makeLocalFile();
            try {
                if (this.zip) {
                    object = null;
                    try {
                        object = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
                        object.setEncoding("Windows-31J");
                        object.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(this.filename));
                        printWriter = FileUtil.getPrintWriter((OutputStream)object, (String)this.encode);
                        n = this.create(printWriter);
                        printWriter.flush();
                        object.closeArchiveEntry();
                        object.finish();
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(object);
                        throw throwable;
                    }
                    Closer.ioClose((Closeable)object);
                    break block16;
                }
                printWriter = this.getPrintWriter(file);
                n = this.create(printWriter);
            }
            catch (IOException iOException) {
                try {
                    String string = "Error in DirectWriteTableTag: " + this.toString();
                    throw new HybsSystemException(string, iOException);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(printWriter);
                    throw throwable;
                }
            }
        }
        Closer.ioClose((Closeable)printWriter);
        HybsFileOperationFactory.local2cloud(this.useLocal, () -> file);
        this.setRequestAttribute("DB.COUNT", String.valueOf(n));
        this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
        object = new StringBuilder(200);
        if (n > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
            ((StringBuilder)object).append(n).append(this.getResource().getLabel(this.displayMsg, new String[0])).append(BR);
        } else if (n == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
            ((StringBuilder)object).append(this.getResource().getLabel(this.notfoundMsg, new String[0])).append(BR);
        }
        String string = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource(), this.useSLabel);
        if (string != null && string.length() > 0) {
            ((StringBuilder)object).append(string);
            this.setSessionAttribute(ERR_MSG_ID, this.errMessage);
        } else {
            this.removeSessionAttribute(ERR_MSG_ID);
        }
        this.jspPrint(((StringBuilder)object).toString());
        int n2 = 6;
        if (this.errCode >= 2) {
            n2 = 5;
        }
        long l = System.currentTimeMillis() - this.dyStart;
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addReadCount(n, l, this.sql);
        }
        if (this.useTimeView) {
            this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        }
        return n2;
    }

    @Override
    protected void release2() {
        super.release2();
        this.separator = TAB_SEPARATOR;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.sql = null;
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.fileAppend = false;
        this.zip = false;
        this.zipFilename = null;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.notfoundMsg = "MSG0077";
        this.dbid = null;
        this.fetchSize = 251;
        this.useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
        this.queryType = true;
        this.names = null;
        this.errCode = 0;
        this.errMessage = null;
        this.useNumber = true;
        this.useHeader = true;
        this.useQuote = false;
        this.useQuoteEscape = true;
        this.useReturnQuote = true;
        this.replaceFrom = null;
        this.replaceTo = null;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.useSLabel = false;
        this.useLocal = false;
        this.mapObjKey = null;
    }

    /*
     * Loose catch block
     */
    private int create(PrintWriter printWriter) {
        int n;
        ResultSet resultSet;
        CallableStatement callableStatement;
        Statement statement;
        block34: {
            ResultSetValue resultSetValue;
            Object object;
            Transaction transaction;
            block32: {
                int n2;
                block33: {
                    statement = null;
                    callableStatement = null;
                    resultSet = null;
                    transaction = this.getTransaction();
                    object = transaction.getConnection(this.dbid);
                    if (this.queryType) {
                        statement = object.createStatement();
                        if (this.fetchSize > 0) {
                            statement.setFetchSize(this.fetchSize);
                        }
                        resultSet = statement.executeQuery(this.sql);
                    } else {
                        resultSetValue = null;
                        if (this.names != null) {
                            String[] stringArray = StringUtil.csv2Array((String)this.names);
                            resultSetValue = this.getRequest(stringArray);
                        }
                        callableStatement = object.prepareCall(this.sql);
                        resultSet = this.executeCall((Connection)object, callableStatement, (String[])resultSetValue);
                    }
                    if (resultSet != null) break block32;
                    n2 = 0;
                    if (transaction == null) break block33;
                    transaction.close();
                }
                Closer.resultClose((ResultSet)resultSet);
                Closer.stmtClose((Statement)statement);
                Closer.stmtClose((Statement)callableStatement);
                return n2;
            }
            try {
                Object object2;
                resultSetValue = new ResultSetValue(resultSet);
                int n3 = resultSetValue.getColumnCount();
                if (this.useHeader && n3 > 0) {
                    StringBuilder stringBuilder = new StringBuilder(200);
                    StringBuilder stringBuilder2 = new StringBuilder(200);
                    if (this.useNumber) {
                        stringBuilder.append("#Name");
                        stringBuilder2.append("#Label");
                    }
                    object2 = null;
                    if (this.mapObjKey != null) {
                        object2 = (Map)this.getRequestAttribute(this.mapObjKey);
                    }
                    ResourceManager resourceManager = this.getResource();
                    for (int i = 0; i < n3; ++i) {
                        String string = resultSetValue.getColumnName(i);
                        if (i > 0 || this.useNumber) {
                            stringBuilder.append(this.separator);
                            stringBuilder2.append(this.separator);
                        }
                        stringBuilder.append(string);
                        String string2 = resourceManager.getLabel(string, new String[0]);
                        if (object2 != null) {
                            string2 = object2.getOrDefault(string, string2);
                        }
                        stringBuilder2.append(string2);
                    }
                    printWriter.println(stringBuilder.toString());
                    printWriter.println(stringBuilder2.toString());
                }
                int n4 = 0;
                while (resultSetValue.next()) {
                    if (this.useNumber) {
                        if (this.useQuote) {
                            printWriter.print("\"" + n4 + "\"");
                        } else {
                            printWriter.print(n4);
                        }
                    }
                    for (int i = 0; i < n3; ++i) {
                        if (i > 0 || this.useNumber) {
                            printWriter.print(this.separator);
                        }
                        if ((object2 = this.replace(resultSetValue.getValue(i))) != null && ((String)object2).length() > 0) {
                            if (this.useQuoteEscape && ((String)object2).indexOf(34) >= 0) {
                                object2 = ((String)object2).replaceAll("\"", "\"\"");
                            }
                            if (this.useQuote || this.useReturnQuote && ((String)object2).indexOf(CR) >= 0) {
                                object2 = "\"" + (String)object2 + "\"";
                            }
                        } else {
                            object2 = this.useQuote ? "\"\"" : "";
                        }
                        printWriter.print((String)object2);
                    }
                    printWriter.println();
                    ++n4;
                }
                n = n4;
                transaction.commit();
                break block34;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    object = "\uff83\uff9e\uff70\uff80\uff8d\uff9e\uff70\uff7d\u51e6\u7406\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff61" + CR + "[" + this.sql + "]" + CR + "err=[" + sQLException.getSQLState() + "]" + sQLException.getMessage();
                    throw new HybsSystemException((String)object, sQLException);
                }
                catch (Throwable throwable) {
                    Closer.resultClose(resultSet);
                    Closer.stmtClose(statement);
                    Closer.stmtClose(callableStatement);
                    throw throwable;
                }
            }
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)statement);
        Closer.stmtClose((Statement)callableStatement);
        return n;
    }

    private File makeLocalFile() {
        if (this.filename == null) {
            throw new HybsSystemException("\uff8c\uff67\uff72\uff99\u540d\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff61");
        }
        String string = HybsSystem.url2dir(this.fileURL);
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            String string2 = "\uff83\uff9e\uff68\uff9a\uff78\uff84\uff98\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff61[" + string + "]";
            throw new HybsSystemException(string2);
        }
        Object object = this.zip ? (this.zipFilename == null ? this.filename + ".zip" : this.zipFilename) : this.filename;
        return new File(string, (String)object);
    }

    private String replace(String string) {
        String string2 = string;
        if (string2 != null && this.replaceFrom != null && this.replaceTo != null) {
            for (int i = 0; i < this.replaceTo.length(); ++i) {
                string2 = string2.replace(this.replaceFrom.charAt(i), this.replaceTo.charAt(i));
            }
        }
        return string2;
    }

    private ResultSet executeCall(Connection connection, CallableStatement callableStatement, String ... stringArray) throws SQLException {
        callableStatement.setQueryTimeout(this.DB_MAX_QUERY_TIMEOUT);
        if (this.fetchSize > 0) {
            callableStatement.setFetchSize(this.fetchSize);
        }
        Map<String, Class<?>> map = connection.getTypeMap();
        try {
            map.put(ERR_MSG, Class.forName("org.opengion.hayabusa.db.DBErrMsg"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "org.opengion.hayabusa.db.DBErrMsg \uff78\uff97\uff7d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\uff61" + CR + classNotFoundException.getMessage();
            throw new HybsSystemException(string, classNotFoundException);
        }
        Array array = ((OracleConnection)connection).createOracleArray(ARG_ARRAY, (Object)StringUtil.rTrims((String[])stringArray));
        callableStatement.registerOutParameter(1, 4);
        callableStatement.registerOutParameter(2, 2003, ERR_MSG_ARRAY);
        callableStatement.registerOutParameter(3, -10);
        callableStatement.setArray(4, array);
        callableStatement.execute();
        this.errCode = callableStatement.getInt(1);
        ResultSet resultSet = null;
        if (this.errCode < 2) {
            resultSet = ((OracleCallableStatement)callableStatement).getCursor(3);
        }
        if (this.errCode > 0) {
            DBErrMsg dBErrMsg;
            Array array2 = callableStatement.getArray(2);
            Object[] objectArray = (Object[])array2.getArray();
            this.errMessage = new ErrorMessage("Query_JDBCErrMsg Error!!");
            for (int i = 0; i < objectArray.length && (dBErrMsg = (DBErrMsg)objectArray[i]) != null; ++i) {
                this.errMessage.addMessage(dBErrMsg.getErrMsg());
            }
        }
        return resultSet;
    }

    private PrintWriter getPrintWriter(File file) {
        if (this.fileAppend && file.isFile()) {
            HybsFileOperationFactory.cloud2local(this.useLocal, () -> file);
        }
        return FileUtil.getPrintWriter((File)file, (String)this.encode, (boolean)this.fileAppend);
    }

    private String[] getRequest(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.getRequestValue(stringArray[i]);
        }
        return stringArray2;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)TAB_SEPARATOR);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setUseHeader(String string) {
        this.useHeader = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useHeader);
    }

    public void setUseQuote(String string) {
        this.useQuote = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useQuote);
    }

    public void setUseQuoteEscape(String string) {
        this.useQuoteEscape = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useQuoteEscape);
    }

    public void setUseReturnQuote(String string) {
        this.useReturnQuote = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useReturnQuote);
    }

    public void setReplaceFrom(String string) {
        this.replaceFrom = this.changeRNT(StringUtil.nval((String)this.getRequestParameter(string), (String)this.replaceFrom));
    }

    public void setReplaceTo(String string) {
        this.replaceTo = this.changeRNT(StringUtil.nval((String)this.getRequestParameter(string), (String)this.replaceTo));
    }

    private String changeRNT(String string) {
        String string2 = string;
        if (string2 != null && !string2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (int i = 0; i < string2.length(); ++i) {
                int n = string2.charAt(i);
                if (n == 92) {
                    char c = string2.charAt(++i);
                    switch (c) {
                        case 'n': {
                            n = 10;
                            break;
                        }
                        case 'r': {
                            n = 13;
                            break;
                        }
                        case 't': {
                            n = 9;
                            break;
                        }
                        default: {
                            String string3 = ((Object)((Object)this)).getClass().getName() + "\u306e\u7f6e\u63db\u6587\u5b57\u5217\u3067\uff64\uff62\\" + c + "\uff63\u306f\uff64\uff7b\uff8e\uff9f\uff70\uff84\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff61";
                            System.err.println(string3);
                        }
                    }
                }
                stringBuilder.append((char)n);
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public void setFileAppend(String string) {
        this.fileAppend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fileAppend);
    }

    public void setZip(String string) {
        this.zip = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.zip);
    }

    public void setZipFilename(String string) {
        this.zipFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.zipFilename);
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setFetchSize(String string) {
        this.fetchSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.fetchSize);
    }

    public void setNames(String string) {
        this.names = StringUtil.nval((String)this.getRequestParameter(string), (String)this.names);
    }

    public void setQueryType(String string) {
        this.queryType = !"JDBCErrMsg".equalsIgnoreCase(this.getRequestParameter(string));
    }

    public void setUseNumber(String string) {
        this.useNumber = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useNumber);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setUseTimeView(String string) {
        this.useTimeView = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeView);
    }

    public void setUseSLabel(String string) {
        this.useSLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useSLabel);
    }

    public void setUseLocal(String string) {
        this.useLocal = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLocal);
    }

    public void setMapObjKey(String string) {
        this.mapObjKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.mapObjKey);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("separator", (Object)this.separator).println("useHeader", (Object)this.useHeader).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("sql", (Object)this.sql).println("encode", (Object)this.encode).println("fileAppend", (Object)this.fileAppend).println("zip", (Object)this.zip).println("zipFilename", (Object)this.zipFilename).println("displayMsg", (Object)this.displayMsg).println("fetchSize", (Object)this.fetchSize).println("queryType", (Object)this.queryType).println("names", (Object)this.names).println("errCode", (Object)this.errCode).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

