/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Set;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.RoleMode;
import org.opengion.hayabusa.taglib.HTMLTagSupport;

public class ColumnTag
extends HTMLTagSupport {
    private static final String VERSION = "8.5.2.0 (2023/07/14)";
    private static final long serialVersionUID = 852020230714L;
    private static final Set<String> TYPE_SET = new ArraySet((Object[])new String[]{"text", "search", "tel", "url", "email", "datetime", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
    private static final Set<String> TD_SET = new ArraySet((Object[])new String[]{"yes", "no", "false"});
    private static final boolean USE_DEFVAL = HybsSystem.sysBool("USE_DEFAULT_PROPERTIE_VALUE");
    private final String CLM = HybsSystem.sysBool("HTML_LABEL_SEPARATOR") ? ":" : "";
    private String tdFlag = "yes";
    private boolean addNoValue = true;
    private String addKeyLabel;
    private String name;
    private String value;
    private boolean writable = true;
    private String defaultVal = "";
    private String colspan = "";
    private String rowspan = "";
    private String nextForm;
    private boolean useRequestValue = true;
    private String fieldSize;
    private String viewSize;
    private String maxlength;
    private String body;
    private String codeName;
    private String codeList;
    private String codeGroup;
    private String codeKeyVal;
    private boolean useLblBody;
    private String renderer;
    private String editor;
    private String dbType;
    private String eventColumn;
    private String eventValue;
    private String eventURL;
    private String param;
    private String dbid;
    private String help;
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private String useSLabel = "auto";
    private boolean useDateFeed = true;
    private boolean useHidden;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.useXssCheck(this.xssCheck);
            if (this.value == null && this.useRequestValue) {
                String string = this.pageContext.getRequest().getParameter("command");
                this.value = "RENEW".equals(string) ? this.getRequestValue(this.name) : StringUtil.nval((String)this.getRequestValue(this.name), (String)this.defaultVal);
            }
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.body = this.getBodyString();
        return 0;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tdFlag = "yes";
        this.addNoValue = true;
        this.addKeyLabel = null;
        this.name = null;
        this.value = null;
        this.writable = true;
        this.defaultVal = "";
        this.colspan = "";
        this.rowspan = "";
        this.nextForm = null;
        this.useRequestValue = true;
        this.fieldSize = null;
        this.viewSize = null;
        this.maxlength = null;
        this.body = null;
        this.codeName = null;
        this.codeList = null;
        this.codeGroup = null;
        this.codeKeyVal = null;
        this.useLblBody = false;
        this.renderer = null;
        this.editor = null;
        this.dbType = null;
        this.eventColumn = null;
        this.eventValue = null;
        this.eventURL = null;
        this.param = null;
        this.dbid = null;
        this.help = null;
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.useSLabel = "auto";
        this.useDateFeed = true;
        this.useHidden = false;
    }

    @Override
    protected String makeTag() {
        String string;
        DBColumn dBColumn = this.getDBColumn(this.name);
        String string2 = this.getLongLabel();
        if (string2 == null) {
            string2 = dBColumn.getLongLabel();
        }
        if ((string = this.getInsertTag(dBColumn, this.value)) == null) {
            return "";
        }
        if (this.body == null) {
            this.body = "";
        } else if (this.useLblBody) {
            string2 = this.body;
            this.body = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        if ("yes".equals(this.tdFlag)) {
            stringBuilder.append("<td class=\"label\"").append(this.rowspan).append('>').append(string2).append(this.CLM).append("</td><td").append(this.colspan).append(this.rowspan).append('>').append(string).append(this.makeHelpLink(this.help)).append(this.makeAimaiPicker(this.name)).append(this.makeMustHidden(this.name)).append(this.body).append("</td>");
        } else if ("no".equals(this.tdFlag)) {
            stringBuilder.append("<span class=\"label\">").append(string2).append(this.CLM).append("</span>").append(string).append(this.makeHelpLink(this.help)).append(this.makeAimaiPicker(this.name)).append(this.makeMustHidden(this.name)).append(this.body);
        } else {
            stringBuilder.append(string).append(this.makeHelpLink(this.help)).append(this.makeAimaiPicker(this.name)).append(this.makeMustHidden(this.name)).append(this.body);
        }
        if (this.useHidden) {
            String string3 = this.get("disabled");
            if (!this.writable || "disabled".equalsIgnoreCase(string3)) {
                if ("null".equalsIgnoreCase(this.value)) {
                    this.value = "";
                }
                stringBuilder.append(XHTMLTag.hidden((String)this.name, (String)this.value));
            } else {
                String string4 = "useHidden \u306f\u3001writable\u304c false \u53c8\u306f\u3001disabled\u304c disabled \u306e\u3068\u304d\u3057\u304b\u4f7f\u3048\u307e\u305b\u3093\u3002" + CR + "\t name=[" + this.name + "] , writable=[" + this.writable + "] , disabled=[" + string3 + "]";
                throw new HybsSystemException(string4);
            }
        }
        return stringBuilder.toString();
    }

    private String getInsertTag(DBColumn dBColumn, String string) {
        String string2;
        String string3;
        CodeData codeData;
        Object object;
        String string4 = this.get("roles");
        RoleMode roleMode = string4 == null ? dBColumn.getRoleMode() : RoleMode.newInstance(string4);
        byte by = this.getUser().getAccessBitMode(roleMode);
        if (!RoleMode.isAccess(by)) {
            return null;
        }
        if (this.nextForm != null) {
            object = "nextForm(this,'" + this.nextForm + "'," + dBColumn.getTotalSize() + ");";
            this.set("onKeyup", (String)object);
        }
        if (this.fieldSize == null && this.maxlength != null) {
            int n = dBColumn.getFieldSize(Integer.parseInt(this.maxlength));
            this.fieldSize = String.valueOf(n);
        }
        object = dBColumn.getConfig();
        if (this.maxlength != null) {
            ((DBColumnConfig)object).setMaxlength(this.maxlength);
        }
        if (this.fieldSize != null) {
            ((DBColumnConfig)object).setFieldSize(this.fieldSize);
        }
        if (this.viewSize != null) {
            ((DBColumnConfig)object).setViewLength(this.viewSize);
        }
        if (this.renderer != null) {
            ((DBColumnConfig)object).setRenderer(this.renderer);
        }
        if (this.editor != null) {
            ((DBColumnConfig)object).setEditor(this.editor);
        }
        if (this.dbType != null) {
            ((DBColumnConfig)object).setDbType(this.dbType);
        }
        if (this.eventColumn != null) {
            ((DBColumnConfig)object).setEventColumn(this.eventColumn);
        }
        if (this.eventValue != null) {
            ((DBColumnConfig)object).setEventValue(this.eventValue);
        }
        if (this.param == null) {
            if (dBColumn.isNeedsParamParse()) {
                ((DBColumnConfig)object).setRendererParam(this.getRequestParameter(((DBColumnConfig)object).getRendererParam()));
                ((DBColumnConfig)object).setEditorParam(this.getRequestParameter(((DBColumnConfig)object).getEditorParam()));
            }
        } else {
            ((DBColumnConfig)object).setParameter(this.getRequestParameter(this.param));
            ((DBColumnConfig)object).setRawParameter(this.getReservedParameter(this.param));
        }
        if (this.dbid != null) {
            ((DBColumnConfig)object).setDbid(this.dbid);
        }
        if (this.eventURL != null) {
            ((DBColumnConfig)object).setEventURL(this.eventURL);
        }
        if (this.useSLabel != null) {
            ((DBColumnConfig)object).setUseSLabel(this.useSLabel);
        }
        if (!this.useDateFeed) {
            ((DBColumnConfig)object).setUseDateFeed(this.useDateFeed);
        }
        if (this.addKeyLabel == null) {
            this.addKeyLabel = StringUtil.nval((String)this.sys("USE_ADD_KEY_LABEL"), null);
        }
        if (this.addKeyLabel != null) {
            ((DBColumnConfig)object).setAddKeyLabel(this.addKeyLabel);
        }
        if (this.codeName != null) {
            codeData = this.getResource().getCodeData(this.codeName);
            ((DBColumnConfig)object).setCodeData(codeData);
            if (this.renderer == null) {
                ((DBColumnConfig)object).setRenderer("MENU");
            }
            if (this.editor == null) {
                ((DBColumnConfig)object).setEditor("MENU");
            }
        }
        if ((codeData = ((DBColumnConfig)object).getCodeData()) != null) {
            if (this.codeList != null) {
                ((DBColumnConfig)object).setCodeData(codeData.subsetList(this.codeList));
            }
            if (this.codeGroup != null) {
                ((DBColumnConfig)object).setCodeData(codeData.subsetGroup(this.codeGroup));
            }
            if (codeData.useRoleMode()) {
                ((DBColumnConfig)object).setCodeData(codeData.subsetRole(this.getUser().getRoleMode()));
            }
        }
        if (this.codeKeyVal != null) {
            ((DBColumnConfig)object).setParameter(this.codeKeyVal);
            ((DBColumnConfig)object).setRenderer("KVMENU");
            ((DBColumnConfig)object).setEditor("KVMENU");
        }
        Attributes attributes = this.getAttributes();
        ((DBColumnConfig)object).setEditorAttributes(attributes);
        DBColumn dBColumn2 = new DBColumn((DBColumnConfig)object);
        String string5 = string3 = USE_DEFVAL && (string == null || string.isEmpty()) ? dBColumn2.getDefault() : string;
        if ("null".equalsIgnoreCase(string3)) {
            string3 = "";
        }
        String string6 = null;
        if (this.writable) {
            string2 = dBColumn2.getEditorValue(string3);
            StringBuilder stringBuilder = new StringBuilder(200).append(string2);
            if (this.addNoValue && string2.startsWith("<select")) {
                int n = string2.indexOf(62);
                stringBuilder.insert(n + 1, "<option value=\"\" ></option>");
            }
            string6 = stringBuilder.toString();
        } else if (attributes == null || attributes.size() == 0) {
            string6 = dBColumn2.getRendererValue(string3);
        } else {
            attributes.set("body", dBColumn2.getRendererValue(string3));
            string6 = XHTMLTag.span((Attributes)attributes);
        }
        string2 = dBColumn2.getEventColumn();
        if (string2 != null && string2.length() > 0) {
            this.addEventColumn(dBColumn2);
            string6 = dBColumn2.getEventColumnTag(string6, string3, this.writable);
        }
        return string6;
    }

    protected String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = StringUtil.nval((String)this.getRequestParameter(string), (String)this.name);
    }

    public void setValue(String string) {
        this.value = StringUtil.nval((String)this.getRequestParameter(string), (String)this.value);
    }

    public void setDefaultVal(String string) {
        this.defaultVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.defaultVal);
    }

    public void setTd(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tdFlag);
        if (!this.check(string2, TD_SET)) {
            String string3 = "Error in SelectTag [td]: " + string2 + "  in [" + String.join((CharSequence)", ", TD_SET) + "] only used.";
            throw new HybsSystemException(string3);
        }
        this.tdFlag = string2;
    }

    public void setAddNoValue(String string) {
        this.addNoValue = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.addNoValue);
    }

    public void setAddKeyLabel(String string) {
        this.addKeyLabel = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addKeyLabel);
    }

    public void setWritable(String string) {
        this.writable = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.writable);
    }

    public void setMaxlength(String string) {
        this.maxlength = StringUtil.nval((String)this.getRequestParameter(string), null);
        if ("0".equals(this.maxlength)) {
            this.set("NO_MAXLEN", "true");
        }
    }

    public void setSize(String string) {
        this.fieldSize = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setViewSize(String string) {
        this.viewSize = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setColspan(String string) {
        this.colspan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.colspan);
        if (this.colspan.length() > 0) {
            this.colspan = " colspan=\"" + this.colspan + "\" ";
        }
    }

    public void setRowspan(String string) {
        this.rowspan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rowspan);
        if (this.rowspan.length() > 0) {
            this.rowspan = " rowspan=\"" + this.rowspan + "\" ";
        }
    }

    public void setNextForm(String string) {
        this.nextForm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nextForm);
    }

    public void setUseRequestValue(String string) {
        this.useRequestValue = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRequestValue);
    }

    public void setCodeName(String string) {
        this.codeName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeName);
    }

    public void setCodeList(String string) {
        this.codeList = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeList);
    }

    public void setCodeGroup(String string) {
        this.codeGroup = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeGroup);
    }

    public void setCodeKeyVal(String string) {
        this.codeKeyVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeKeyVal);
    }

    public void setUseLblBody(String string) {
        this.useLblBody = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLblBody);
    }

    public void setRenderer(String string) {
        this.renderer = StringUtil.nval((String)this.getRequestParameter(string), (String)this.renderer);
    }

    public void setEditor(String string) {
        this.editor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.editor);
    }

    public void setDbType(String string) {
        this.dbType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbType);
    }

    public void setEventColumn(String string) {
        this.eventColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.eventColumn);
    }

    public void setEventValue(String string) {
        this.eventValue = StringUtil.nval((String)this.getReservedParameter(string), (String)this.eventValue);
    }

    public void setEventURL(String string) {
        this.eventURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.eventURL);
    }

    public void setParam(String string) {
        this.param = StringUtil.nval((String)string, (String)this.param);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setUseSLabel(String string) {
        this.useSLabel = StringUtil.nval((String)this.getRequestParameter(string), (String)this.useSLabel);
    }

    public void setEventCallback(String string) {
        String string2 = this.getRequestParameter(string);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            this.add("optionAttributes", "eventCallback='" + string2 + "'");
        }
    }

    public void setType(String string) {
        String string2 = this.getRequestParameter(string);
        if (!this.check(string2, TYPE_SET)) {
            String string3 = "type \u5c5e\u6027\u306f\u3001\u4e0b\u8a18\u306e\u4e2d\u304b\u3089\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002type=[" + string2 + "] in [" + String.join((CharSequence)", ", TYPE_SET) + "]";
            throw new HybsSystemException(string3);
        }
        this.set("type", string2);
    }

    public void setHelp(String string) {
        this.help = StringUtil.nval((String)this.getRequestParameter(string), (String)this.help);
    }

    public void setUseRealTimeCheck(String string) {
        String string2 = this.getRequestParameter(string);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            this.add("optionAttributes", "realTimeChk=\"" + string2 + "\"");
        }
    }

    public void setUseDateFeed(String string) {
        this.useDateFeed = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useDateFeed);
    }

    public void setUseHidden(String string) {
        this.useHidden = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useHidden);
    }

    private String makeHelpLink(String string) {
        if (string != null) {
            String string2 = HybsSystem.sys("JSP_ICON") + "/" + HybsSystem.sys("DEFAULT_CLMHELP_ICON");
            String string3 = "<img src=\"" + string2 + "\" alt=\"Help\" title=\"Help\" >";
            return XHTMLTag.link((Attributes)new Attributes().set("href", ColumnTag.makeUrl(string)).set("body", string3).set("target", "_blank").set("class", "clmHelplink"));
        }
        return "";
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tdFlag", (Object)this.tdFlag).println("addNoValue", (Object)this.addNoValue).println("name", (Object)this.name).println("value", (Object)this.value).println("writable", (Object)this.writable).println("defaultVal", (Object)this.defaultVal).println("colspan", (Object)this.colspan).println("rowspan", (Object)this.rowspan).println("nextForm", (Object)this.nextForm).println("useRequestValue", (Object)this.useRequestValue).println("viewSize", (Object)this.viewSize).println("fieldSize", (Object)this.fieldSize).println("maxlength", (Object)this.maxlength).println("codeName", (Object)this.codeName).println("param", (Object)this.param).println("body", (Object)StringUtil.htmlFilter((String)this.body)).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

