/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.HybsFileOperationFactory;
import org.opengion.hayabusa.io.TableWriter;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class WriteTableTag
extends CommonTagSupport {
    private static final String VERSION = "8.0.1.0 (2021/10/29)";
    private static final long serialVersionUID = 801020211029L;
    private final String BASE_URL = HybsSystem.sys("FILE_URL");
    private String separator = "\t";
    private String headerSequence;
    private String fileURL = this.BASE_URL;
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String sheetName = "Sheet1";
    private String refFileURL = this.BASE_URL;
    private String refFilename;
    private String refSheetName;
    private String fontName = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_NAME");
    private String fontPoint = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_POINTS");
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private String writerClass;
    private boolean fileAppend;
    private boolean zip;
    private String zipFilename;
    private transient DBTableModel table;
    private String tableId = "h_tblmdl";
    private String directory;
    private transient List<HybsEntry> param;
    private boolean useNumber = true;
    private String columns;
    private String omitNames;
    private boolean useRenderer = HybsSystem.sysBool("USE_TABLE_WRITER_RENDERER");
    private boolean selectedAll = true;
    private boolean useLocal;
    private boolean beforeDelete;
    private int skipRowCount;
    private boolean sheetOverwrite;
    private String recalcSheetName;
    private boolean useCellStyle;
    private boolean useAutoCellSize;
    private boolean useActiveWorkbook;
    private String pageBreakColumn;
    private String fileBreakColumn;
    private String hyperLinkColumn;
    private String addTitleSheet;
    private File localFile;

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        this.localFile = this.makeLocalFile();
        if (this.beforeDelete && !this.fileAppend && this.localFile.exists() && !this.localFile.delete()) {
            String string = "\u4e8b\u524d\u306b\uff8c\uff67\uff72\uff99\u3092\u524a\u9664\u3059\u308b\u306e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filename=[" + this.localFile + "]";
            System.err.println(string);
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        int n;
        block16: {
            this.debugPrint();
            if (!this.useTag()) {
                return 6;
            }
            this.table = (DBTableModel)this.getObject(this.tableId);
            if (!this.selectedAll) {
                this.table = this.getSelRowsTable(this.table);
            }
            n = 0;
            if (this.table == null || this.table.getRowCount() <= 0) break block16;
            if (this.writerClass == null) {
                this.writerClass = StringUtil.nval((String)this.sys("TABLE_WRITER_DEFAULT_CLASS"), (String)"Default");
            }
            PrintWriter printWriter = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                block18: {
                    boolean bl;
                    block17: {
                        boolean bl2 = bl = this.writerClass.toUpperCase(Locale.JAPAN).startsWith("EXCEL") || this.writerClass.toUpperCase(Locale.JAPAN).startsWith("CALC");
                        if (!this.zip) break block17;
                        BufferedInputStream bufferedInputStream = null;
                        if (bl) {
                            this.create(null);
                        } else {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            printWriter = this.getPrintWriter(byteArrayOutputStream);
                            this.create(printWriter);
                            printWriter.flush();
                        }
                        ZipArchiveOutputStream zipArchiveOutputStream = null;
                        try {
                            zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.localFile)));
                            zipArchiveOutputStream.setEncoding("Windows-31J");
                            zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(this.filename));
                            if (bl) {
                                File file = this.localFile;
                                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)zipArchiveOutputStream);
                                Closer.ioClose((Closeable)bufferedInputStream);
                                if (file.exists() && !file.delete()) {
                                    String string = "Excel\u3092Zip\u5316\u3059\u308b\u6642\u306eTemp\uff8c\uff67\uff72\uff99\u3092\u524a\u9664\u3059\u308b\u306e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filename=[" + file + "]";
                                    System.err.println(string);
                                }
                            } else {
                                byteArrayOutputStream.writeTo((OutputStream)zipArchiveOutputStream);
                            }
                            zipArchiveOutputStream.closeArchiveEntry();
                            zipArchiveOutputStream.finish();
                        }
                        catch (Throwable throwable) {
                            Closer.ioClose(zipArchiveOutputStream);
                            Closer.ioClose(bufferedInputStream);
                            throw throwable;
                        }
                        Closer.ioClose((Closeable)zipArchiveOutputStream);
                        Closer.ioClose((Closeable)bufferedInputStream);
                        break block18;
                    }
                    if (bl) {
                        this.create(null);
                    } else {
                        printWriter = this.getPrintWriter();
                        this.create(printWriter);
                        printWriter.flush();
                    }
                }
                n = this.table.getRowCount();
            }
            catch (IOException iOException) {
                try {
                    String string = "\uff83\uff70\uff8c\uff9e\uff99\u51fa\u529b\u6642\u306b\u3001IO\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.toString();
                    throw new HybsSystemException(string, iOException);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(printWriter);
                    Closer.ioClose(byteArrayOutputStream);
                    throw throwable;
                }
            }
            Closer.ioClose((Closeable)printWriter);
            Closer.ioClose((Closeable)byteArrayOutputStream);
            HybsFileOperationFactory.local2cloud(this.useLocal, () -> this.localFile);
        }
        this.setRequestAttribute("WRITE.COUNT", String.valueOf(n));
        return 6;
    }

    private File makeLocalFile() {
        if (this.filename == null) {
            throw new HybsSystemException("\uff8c\uff67\uff72\uff99\u540d\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.directory = HybsSystem.url2dir(this.fileURL);
        File file = new File(this.directory);
        if (!file.exists() && !file.mkdirs()) {
            String string = "\uff83\uff9e\uff68\uff9a\uff78\uff84\uff98\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + this.directory + "]";
            throw new HybsSystemException(string);
        }
        Object object = this.zip ? (this.zipFilename == null ? this.filename + ".zip" : this.zipFilename) : this.filename;
        return new File(this.directory, (String)object);
    }

    @Override
    protected void release2() {
        super.release2();
        this.separator = "\t";
        this.headerSequence = null;
        this.fileURL = this.BASE_URL;
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.sheetName = "Sheet1";
        this.beforeDelete = false;
        this.refFileURL = this.BASE_URL;
        this.refFilename = null;
        this.refSheetName = null;
        this.sheetOverwrite = false;
        this.recalcSheetName = null;
        this.fontName = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_NAME");
        this.fontPoint = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_POINTS");
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.writerClass = null;
        this.fileAppend = false;
        this.zip = false;
        this.zipFilename = null;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.param = null;
        this.useNumber = true;
        this.skipRowCount = 0;
        this.directory = null;
        this.columns = null;
        this.omitNames = null;
        this.useRenderer = HybsSystem.sysBool("USE_TABLE_WRITER_RENDERER");
        this.selectedAll = true;
        this.useLocal = false;
        this.useCellStyle = false;
        this.useAutoCellSize = false;
        this.useActiveWorkbook = false;
        this.pageBreakColumn = null;
        this.fileBreakColumn = null;
        this.hyperLinkColumn = null;
        this.addTitleSheet = null;
        this.localFile = null;
    }

    private void create(PrintWriter printWriter) {
        if ("ExcelRenderer".equalsIgnoreCase(this.writerClass)) {
            this.writerClass = "Excel";
            this.useRenderer = true;
        } else if ("Renderer".equalsIgnoreCase(this.writerClass)) {
            this.writerClass = "Default";
            this.useRenderer = true;
        }
        TableWriter tableWriter = (TableWriter)HybsSystem.newInstance("TableWriter_", this.writerClass);
        tableWriter.setDBTableModel(this.table, this.getLanguage());
        tableWriter.setSeparator(this.separator);
        tableWriter.setHeaderSequence(this.headerSequence);
        tableWriter.setEncode(this.encode);
        tableWriter.setAppend(this.fileAppend);
        if (this.param != null) {
            tableWriter.setParam(this.param);
        }
        tableWriter.setUseNumber(this.useNumber);
        tableWriter.setColumns(this.columns);
        tableWriter.setOmitNames(this.omitNames);
        tableWriter.setUseRenderer(this.useRenderer);
        tableWriter.setDebug(this.isDebug());
        if (tableWriter.isExcel()) {
            tableWriter.setSheetName(this.sheetName);
            tableWriter.setFilename(this.directory, this.filename);
            if (this.refFileURL != null && this.refFilename != null) {
                tableWriter.setRefFilename(HybsSystem.url2dir(this.refFileURL, this.refFilename));
            }
            if (this.refSheetName != null && this.refSheetName.length() > 0) {
                tableWriter.setRefSheetName(this.refSheetName);
            }
            tableWriter.setFontName(this.fontName);
            if (this.fontPoint != null && this.fontPoint.length() > 0) {
                tableWriter.setFontPoint(Short.parseShort(this.fontPoint));
            }
            tableWriter.setSkipRowCount(this.skipRowCount);
            tableWriter.setSheetOverwrite(this.sheetOverwrite);
            tableWriter.setRecalcSheetName(this.recalcSheetName);
            tableWriter.setUseCellStyle(this.useCellStyle);
            tableWriter.setUseAutoCellSize(this.useAutoCellSize);
            tableWriter.setUseActiveWorkbook(this.useActiveWorkbook);
            tableWriter.setPageBreakColumn(this.pageBreakColumn);
            tableWriter.setFileBreakColumn(this.fileBreakColumn);
            tableWriter.setHyperLinkColumn(this.hyperLinkColumn);
            tableWriter.setAddTitleSheet(this.addTitleSheet);
            tableWriter.writeDBTable();
        } else {
            tableWriter.writeDBTable(printWriter);
        }
    }

    private PrintWriter getPrintWriter() {
        if (this.filename == null) {
            throw new HybsSystemException("\uff8c\uff67\uff72\uff99\u540d\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        return FileUtil.getPrintWriter((File)this.localFile, (String)this.encode, (boolean)this.fileAppend);
    }

    private PrintWriter getPrintWriter(OutputStream outputStream) {
        return FileUtil.getPrintWriter((OutputStream)outputStream, (String)this.encode);
    }

    private DBTableModel getSelRowsTable(DBTableModel dBTableModel) {
        if (dBTableModel == null) {
            return null;
        }
        DBTableModel dBTableModel2 = dBTableModel.newModel();
        int[] nArray = this.getParameterRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dBTableModel2.addValues((String[])dBTableModel.getValues(nArray[i]), i);
        }
        return dBTableModel2;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setHeaderSequence(String string) {
        String[] stringArray = this.getRequestParameterValues(string);
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                stringBuilder.append(string2);
            }
            this.headerSequence = stringBuilder.toString();
        }
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setBaseURL(String string) {
        this.fileURL = StringUtil.nval((String)this.getRequestParameter(string), (String)"");
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setSheetName(String string) {
        this.sheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetName);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setWriterClass(String string) {
        this.writerClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.writerClass);
    }

    public void setFileAppend(String string) {
        this.fileAppend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fileAppend);
    }

    public void setZip(String string) {
        this.zip = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.zip);
    }

    public void setZipFilename(String string) {
        this.zipFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.zipFilename);
    }

    public void setRefFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.refFileURL = StringUtil.urlAppend((CharSequence)this.refFileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setRefFilename(String string) {
        this.refFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refFilename);
    }

    public void setRefSheetName(String string) {
        this.refSheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refSheetName);
    }

    public void setSheetOverwrite(String string) {
        this.sheetOverwrite = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.sheetOverwrite);
    }

    public void setRecalcSheetName(String string) {
        this.recalcSheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.recalcSheetName);
    }

    public void setFontName(String string) {
        this.fontName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fontName);
    }

    public void setFontPoint(String string) {
        this.fontPoint = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fontPoint);
    }

    public void setUseNumber(String string) {
        this.useNumber = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useNumber);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
    }

    public void setOmitNames(String string) {
        this.omitNames = StringUtil.nval((String)this.getRequestParameter(string), (String)this.omitNames);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setSkipRowCount(String string) {
        this.skipRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.skipRowCount);
    }

    public void setUseCellStyle(String string) {
        this.useCellStyle = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useCellStyle);
    }

    public void setUseAutoCellSize(String string) {
        this.useAutoCellSize = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useAutoCellSize);
    }

    public void setUseActiveWorkbook(String string) {
        this.useActiveWorkbook = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useActiveWorkbook);
    }

    public void setPageBreakColumn(String string) {
        this.pageBreakColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.pageBreakColumn);
    }

    public void setFileBreakColumn(String string) {
        this.fileBreakColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fileBreakColumn);
    }

    public void setHyperLinkColumn(String string) {
        this.hyperLinkColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.hyperLinkColumn);
    }

    public void setAddTitleSheet(String string) {
        this.addTitleSheet = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addTitleSheet);
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setUseLocal(String string) {
        this.useLocal = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLocal);
    }

    public void setBeforeDelete(String string) {
        this.beforeDelete = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.beforeDelete);
    }

    protected void addParam(HybsEntry hybsEntry) {
        if (this.param == null) {
            this.param = new ArrayList<HybsEntry>();
        }
        this.param.add(hybsEntry);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("BASE_URL", (Object)this.BASE_URL).println("separator", (Object)this.separator).println("headerSequence", (Object)this.headerSequence).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("refFileURL", (Object)this.refFileURL).println("refFilename", (Object)this.refFilename).println("encode", (Object)this.encode).println("writerClass", (Object)this.writerClass).println("fileAppend", (Object)this.fileAppend).println("zip", (Object)this.zip).println("zipFilename", (Object)this.zipFilename).println("tableId", (Object)this.tableId).println("sheetName", (Object)this.sheetName).println("refSheetName", (Object)this.refSheetName).println("useNumber", (Object)this.useNumber).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

