/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.KanaFilter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.HybsFileOperationFactory;

@WebServlet(value={"/jsp/fileDownload"})
public class FileDownload
extends HttpServlet {
    private static final long serialVersionUID = 539020110901L;
    private static final String[][] CONTENT_TYPE_TABLE = new String[][]{{"jpg", "image/pjpeg"}, {"gif", "image/gif"}, {"txt", "text/plain"}, {"xls", "application/vnd.ms-excel"}, {"odp", "application/vnd.oasis.opendocument.presentation"}, {"ods", "application/vnd.oasis.opendocument.spreadsheet"}, {"odt", "application/vnd.oasis.opendocument.text"}};
    private static final int EXTENTION = 0;
    private static final int CONTENT_TYPE = 1;
    private static final String KEY_USELOCAL = "useLocal";
    private static final String HASH_CODE = HybsSystem.sys("FILE_HASH_CODE");
    private final String fileURL = HybsSystem.sys("FILE_URL");

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        String string;
        String string2 = httpServletRequest.getParameter("file");
        boolean bl2 = HybsSystem.sysBool("USE_FILEDOWNLOAD_CHECKKEY");
        if (bl2 && ((string = httpServletRequest.getParameter("key")) == null || !string.equals(HybsCryptography.getHash((String)HASH_CODE, (String)string2)))) {
            throw new HybsSystemException("\uff71\uff78\uff7e\uff7d\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\uff61(URL\uff81\uff6a\uff6f\uff78)");
        }
        boolean bl3 = StringUtil.nval((String)httpServletRequest.getParameter("useBase"), (boolean)false);
        if (bl3) {
            string2 = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
        string2 = HybsSystem.url2dir(string2);
        String string3 = this.getContentType(string2);
        httpServletResponse.setContentType(string3);
        String string4 = httpServletRequest.getParameter("name");
        if (string4 == null || string4.isEmpty()) {
            string4 = this.getFileName(string2);
        }
        if (HybsSystem.sysBool("USE_FILEDOWNLOAD_HAN_ZEN")) {
            string4 = KanaFilter.han2zen((String)string4);
        }
        String string5 = (bl = StringUtil.nval((String)httpServletRequest.getParameter("inline"), (boolean)false)) ? "inline" : "attachment";
        String string6 = StringUtil.urlEncode((String)string4);
        httpServletResponse.setHeader("Content-disposition", string5 + "; filename*=UTF-8''" + string6);
        httpServletResponse.setHeader("Cache-Control", "public");
        ServletOutputStream servletOutputStream = null;
        InputStream inputStream = null;
        String string7 = null;
        try {
            int n;
            boolean bl4 = StringUtil.nval((String)httpServletRequest.getParameter(KEY_USELOCAL), (boolean)false);
            FileOperation fileOperation = HybsFileOperationFactory.create(bl4, string2);
            inputStream = fileOperation.read();
            string7 = String.valueOf(inputStream.available());
            httpServletResponse.setHeader("Content-Lnegth", string7);
            servletOutputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                servletOutputStream.write(byArray, 0, n);
                servletOutputStream.flush();
            }
        }
        catch (Throwable throwable) {
            Closer.ioClose(inputStream);
            Closer.ioClose(servletOutputStream);
            throw throwable;
        }
        Closer.ioClose((Closeable)inputStream);
        Closer.ioClose((Closeable)servletOutputStream);
    }

    private String getExtention(String string) {
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : "";
    }

    private String getFileName(String string) {
        int n = string.lastIndexOf(HybsConst.FS);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    private String getContentType(String string) {
        String string2 = this.getExtention(string);
        for (int i = 0; i < CONTENT_TYPE_TABLE.length; ++i) {
            if (!CONTENT_TYPE_TABLE[i][0].equalsIgnoreCase(string2)) continue;
            return CONTENT_TYPE_TABLE[i][1];
        }
        return "application/octet-stream";
    }
}

