/*!
 * common/jquery/jquery.blockUI.js を使用した検索中表示のクリア
 *
 * query.jsp に include された blockUI.js を、result.jsp に include された
 * 自身(unblockUI.js)の $(document).ready を使用して、検索中レイヤーの破棄を行います。
 *
 * openGion 6.3.4.1 (2015/08/08)
 *
 * 5.7.7.1 (2014/06/13) headType="result" 時に、BODY にINSERTする文字列。
 * 5.7.8.1 (2014/07/18) ３ペイン等で、frame が多段階になっている場合の対応
 * 5.8.7.1 (2015/05/22) fnUnblockUI 未定義エラーに対応(6.2.4.0対応の適用)
 * 5.9.2.1 (2015/11/13) 判定修正
 * 7.3.2.0 (2021/03/19) frameの名前を親画面に設定しておく。
 * 8.4.3.0 (2023/03/31) jQuery を使用しないように変更(ｴﾗｰ画面でも使うので)
 */

// $(function(){
document.addEventListener('DOMContentLoaded', function() {
	var target_name= parent.document.body.unblockname ? parent.document.body.unblockname : "QUERY";

	var qfrm=window.parent.frames[target_name];
//	var qfrm=window.parent.frames['QUERY'];
	if(qfrm == null) {
//		qfrm=window.parent.parent.frames['QUERY'];
		qfrm=window.parent.parent.frames[target_name];
	}

//	// 7.3.2.0 (2021/03/19) frame 判定で、[0]も加える(POPUPでtarget属性変更の為)は取りやめる。
//	if(qfrm == null) {
//		qfrm=window.parent.frames[0];
//	}
//	if(qfrm == null) {
//		qfrm=window.parent.parent.frames[0];
//	}

//	if( qfrm && qfrm.$ && qfrm.$.fnUnblockUI ) {
//		$(document).ready(function(){ qfrm.$.fnUnblockUI(); });
//	}

	if( qfrm && qfrm.jQuery && qfrm.jQuery.fnUnblockUI ) {
		qfrm.jQuery.fnUnblockUI();
	}
});
