/********************************************************************************************/
/* VIEWのｶﾗﾑﾏﾆｭｱﾙ表示 5.5.4.0 (2012/07/02)													*/
/*																							*/
/* VIEWﾃｰﾌﾞﾙの情報より､ｶﾗﾑのﾏﾆｭｱﾙを表示します｡												*/
/* 利用変数はｸﾛｰｼﾞｬｰで隠蔽します｡															*/
/* img#viewHelpIconがﾍﾙﾌﾟのｱｲｺﾝとなります													*/
/*																							*/
/* Modified: 2012/07/18 Field登録／表示の場合も項目説明が作成されるように対応				*/
/*				Scroll対応																	*/
/* Modified: 6.2.5.0 (2015/06/05) resultScript.js から分離｡(query.jspでも使う)				*/
/* Modified: 6.2.6.0 (2015/06/19) 画面の概要説明も表示できるように修正						*/
/* Modified: 8.4.2.2 (2023/03/17) 概要説明を折り替えし表示できるようにする					*/
/* @og.rev 8.4.3.0 (2023/03/31) .bind() , .unbind() は､.on()と.off()に書き換えます｡			*/
/* @og.rev 8.4.3.0 (2023/04/05) POP化対応(autoManual.html)									*/
/* Revision: $Id$																			*/
/********************************************************************************************/
var showViewManual = (function(){
	// 画面上の座標の取得
	// Modified: 2012/07/18 ｽｸﾛｰﾙ対応
	function getElementScreenPosition( inObj )
	{
		let html = document.documentElement;
		let rect = inObj.getBoundingClientRect();
		let scrollLeft = document.documentElement.scrollLeft || document.body.scrollLeft;
		let left = scrollLeft > 0 ? rect.left - html.clientLeft + scrollLeft : rect.left - html.clientLeft ;
		let top  = rect.top - html.clientTop;

		left = left < 0 ? 0 : left;
		top  = top < 0 ? 0 :top;

		return { left:left, top:top };
	}
	// ﾍｯﾀﾞｰかどうかの判定
	function isHeader( inObj ){
		if( inObj.parentNode.tagName == "TH" ){
			return true;
		}
		else if( inObj.parentNode.tagName == "BODY" ){
			return false;
		}
		else{
			return isHeader( inObj.parentNode );
		}
	}
	// ﾗﾍﾞﾙ（<td class="label">）の判定 2012/07/18 mod
	function isLabel( inObj ){
		if( inObj.parentNode.tagName == "TD" && inObj.parentNode.className == "label" ){
			return true;
		}
		else if( inObj.parentNode.tagName == "BODY" ){
			return false;
		}
		else{
			return isLabel( inObj.parentNode );
		}
	}
	// 6.2.6.0 (2015/06/19) 画面の概要説明の判定。id="design-header-title" があれば画面概要と判定
	function isGuiDesc( inObj ){
		if( inObj != null && inObj.parentNode != null ) {
			if( inObj.parentNode.id == "design-header-title" ){
				return true;
			}
			else{
				return isGuiDesc( inObj.parentNode );
			}
		}
		else {
			return false;
		}
	}
	// ﾏﾆｭｱﾙの表示
	// ｸﾛｰｼﾞｬｰとして利用
	// _mode:1なら単純にﾍｯﾀﾞがある(1)かない(0)かだけ返す｡それ以外は通常実行
	return function(_mode ){
		// 概要説明の各タグを取得
		let objSpan = $("span");
		// 項目数
		let countSpan = objSpan.length;
		let spanTitle = "";
		let spanKey   = "";
		// 概要説明を格納する配列 2023/04/05 ADD
		let arrDesc = [];
		// ｱｲｺﾝ表示する／しないの判定ﾌﾗｸﾞ
		let fgShow  = 0;
		// 項目の概要説明がない時、または概要説明と項目名称が同内容となっている時は非表示する
		for( i = 0 ;i < countSpan ;i++ ){
			// Field型の表示にも、作成するように対応 2012/07/18 mod
			// 6.2.6.0 (2015/06/19) 画面の概要説明も表示できるように修正。
			if( !isHeader( objSpan[i] ) && !isLabel( objSpan[i] ) && !isGuiDesc( objSpan[i] )) continue;
			spanTitle = objSpan[i].title;
			spanKey   = $(objSpan[i]).text();
			if( spanTitle.length > 0 && spanTitle != spanKey ){
				// 判定ﾓｰﾄﾞの場合
				if( _mode == '1'){
					fgShow = 1;
					break;
				}
				// 通常ﾓｰﾄﾞのみﾃﾞｰﾀ作成
				else{
					// 2023/04/05 ADD
					let objBuf = {
						 key   : spanKey
						,title : spanTitle
					};
					// 配列に追加
					arrDesc.push( objBuf );
				}
			}
		}
		// 判定ﾓｰﾄﾞの場合
		if( _mode == '1' ){
			return fgShow;
		}
		// WEBｽﾄﾚｰｼﾞに保存
		localStorage.setItem( 'manualInfo', JSON.stringify( arrDesc ) );
		localStorage.setItem( 'pageTitle' , document.title );
		// 概要説明の表示ﾍﾟｰｼﾞを呼び出す(resizable=yes,location=no はChromeやEdgeでは効かない)
		ogOpen('../common/autoManual.html',null ,null,'width=800px,height=400px,top=200,left=200');
	};
})();

// helpで表示する内容がなければviewHelpIconを消す。
$(function(){
	if(showViewManual('1') == '0'){
		$('img#viewHelpIcon').css('display','none');
	}
});
