/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.daemon;

import org.opengion.fukurou.system.OgRuntimeException ;			// 6.4.2.0 (2016/01/29)
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.HybsTimerTask;
	// import org.opengion.fukurou.util.URLConnect;				// 6.9.0.0 (2018/01/31) URLConnect 廃止
import org.opengion.fukurou.util.HttpConnect;					// 6.9.0.0 (2018/01/31) 新規追加
// import org.opengion.fukurou.util.XHTMLTag;
import static org.opengion.fukurou.system.HybsConst.CR ;		// 6.1.0.0 (2014/12/26)

import java.io.IOException;
import java.util.Date;
import java.util.Map;											// 6.9.0.0 (2018/01/31) 新規追加

/**
 * 【URLアクセス】
 * 指定したパラメータでURLに接続します。
 * このクラスは、HybsTimerTask を継承した タイマータスククラスです。
 * startDaemon() がタイマータスクによって、呼び出されます。
 *
 * 接続のためのパラメータは以下です
 * url			 : 接続先URL(必須)
 * proxyHost	 : プロキシのホスト名
 * proxyPort	 : プロキシのポート番号
 * useSystemUser : デフォルトのユーザ/パスワードを利用するか(初期値:true)
 * 					trueの場合はSYSTEM:*********を利用します。
 * authUserPass	 : ユーザとパスワードをUSER:PASSWORDの形で記述
 * keys			 : リクエストパラメータのキー(CSV形式)
 * vals			 : リクエストパラメータの値(CSV形式)
 * 【廃止】method		 : POSTかGETを指定(初期値:GET) (6.9.0.0 (2018/01/31) 廃止)
 * debug		 : 接続したページを受信して、ログに書き出します(初期値:false)
 *
 * 接続エラー時のログはファイル(SYS_LOG_URL)に出力されます。
 *
 * @og.rev 4.3.4.4 (2009/01/01) 新規作成
 * @og.group デーモン
 *
 * @version  4.0
 * @author   Takahashi Masakazu
 * @since    JDK5.0,
 */
public class Daemon_URLConnect extends HybsTimerTask {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.9.8.0 (2018/05/28)" ;

//	private static final String DEFAULT_USER = "SYSTEM:MANAGER" ;
	private static final String DEFAULT_USER = "admin:admin" ;			// 6.9.0.1 (2018/02/05) この際、変更しておきます。
	private static final int LOOP_COUNTER = 24;	// カウンタを24回に設定

	private int loopCnt ;

	private boolean debug	;
	private String	urlStr			;

//	private URLConnect conn			;
	private HttpConnect conn		;			// 6.9.0.0 (2018/01/31) URLConnect 廃止、HttpConnect に置き換えます。

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public Daemon_URLConnect() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * このタイマータスクによって初期化されるアクションです。
	 * パラメータを使用した初期化を行います。
	 *
	 * @og.rev 6.2.5.1 (2015/06/12) StringUtil.nvalを、すべてのパラメータ取得時に適用します。
	 * @og.rev 6.9.0.0 (2018/01/31) URLConnect 廃止、HttpConnect に置き換えます。
	 * @og.rev 6.9.8.0 (2018/05/28) FindBugs:ローカル変数への無効な代入(methodのGET/POST廃止)
	 */
	@Override
	public void initDaemon() {
		debug						= StringUtil.nval( getValue( "DEBUG"         ) , debug ) ;
		urlStr						= StringUtil.nval( getValue( "url"           ) , null  );
		final boolean useSystemUser	= StringUtil.nval( getValue( "useSystemUser" ) , true  );
//		final String method			= StringUtil.nval( getValue( "method"        ) , "GET" );		// 6.9.8.0 (2018/05/28) FindBugs
		final String proxyHost		= StringUtil.nval( getValue( "proxyHost"     ) , null );
		final int    proxyPort		= StringUtil.nval( getValue( "proxyPort"     ) , -1   );
//		final String keys			= StringUtil.nval( getValue( "keys"          ) , null );
//		final String vals			= StringUtil.nval( getValue( "vals"          ) , null );
		final String authUserPass	= useSystemUser ? DEFAULT_USER
													: StringUtil.nval( getValue( "authUserPass"  ) , null );

//		final String urlEnc = XHTMLTag.urlEncode( keys,vals );

		conn = new HttpConnect( urlStr,authUserPass );		// HttpConnect は、GET でも後付で引数を渡せます。

		// POST の場合は、すべてのﾊﾟﾗﾒｰﾀを、GETの場合は、既存のﾊﾟﾗﾒｰﾀにﾌﾟﾗｽされます。
		for( final Map.Entry<String,String> params : getParameter().entrySet() ) {
			conn.addRequestProperty( params.getKey() , params.getValue() );
		}

//		if( ! "POST".equals( method ) ) {
//			urlStr = XHTMLTag.addUrlEncode( urlStr,urlEnc );
//		}
//		conn = new URLConnect( urlStr,authUserPass );

		if( proxyHost != null ) {
			conn.setProxy( proxyHost,proxyPort );
		}

//		if( "POST".equals(method) && keys != null && vals != null ) {
//			conn.setPostData( urlEnc );
//		}
	}

	/**
	 * タイマータスクのデーモン処理の開始ポイントです。
	 *
	 * @og.rev 6.3.9.0 (2015/11/06) コンストラクタで初期化されていないフィールドを null チェックなしで利用している(findbugs)
	 * @og.rev 6.9.0.0 (2018/01/31) URLConnect 廃止、HttpConnect に置き換えます。
	 */
	@Override
	protected void startDaemon() {
		if( loopCnt % LOOP_COUNTER == 0 ) {
			loopCnt = 1;
			System.out.println( toString() + " " + new Date()  + " " );
		}
		else {
			loopCnt++ ;
		}

		// 6.3.9.0 (2015/11/06) コンストラクタで初期化されていないフィールドを null チェックなしで利用している(findbugs)
		if( conn == null ) {
			final String errMsg = "#initDaemon()を先に実行しておいてください。" ;
			throw new OgRuntimeException( errMsg );
		}

		// URLへのconnect及びデータ取得実行
		try{
//			conn.connect();

			if( debug ){
				// System.out.println( conn.readData() );
				final String debugMsg = "Daemon_URLConnect:url=[" + urlStr + "]" + CR
								+ conn.readData();
				LogWriter.log( debugMsg );
			}
		}
		catch( final IOException ex ) {
			System.out.println(ex);
			final String errMsg = "Daemon_URLConnect:データ取得中にエラーが発生しました。" + CR
						+ " url=[" + urlStr + "]" + CR
						+ ex;
			LogWriter.log( errMsg );
		}
//		finally {
//			// 6.3.9.1 (2015/11/27) null でないことがわかっている値の冗長な null チェック(findbugs)
//			conn.disconnect();
//		}
	}
}
