	window.onload   = load;
	window.onunload = GUnload;

	var map = null;
	var geocoder = null;
	var zoom = 13;
	var infoEvent = false;

	function load() {
	  if (GBrowserIsCompatible()) {
		map = new GMap2(document.getElementById("map"));
		map.setCenter(new GLatLng(34.966138,135.75505), zoom);	// 地図の移動
		map.addControl(new GLargeMapControl());					// 上下左右＋拡大縮小(大型)
	//	map.addControl(new GSmallMapControl ());				// 上下左右＋拡大縮小(小型)
		map.addControl(new GOverviewMapControl());				// オーバービューコントロール
		map.addControl(new GMapTypeControl(true));				// 地図・航空写真切り替え(trueで小型版)
		map.addControl(new GScaleControl(200));					// 縮尺スケール

		geocoder = new GClientGeocoder();
	  }
	}

	function showAddress(jsonData) {
	  if (geocoder) {
		geocoder.getLatLng(
		  jsonData.ADDRESS,
		  function(point) {
			if (!point) {
				alert(jsonData.ADDRESS + " \u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093\u3002");
			} else {
				showPoint(point,jsonData);
			}
		  }
		);
	  }
	}

	function showPoint(point,jsonData) {
		map.setCenter(point, zoom);

		// 標準マーカー
//		var marker = new GMarker(point);

		// 標準マーカー(チップス表示)
//		var markeropts  = new Object();
//		markeropts.title = jsonData.SJIGYO ;
//		var marker = new GMarker(point, markeropts);

		// アイコンマーカー
		var icon = new GIcon();
		icon.image = "/ver4/jsp/makeImage?text=" + (parseInt(jsonData.I)+1) ;
		icon.iconSize   = new GSize(35, 35);
		icon.iconAnchor = new GPoint(0, 0);
		var markeropts  = new Object();
		markeropts.icon = icon;
//		markeropts.clickable = true;
		markeropts.title = jsonData.SJIGYO ;
		var marker = new GMarker(point, markeropts);

		map.addOverlay(marker);

		// クリック時のイベント
		GEvent.addListener(marker,"click",function() {
			var opts = new Object();
			opts.zoomLevel = zoom + 5;
			opts.mapType   = G_HYBRID_MAP;
			map.showMapBlowup(point,opts);		// 拡大地図
			infoEvent = false;
		});

		// マウスオーバー時のイベント
		GEvent.addListener(marker, "mouseover", function() {
			var data =  jsonData.JIGYO_KANJI + "<br/>" +
						jsonData.POSTCODE    + "<br/>" +
						jsonData.ADDRESS     + "<br/>" +
						point ;
	//		marker.openInfoWindowHtml( data );	// ふきだし表示
			infoEvent = true;
		});

		// マウスアウト時のイベント
		GEvent.addListener(marker, "mouseout", function() {
			if( infoEvent ) { map.closeInfoWindow(); }
		});
	}
