<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9610"
	title	= "送信データ確認"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<form method="POST" action="entry.jsp" enctype="multipart/form-data" target="CONTENTS">

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- メール内容確認する画面では action="CHECK"と設定します。-->
<!-- メール内容確認する場合、scope属性には "session"(デフォルト) しかセットできません。-->
<og:mailSender2
	ptnId		= "{@PTN_ID}"
	from		= "{@FROM_ID}"
	action		= "CHECK"
	to			= "{@TO_ID}"
	cc			= "{@CC_ID}"
	bcc			= "{@BCC_ID}"
	addrCheck 	= "{@ADDRCHECK}"
	useStop     = "{@USESTOP}"
/>

<!-- タグ mailSender2 実行の戻り値として、エラーコード：0(エラーなし)、1：(エラーあり)。-->
<!-- エラーなしの場合、メール内容が表示されます。-->
<!-- 予約語{@MAIL.FROM_ADDR}で「メール送信者アドレス」を取得します。 -->
<!-- 予約語{@MAIL.TITLE}    で「メールタイトル」を取得します。       -->
<!-- 予約語{@MAIL.CONTENT}  で「メール本文」を取得します。           -->

<og:equals val1="{@MAIL.ERR_CODE}" val2="0" >
	<og:submit value="entry" lbl="ENTRY" />

	<!-- view タグの scope 属性設定は mailSender2 タグの scope 属性の設定値と一致させる必要があります。-->
	<og:view
		viewFormType = "HTMLTable"
		command      = "{@command}"
		pageSize	 = "500"
		writable	 = "false"
		useTableSorter ="false"
		useScrollBar  = "false"
		useHilightRow = "false"
	/>

	<og:text>
		<table>
			<tr><td><b><og:message lbl="FROM" />:</b></td><td>{@MAIL.FROM_ADDR}</td></tr>
			<tr><td><b><og:message lbl="TITLE" />:</b></td><td>{@MAIL.TITLE}</td></tr>
			<tr><td><b><og:message lbl="CONTENT" />:</b></td>
				    <td><div style="border:black solid 1px;width:580px">
						<pre style="width:580px;word-wrap: break-word;">{@MAIL.CONTENT}</pre></div>
					</td>
			</tr>
		</table>
	</og:text>
	<table>
	<tr><og:input type="file" name="file1"  size="80" lbl="File1"/></tr>
	<tr><og:input type="file" name="file2"  size="80" lbl="File2"/></tr>
	<tr><og:input type="file" name="file3"  size="80" lbl="File3"/></tr>
	<tr><og:input type="file" name="file4"  size="80" lbl="File4"/></tr>
	<tr><og:input type="file" name="file5"  size="80" lbl="File5"/></tr>
	</table>

	<og:hidden name="ADDRCHECK" value="{@ADDRCHECK}" />
	<og:hidden name="USESTOP"   value="{@USESTOP}"   />
</og:equals>

<!-- エラーありの場合、エラー時の後続処理を行います。-->
<og:equals val1="{@MAIL.ERR_CODE}" val2="0" notEquals="true" >
	<og:text>Error Process</og:text>
</og:equals>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
