<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7160"
	title	= "ImageTimeBarﾀｸﾞ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- SELECT文は、キー、日時、状況コードが、必須項目 -->
		select CNT_ACCESS as KEY , DYLOGIN , GUIKEY as FLAG ,
				SYSTEM_ID, GUIKEY , USERID , '' as TIPS , CNT_ACCESS as LNK
		from GE15
		where GUIKEY is not null
		and   DYLOGIN &gt;= '{@startDate}{@startHour}00'
		and   DYLOGIN &lt;= TO_CHAR( TO_DATE( '{@startDate}{@startHour}00', 'YYYYMMDDHH24MISS' ) + {@timeSpan}/24 , 'YYYYMMDDHH24MISS' )
		<og:where startKey="and">
			<og:and value = "CNT_ACCESS = '{@KEY}'"	/>
		</og:where>
		order by 1,2
</og:query>

<og:value key="KEY" value="画面ID" />

<og:viewMarker command="{@command}">
	<og:columnMarker column="TIPS" useFormatDeco="true" >
{@LBL.SYSTEM_ID}:[$SYSTEM_ID]
{@LBL.USERID}:[$USERID]
{@LBL.GUIKEY}:[$GUIKEY]
{@LBL.DYLOGIN}:[$DYLOGIN]
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<og:link column="LNK" gamenId="GF9110" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,GUIKEY"
		vals="NEW,[SYSTEM_ID],[KEY]" />
</og:viewLink>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "ImageTimeBar"
	command		= "{@command}"
	noDisplay	= "{@extDisplay}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
	width		= "{@width}"
	height		= "{@height}"
	useParam	= "true" >
	<og:timeBarParam
		startDate		= "{@startDate}{@startHour}00"
		timeSpan		= "{@timeSpan}"
		labelClms		= "KEY,USERID"
		useLegend		= "{@useLegend}"
		maxLabelWidth	= "{@maxLabelWidth}"
		maxTimeWidth	= "{@maxTimeWidth}"
		chartHeight		= "{@chartHeight}"
		headerHeight	= "{@headerHeight}"
		tipsClm			= "TIPS"
		linkClm			= "LNK"
		padding			= "{@padding}"
		margin			= "{@margin}"
		useLastData		= "{@useLastData}"
		debug			= "{@debug}"
	/>
</og:view>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "TIPS,LNK"
	useScrollBar = "false"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
