<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6430"
	title	= "EXCEL変換"
	date	= "2015/06/15"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:upload
	fileURL		= "{@USER.ID}"
	maxPostSize = "0"
/>

<og:file fileURL="{@USER.ID}" file1="{@file1}" action="existsLength" >
	<og:message lbl="MSG0064" comment="ファイルが存在していません。" />
	<og:text>fileURL="{@USER.ID}" file1="{@file1}"</og:text>
</og:file>

<!-- この検索結果は、KEYとVALUEの MAPオブジェクトに設定される。 -->
<!-- convMap に渡すMapオブジェクトを作成します。 -->
<og:value command="SQL" action="ALL_MAPOBJ" key="CHINESE" caseIf="{@useConverter}" >
	select GENBUN,YAKU
	from  GF28
	where SYSTEM_ID = '**'
	and   LANG_YAKU = 'zh'
	and   KBHORYU   = '1'
	and   FGJ       = '1'
	union
	select '@DYSET' , '{@DATE."yy.MM.dd"}' from dual
	union
	select '@Name'  , '伏見太郎' from dual
</og:value>

<og:value command="SET" key="convFile" value="{@SYS.REAL_PATH}jsp/{@GUI.KEY}/Converter.txt" />

<!-- convFile と、convMap を同時に指定した場合、convFileが優先されます。 -->
<og:excelFile
	fileURL				= "{@USER.ID}"
	file1				= "{@file1}"
	file2				= "{@file2}"
	sheetName			= "{@sheetName}"
	sheetNos			= "{@sheetNos}"
	sheetConstKeys		= "{@sheetConstKeys}"
	sheetConstAdrs		= "{@sheetConstAdrs}"
	useActiveWorkbook	= "{@useActiveWorkbook}"
	addTitleSheet		= "{@addTitleSheet}"
	addImageFile		= "{@addImageFile}"
	valueType			= "{@valueType}"
	readText			= "{@readText}"
	readSheet			= "{@readSheet}"
	readName			= "{@readName}"
	readStyle			= "{@readStyle}"
	useConverter		= "{@useConverter}"
	convFile			= "{@convFile}"
	convMap				= "CHINESE"
	scope				= "{@scope}"
/>

<br />

<og:link href="{@SYS.FILE_OUT_URL}{@USER.ID}/{@file2}" target="_blank" useGamenId="false" >
	<img src="{@SYS.JSP_IMG}/floppy.gif" alt="Excel Open" /> {@file2} <og:message lbl="MSG0056" />
</og:link>

<br />

<table class="box_all">
	<tr><th>Key	</th><th>Param						</th></tr>
	<tr><td>DAY	</td><td><og:text>{@DAY}</og:text></td></tr>
	<tr><td>LOC	</td><td><og:text>{@LOC}</og:text></td></tr>
	<tr><td>TITL</td><td><og:text>{@TITL}</og:text></td></tr>
	<tr><td>MK1	</td><td><og:text>{@MK1}</og:text></td></tr>
	<tr><td>US1	</td><td><og:text>{@US1}</og:text></td></tr>
	<tr><td>MK2	</td><td><og:text>{@MK2}</og:text></td></tr>
	<tr><td>US2	</td><td><og:text>{@US2}</og:text></td></tr>
	<tr><td>DYSK</td><td><og:text>{@DYSK}</og:text></td></tr>
</table>
<br />

<table class="box_all">
	<tr><th>Key			</th><th>Param							</th><th>Value																</th></tr>
	<tr><td>readSheet	</td><td><og:text>{@readSheet}</og:text></td><td><og:value command="GET" key="{@readSheet}"	caseNN="{@readSheet}" /></td></tr>
	<tr><td>readName	</td><td><og:text>{@readName}</og:text>	</td><td><og:value command="GET" key="{@readName}"	caseNN="{@readName}"  /></td></tr>
	<tr><td>readStyle	</td><td><og:text>{@readStyle}</og:text></td><td><og:value command="GET" key="{@readStyle}"	caseNN="{@readStyle}" /></td></tr>
</table>
<br />

<pre><og:value command="GET"  key="{@readText}" caseNN="{@readText}"  /></pre>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
