<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result">
	<!-- 8.4.1.1 (2023/02/24) headタグ内に移動 -->
	<style>
		.none { display:none; }
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6050"
	title	= "ポップアップ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command	= "{@command}"
	columns	= "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。 -->
<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" trace="false" >
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。 -->
		select CASE KBSAKU WHEN '3' THEN '1' ELSE KBSAKU END AS WRITABLE,
				CLM,'' as PUP,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,DYUPD,FGJ
		from GF41
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"		/>
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"	/>
		<og:and value = "LANG        like '{@LANG}'"	/>
		<og:and value = "CLM         like '{@CLM}'"		/>
		<og:and value = "NAME_JA     like '{@NAME_JA}'"	/>
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}'"	/>
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9110" href="index.jsp" target="CONTENTS"
		keys="command,KEY,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,{I},{@SYSTEM_ID},[LANG],[CLM],[KBSAKU],true" />
	<og:link column="LABEL_NAME" href="{@SYS.JSP}/GF9120/image/[LABEL_NAME].gif" useGamenId="false" target="_new" />
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" >
		<span style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
</og:viewMarker>

<og:viewMarker command="{@command}" isRenderer="false">
	<og:popup column="PUP" command="NEW" href="popup.jsp"
			keys="SYSTEM_ID,CLM,NAME_JA"
			vals="[SYSTEM_ID],[CLM].value,[NAME_JA].value"
			rtnKeys="SYSTEM_ID,CLM,NAME_JA" />
</og:viewMarker>

<og:columnEditor columns="SYSTEM_ID,LANG,CLM" must="true" />
<og:columnEditor columns="DYUPD" editor="YMD2" />

<!-- ２重押し防止 oneClick()関数は、useAjaxSubmit='true' 使用時には使えません。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。 -->
<og:writeCheck>
	<og:submit action="COPY"   noWritable="null" />
	<og:submit action="MODIFY" noWritable="SYSTEM_ID,LANG,CLM,PUP" />
	<og:submit action="DELETE" columnWritable="null" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。 -->
<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	noDisplay		= "FGJ"
	checked			= "{@checked}"
	startNo			= "{@startNo}"
	pageSize		= "{@pageSize}"
	tdClassClms		= "PUP"
	tdClass			= "none"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
