<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:upload
	fileURL     = "{@USER.ID}"
	maxPostSize = "20000000"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "file1"
/>

<!-- シート番号と、テーブル名のマップを作成します。  -->
<jsp:scriptlet>
	java.util.Map map = new java.util.LinkedHashMap();
	map.put("1"	 , "r_section"	);
	map.put("2"	 , "r_user"		);
	map.put("3"	 , "r_customer"	);
	map.put("4"	 , "r_warehouse");
	map.put("5"	 , "r_item"		);
	map.put("6"	 , "r_stock"	);
	map.put("10" , "r_resource"	);
	map.put("13" , "r_useparts"	);

	request.setAttribute("data",map);
</jsp:scriptlet>

<!-- トランザクション 登録処理 -->
<og:transaction>
<br />
  <!-- アップロードされたファイルは、UPLOAD_FILES をキーに、Listオブジェクトに格納されています。 -->
  <c:forEach items="${data}" var="obj" varStatus="status" >

　　Sheet：<c:out value="${obj.key}"/><br />
　　Table：<c:out value="${obj.value}"/><br />

	<og:readTable
		command		= "NEW"
		readerClass = "Excel"
		modifyType	= "A"
		fileURL		= "{@USER.ID}"
		filename	= "{@file1}"
		encode		= "UnicodeLittle"
		sheetNos    = "${obj.key}"
		maxRowCount	= "0"
		debug		= "{@debug}"
	/>

	<og:view command="NEW" />

	<!-- 登録処理をおこないます。 -->
	<!-- constObjKey="GF" で、DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD を自動セットします。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true" dbid="{@DBID}" >
		<og:tableUpdateParam
			constObjKey = "TPM"
			sqlType		= "INSERT"
			table		= "${obj.value}"
		/>
	</og:tableUpdate>
  </c:forEach>
</og:transaction>

<!--
<og:forward page="result.jsp" keys="command" vals="RENEW" debug="{@debug}" />
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
