<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC21"
	title	= "ﾘｿｰｽ未使用検索"
	date	= "2015/06/24"
	author	= "k.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "{@command}"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" tableId="{@tableId}" useConsistency="false" />

<!-- トランザクション 登録処理 -->
<og:transaction>
	<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
	<!-- 通常は変更する必要はありません。 -->
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" tableId="{@tableId}" >
		<!-- where 条件は、UNIQ ではなく、SYSTEM_IDとCLMで、関係するﾗﾍﾞﾙﾘｿｰｽ すべて(LANGやKBSAKU)に適用する。 -->
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GEA08"
			names		= "FGLOAD,FGJ"
			constKeys	= "DYUPD,USRUPD,PGUPD"
			constVals	= "{@USER.YMDH},{@USER.ID},{@GUI.KEY}"
			where		= "SYSTEM_ID=[SYSTEM_ID] and CLM=[CLM]"
		/>
	</og:tableUpdate>

	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" tableId="{@tableId}" >
		<!-- where 条件は、UNIQ ではなく、SYSTEM_IDとCLMで、関係するｶﾗﾑﾘｿｰｽ すべて(KBSAKU)に適用する。 -->
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GEA03"
			names		= "FGLOAD,FGJ"
			constKeys	= "DYUPD,USRUPD,PGUPD"
			constVals	= "{@USER.YMDH},{@USER.ID},{@GUI.KEY}"
			where		= "SYSTEM_ID=[SYSTEM_ID] and CLM=[CLM]"
		/>
	</og:tableUpdate>
</og:transaction >

<og:forward page="result.jsp" keys="command" vals="REVIEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
