<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC10"
	title	= "JSPチェック確認"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:equals val1="{@VIEW}" val2="FULL" >
	<og:value key="TEXT_DATA" value=",TEXT_DATA" />
</og:equals>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select ADDRESS,ADDRESS as NAME_JA,FILENAME,TAGNAME,
				MSGCD,MSGTXT{@TEXT_DATA},MODIFIED,FILEPATH,FGOMIT,FGOMIT as OLDOMIT,FGJ,UNIQ,DYSET,DYUPD,USRUPD,PGUPD,SYSTEM_ID,TBLSYU
		from GF70 A
		where SYSTEM_ID = '{@SYSTEM_ID}'
		and   TBLSYU    = '{@TBLSYU}'
		and   FGJ       in  ('0','1')
	<og:where startKey = "and" >
		<og:and value = "FGOMIT		= '{@FGOMIT}'"			/>
		<og:and value = "ADDRESS	like '{@ADDRESS}'"		/>
		<og:and value = "FILENAME	like '{@FILENAME}'"	/>
		<og:and value = "TAGNAME	like '{@TAGNAME}'"		/>
		<og:and value = "MODIFIED {@CONDITION} '{@MODIFIED}'" />
		<og:equals val1="{@FGOMIT}" val2="0">
			<og:and>
				not exists ( select 'X' from GF70 B
								where A.SYSTEM_ID  = B.SYSTEM_ID
								and A.TBLSYU   = B.TBLSYU
								and A.ADDRESS  = B.ADDRESS
								and A.FILENAME = B.FILENAME
								and A.TAGNAME  = B.TAGNAME
								and A.MSGCD    = B.MSGCD
								and B.FGOMIT   = '1')
			</og:and>
		</og:equals>
		<og:and value = "MSGCD		like '{@MSGCD}'"		/>
		<og:and value = "MSGTXT		like '{@MSGTXT}'"		/>
	</og:where>
		order by MSGCD,ADDRESS,FILENAME,TAGNAME
</og:query>

<!-- JavaDoc へのリンクのための、最大Verの取得 -->
<og:value command="SQL" >
	select VERNO as MAX_VERNO from GF21 group by VERNO order by 1 desc
</og:value>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="TAGNAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
		keys="command,FULLTAG,VIEW,VERNO"
		vals="NEW,[TAGNAME],,{@MAX_VERNO}" />
<!--
	<og:link column="FILENAME" href="[FILEPATH]" target="_blank" type="text/plain" useGamenId="false" />
-->
	<og:link column="FILENAME" href="{@SYS.JSP}/fileDownload" useGamenId="false" keys="file" vals="[FILEPATH]"/>

</og:viewLink>

<b><og:link href="group.jsp" keys="command,displayMsg" vals="RENEW,　" >{@LBL.GROUPTAG}</og:link></b>
<br />

<!-- ラベルリソースを使用して、ADDRESS を画面名称に変換している。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},ADDRESS,NAME_JA" />

<!-- ２重押し防止 oneClick()関数は、useAjaxSubmit='true' 使用時には使えません。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="MODIFY" lbl="OMIT" />
	<og:submit  action="DELETE" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "OLDOMIT,FGJ,UNIQ,SYSTEM_ID,TBLSYU"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
