<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC02"
	title	= "タグリブ属性定義"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select  a.VERNO,a.TAGNAME,a.SEQ,a.VALUENAME,a.REQUIRED
			<og:text caseNN  ="{@TEXT_DATA}">,CTX_DOC.SNIPPET('GF24_TXT_IDX',b.UNIQ,'{@TEXT_DATA}') AS DESCRIPTION</og:text>
			<og:text caseNull="{@TEXT_DATA}">,b.DESCRIPTION</og:text>
				,b.CONTENTS,b.HTMLEXT,c.BODYCONTENT,'0' as DATAKEY
		from    GF22 a left outer join GF24 b
		on		a.VERNO     = b.VERNO
		and		a.TAGCLASS  = b.TAGCLASS
		and		a.VALUENAME = b.VALUENAME
		and		a.FGJ       = b.FGJ
					left outer join GF21 c
					on	a.VERNO     = c.VERNO
					and	a.TAGNAME   = c.TAGNAME
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.VERNO			=    '{@VERNO}'" 			/>
		<og:and value = "upper(a.TAGNAME)	LIKE upper('{@TAGNAME}')"	/>
		<og:and value = "a.VALUENAME		LIKE '{@VALUENAME}'"		/>
		<og:and value = "b.DESCRIPTION		LIKE '{@DESCRIPTION}'"	/>
		<og:and value = "b.HTMLEXT			=    '{@HTMLEXT}'"			/>
		<og:and value = "a.FGJ			in   ( '0','1' )"				/>
		<og:and value = "CONTAINS ( b.FGJ, '{@TEXT_DATA}' ,1) &gt; 0"	/>
	</og:where>

	<og:equals val1="{@VIEW}" val2="XML" >
			union all
			select VERNO,TAGNAME,99 as SEQ,'' as VALUENAME,'' as REQUIRED,
					'' as DESCRIPTION,null as CONTENTS,'' as HTMLEXT,
					BODYCONTENT,BODYCONTENT as DATAKEY
			from GF21
		<og:where>
			<og:and value = "VERNO		LIKE '{@VERNO}'"	/>
			<og:and value = "TAGNAME	LIKE '{@TAGNAME}'"	/>
			<og:and value = "FGJ		in   ( '0','1' )"	/>
		</og:where>
	</og:equals>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="a.VERNO,a.TAGNAME,a.SEQ" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->

<og:viewLink command="{@command}">
	<og:link column="TAGNAME" gamenId="DOC01" href="index.jsp" target="CONTENTS"
			keys="command,VERNO,TAGNAME,VIEW" vals="NEW,[VERNO],[TAGNAME],FULL" />
	<og:link column="VALUENAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
			keys="command,VERNO,TAGNAME,VALUENAME,VIEW" vals="NEW,[VERNO],[TAGNAME],[VALUENAME],FULL" />
</og:viewLink>

<!--
<style>
	.gray a , .gray { color: GRAY; }
	.row_1 { background-color:#eebbee; }
</style>
-->

<og:equals val1="{@VIEW}" isNull="true" >
	<og:viewMarker command="{@command}">
		<og:columnMarker column="DESCRIPTION"  onMark="[REQUIRED]" markList="1" >
			<span style="color:green; font-weight:bolder;">[DESCRIPTION]({@LBL.REQUIRED})</span>
		</og:columnMarker>
		<og:columnMarker column="REQUIRED"  onMark="[REQUIRED]" markList="1" >
			<span style="color:green; font-weight:bolder;">[REQUIRED]</span>
		</og:columnMarker>
	</og:viewMarker>

	<og:view
		viewFormType = "HTMLTable"
		command 	 = "{@command}"
		noDisplay	 = "CONTENTS,DATAKEY"
		writable     = "false"
		columnGroup	 = "VERNO,TAGNAME"
		groupClass	 = "--"
		startNo      = "{@startNo}"
		pageSize     = "{@pageSize}" />
</og:equals>

<og:equals val1="{@VIEW}" val2="FULL" >
	<og:viewMarker command="{@command}">
		<og:columnMarker column="REQUIRED"  onMark="[REQUIRED]" markList="1" >
			<span style="color:green; font-weight:bolder;">[REQUIRED]({@LBL.REQUIRED})</span>
		</og:columnMarker>
	</og:viewMarker>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType = "HTMLFormatTable"
		command 	 = "{@command}"
		startNo      = "{@startNo}"
		writable     = "false"
		pageSize     = "{@pageSize}"
		rowspan      = "1"
	>
	<tr><td style="vertical-align:top;">[VERNO]<br />[TAGNAME]<br />[VALUENAME]<br />[REQUIRED]<br />[HTMLEXT]<br />[BODYCONTENT]</td>
		<td style="vertical-align:top;"><pre>[CONTENTS]</pre></td>
	</tr>
	</og:view>
</og:equals>

<og:equals val1="{@VIEW}" val2="XML" >
	<og:viewMarker command="{@command}">
		<og:columnMarker column="DESCRIPTION"  onMark="[REQUIRED]" markList="1" >
			<span style="color:green; font-weight:bolder;">[DESCRIPTION]({@LBL.REQUIRED})</span>
		</og:columnMarker>
		<og:columnMarker column="REQUIRED"  onMark="[REQUIRED]" markList="1" >
			<span style="color:green; font-weight:bolder;">[REQUIRED]</span>
		</og:columnMarker>
	</og:viewMarker>

	<og:view
		viewFormType = "HTMLCustomTable"
		command 	 = "{@command}"
		writable     = "false"
		startNo      = "{@startNo}"
		pageSize     = "{@pageSize}"
		rowspan		 = "1"
		numberType	 = "delete"
	>
		<og:thead rowspan="1" >
			<tr><td>&amp;nbsp;</td><td>[VALUENAME]</td><td>[REQUIRED]</td><td>[DESCRIPTION]</td></tr>
		</og:thead>

		<og:tbody usableKey="SEQ" usableList="1" rowspan="1">
			<tr><td colspan="2">&amp;lt;[TAGNAME]</td><td colspan="2" /></tr>
		</og:tbody>

		<og:tbody usableKey="DATAKEY" usableList="0" rowspan="1">
			<tr><td>&amp;nbsp;&amp;nbsp;</td><td>[VALUENAME]</td>
				<td>[REQUIRED]</td><td>[DESCRIPTION]</td></tr>
		</og:tbody>

		<og:tbody usableKey="DATAKEY" usableList="1" rowspan="2">
			<tr><td>&amp;gt;</td><td>... Body ...</td><td colspan="2" /></tr>
			<tr><td colspan="2">&amp;lt;/[TAGNAME]&amp;gt;</td><td colspan="2" /></tr>
			<tr><td colspan="4">&amp;nbsp;</td></tr>
		</og:tbody>

		<og:tbody usableKey="DATAKEY" usableList="2|3" rowspan="1">
			<tr><td colspan="2">/&amp;gt;</td><td colspan="2" /></tr>
			<tr><td colspan="4">&amp;nbsp;</td></tr>
		</og:tbody>
	</og:view>

</og:equals>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
