<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE1004"
	title    = "DB検索"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<og:text>{@TYPE} {@NAME}</og:text><br />

<og:equals val1="SYNONYM,FUNCTION,PACKAGE,PACKAGE BODY,PROCEDURE,TYPE,TYPE BODY,TRIGGER" val2="{@TYPE}" contains="true">
	<og:query command="{@command}" maxRowCount="0" quotCheck="false" dbid="{@DBID}" stopZero="true">
		select LINE,' ' AS OK,TEXT
		from DBA_SOURCE
		where   OWNER = '{@OWNER}'
		and     TYPE  = '{@TYPE}'
		and     NAME  = '{@NAME}'
		union
		select LINE,'X' AS OK,TEXT
		from DBA_ERRORS
		where   OWNER = '{@OWNER}'
		and     NAME  = '{@NAME}'
		and     TEXT not like 'PL/SQL%ignored%'
		order by LINE,OK
	</og:query>

	<og:columnEditor column="TEXT" renderer="PRE" />

	<og:viewMarker command="{@command}">
		<og:columnMarker columns="LINE,OK,TEXT" onMark="[OK]" markList="X" >
			<span style="background-color:#ccff00">[$1]</span>
		</og:columnMarker>
		<og:columnMarker columns="TEXT" onMark="{@REF_NAME}" markList="[TEXT]" >
			<span style="background-color:#ffff00">[$1]</span>
		</og:columnMarker>
	</og:viewMarker>
</og:equals>

<og:equals val1="TABLE" val2="{@TYPE}" >
	<og:query command="{@command}" maxRowCount="0" notfoundMsg="" quotCheck="false" dbid="{@DBID}" stopZero="true">
		select A.TABLE_NAME,A.COLUMN_ID SEQNO,
					A.COLUMN_NAME,
					B.COMMENTS AS DBLABEL,A.DATA_TYPE,
			( CASE	WHEN A.DATA_TYPE = 'BLOB' or A.DATA_TYPE = 'CLOB'
						THEN NULL
					WHEN A.DATA_TYPE = 'NUMBER' AND A.DATA_PRECISION IS NULL 
						THEN NULL
					WHEN A.DATA_TYPE = 'VARCHAR2'
						THEN to_char(A.DATA_LENGTH)
					WHEN A.DATA_PRECISION IS NULL 
						THEN to_char(A.DATA_LENGTH)
						ELSE (	CASE WHEN A.DATA_SCALE = 0 or A.DATA_SCALE is null
									THEN to_char(A.DATA_PRECISION)
									ELSE A.DATA_PRECISION || ',' || A.DATA_SCALE
							  	END )
					 END ) AS USE_LENGTH ,
			( CASE	WHEN A.NULLABLE = 'N' THEN 'NN' ELSE '' END ) AS NN ,
				A.DATA_DEFAULT
		from DBA_TAB_COLS A left outer join DBA_COL_COMMENTS B
					on  A.OWNER       = B.OWNER
					and A.TABLE_NAME  = B.TABLE_NAME
					and A.COLUMN_NAME = B.COLUMN_NAME
		where	A.OWNER			= '{@OWNER}'
		and		A.TABLE_NAME		= '{@NAME}'
		and		A.HIDDEN_COLUMN	= 'NO'
		order by A.COLUMN_ID
	</og:query>
</og:equals>

<og:equals val1="VIEW" val2="{@TYPE}" >
	<og:query command="{@command}" maxRowCount="0" notfoundMsg="" quotCheck="false" dbid="{@DBID}" >
		select TEXT
		from DBA_VIEWS
		where   OWNER       = '{@OWNER}'
		and     VIEW_NAME   = '{@NAME}'
	</og:query>

	<og:columnEditor column="TEXT" renderer="PRE" />
</og:equals>

<og:equals val1="INDEX" val2="{@TYPE}" >
	<og:query command="{@command}" maxRowCount="0" notfoundMsg="" quotCheck="false" dbid="{@DBID}" stopZero="true">
		select A.TABLE_NAME,A.INDEX_NAME,A.COLUMN_POSITION SEQNO,A.COLUMN_NAME,B.COMMENTS AS DBLABEL,DESCEND
		from DBA_IND_COLUMNS A left outer join DBA_COL_COMMENTS B
					on  A.TABLE_OWNER = B.OWNER
					and A.TABLE_NAME  = B.TABLE_NAME
					and A.COLUMN_NAME = B.COLUMN_NAME
		where   A.TABLE_OWNER = '{@OWNER}'
		and     A.INDEX_NAME  = '{@NAME}'
		order by A.COLUMN_POSITION
	</og:query>
</og:equals>

<og:equals val1="SEQUENCE" val2="{@TYPE}" >
	<og:query command="{@command}" maxRowCount="0" notfoundMsg="" quotCheck="false" dbid="{@DBID}" stopZero="true">
		select SEQUENCE_NAME,MIN_VALUE,MAX_VALUE,INCREMENT_BY,
				CYCLE_FLAG,ORDER_FLAG,CACHE_SIZE,LAST_NUMBER
		from DBA_SEQUENCES
		where   SEQUENCE_OWNER = '{@OWNER}'
		and     SEQUENCE_NAME  = '{@NAME}'
	</og:query>
</og:equals>

<og:equals val1="ERRORS" val2="{@TYPE}" >
	<og:query command="{@command}" maxRowCount="0" notfoundMsg="" quotCheck="false" dbid="{@DBID}" stopZero="true">
		select OWNER,NAME,TYPE,LINE,POSITION,TEXT
		from DBA_ERRORS
		<og:where>
			<og:and value="OWNER	=	 '{@OWNER}'"	/>
			<og:and value="NAME		like '{@NAME}%'"	/>
			<og:and value="TEXT not like 'PL/SQL%ignored%'"	/>
		</og:where>
		order by OWNER,NAME,LINE,POSITION
	</og:query>

	<og:columnEditor column="TEXT" renderer="PRE" />

	<og:viewLink command="{@command}">
		<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND" 
			keys="command,OWNER,TYPE,NAME,LINE,DBID" vals="NEW,[OWNER],[TYPE],[NAME],[LINE],{@DBID}" />
	</og:viewLink>
</og:equals>

<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="COLUMN_NAME,DBLABEL" />

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	numberType = "none"
	startNo    = "{@startNo}"
	pageSize   = "100000" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
