/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opengion.fukurou.util.JSONScan;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class IorSQLTag
extends CommonTagSupport {
    private static final String VERSION = "8.1.1.0 (2022/02/04)";
    private static final long serialVersionUID = 811020220204L;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String jsonVal;
    private String reqKey;
    private String loadFile;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.useXssCheck(false);
            this.useQuotCheck(false);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        block11: {
            this.debugPrint();
            if (this.loadFile != null) {
                try (Stream<String> stream = Files.lines(Paths.get(this.loadFile, new String[0]), StandardCharsets.UTF_8);){
                    this.jsonVal = stream.collect(Collectors.joining());
                    break block11;
                }
                catch (IOException iOException) {
                    String string = "loadFile \u51e6\u7406\u4e2d\u3067\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61" + CR + "\t " + iOException.getMessage() + CR;
                    throw new HybsSystemException(string, iOException);
                }
            }
            if (this.reqKey != null) {
                this.jsonVal = this.getRequest().getParameter(this.reqKey);
            } else {
                throw new HybsSystemException("reqKey \u304b\u3001loadFile \u306f\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        this.printSQL();
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.jsonVal = null;
        this.reqKey = null;
        this.loadFile = null;
    }

    private void printSQL() {
        Map map = JSONScan.json2Map((String)this.jsonVal);
        if (this.isDebug()) {
            map.forEach((string, string2) -> System.out.println(string + ":" + string2));
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        String string3 = map.getOrDefault("select_cols", "*");
        stringBuilder.append("select ").append(string3).append(" from ");
        String string4 = (String)map.get("report_name");
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{string4})) {
            throw new HybsSystemException("IOr \u691c\u7d22\u7528 JSON \u3067\u306f\u3001report_name(=\uff83\uff70\uff8c\uff9e\uff99\u540d)\u306f\u5fc5\u9808\u3067\u3059\u3002");
        }
        stringBuilder.append(string4);
        boolean bl = true;
        bl = this.whereStr(stringBuilder, (String)map.get("where_lk"), " like ", bl);
        bl = this.whereStr(stringBuilder, (String)map.get("where_gt"), " > ", bl);
        bl = this.whereStr(stringBuilder, (String)map.get("where_lt"), " < ", bl);
        String string5 = (String)map.get("group_by");
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string5})) {
            stringBuilder.append(" group by ").append(string5);
        }
        String string6 = (String)map.get("order_by");
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string6})) {
            stringBuilder.append(" order by ").append(string6);
        }
        this.jspPrint(stringBuilder.toString());
    }

    private boolean whereStr(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        boolean bl2 = bl;
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string})) {
            String[] stringArray;
            for (String string3 : stringArray = JSONScan.json2Array((String)string)) {
                String[] stringArray2 = string3.split(":", 2);
                if (stringArray2.length != 2) continue;
                if (bl2) {
                    stringBuilder.append(" where ");
                    bl2 = false;
                } else {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(this.quotTrim(stringArray2[0])).append(string2).append(stringArray2[1]);
            }
        }
        return bl2;
    }

    private String quotTrim(String string) {
        if (string.length() >= 2 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public void setReqKey(String string) {
        this.reqKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.reqKey);
    }

    public void setLoadFile(String string) {
        this.loadFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.loadFile);
        if (this.loadFile != null) {
            this.loadFile = HybsSystem.url2dir(StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{this.loadFile}));
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("reqKey", (Object)this.reqKey).println("loadFile", (Object)this.loadFile).fixForm().toString();
    }
}

