/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.UnicodeCorrecter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.ExecThreadManager;
import org.opengion.hayabusa.report2.QueueManager;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public final class QueueManager_DB
implements QueueManager {
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private static final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String CON = DBFunctionName.getFunctionName((String)"CON", null);
    private static final String SQL_SELECT_GE50 = "SELECT A.SYSTEM_ID, A.YKNO, A.LISTID, A.OUT_DIR, A.OUT_FILE, A.PDF_PASSWD, B.LANG, B.FGRUN, B.DMN_GRP , C.MODELDIR, C.MODELFILE, D.PRTNM, C.FGLOCAL, C.FGCUT FROM GE50 A INNER JOIN GE53 B ON A.SYSTEM_ID = B.SYSTEM_ID AND A.JOKEN = B.JOKEN INNER JOIN GE54 C ON A.SYSTEM_ID = C.SYSTEM_ID AND A.LISTID = C.LISTID LEFT OUTER JOIN GE55 D ON B.SYSTEM_ID = D.SYSTEM_ID AND B.PRTID = D.PRTID WHERE A.FGKAN='1' AND EXISTS ( SELECT 'X' FROM GE12 E WHERE\tE.FGJ\t\t\t='1' AND\tE.SYSTEM_ID \t= '" + HybsSystem.sys("SYSTEM_ID") + "' AND\tE.CONTXT_PATH\t= '" + HybsSystem.sys("HOST_URL") + "' AND\tE.PARAM_ID\t\tLIKE 'REPORT2_HANDLE_DAEMON_%' AND\tE.PARAM\t\t\t= 'RUN_'" + CON + "A.SYSTEM_ID" + CON + "'_'" + CON + "B.DMN_GRP) ORDER BY " + HybsSystem.sys("REPORT_DAEMON_ORDER_BY");
    private static final String SQL_UPDATE_GE50 = "UPDATE GE50 SET FGKAN=?,DMN_NAME=?,DMN_HOST=?,SUDATA=?,SUPAGE=?,DYUPD=? WHERE SYSTEM_ID=? AND YKNO=?";
    private static final String SQL_UPDATE_GE50_ERR = "UPDATE GE50 SET FGKAN=?,DYUPD=? WHERE SYSTEM_ID=? AND YKNO=?";
    private static final String SQL_INSERT_GE56 = "INSERT INTO GE56 ( FGJ,SYSTEM_ID,YKNO,ERRMSG,DYSET,DYUPD,USRSET,USRUPD,PGUPD )  VALUES ( '1',?,?,?,?,?,?,?,? )";
    private static final int STATUS_COMPLETE = 2;
    private static final int STATUS_EXECUTE = 3;
    private static final int STATUS_ERROR = 8;
    private static QueueManager manager = new QueueManager_DB();
    private static final ApplicationInfo APP_INFO;

    private QueueManager_DB() {
    }

    public static QueueManager getInstance() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() {
        String[][] stringArray;
        String[][] stringArray2 = stringArray = DBUtil.dbExecute((String)SQL_SELECT_GE50, null, (ApplicationInfo)APP_INFO, (String)DBID);
        synchronized (stringArray) {
            for (String[] stringArray3 : stringArray) {
                ExecQueue execQueue = new ExecQueue();
                execQueue.setSystemId(stringArray3[0]);
                execQueue.setYkno(stringArray3[1]);
                execQueue.setListId(stringArray3[2]);
                execQueue.setOutputName(HybsSystem.url2absPath(stringArray3[3]), stringArray3[4], stringArray3[7], stringArray3[1]);
                execQueue.setPdfPasswd(stringArray3[5]);
                execQueue.setLang(stringArray3[6]);
                execQueue.setOutputType(stringArray3[7]);
                execQueue.setThreadId(stringArray3[0] + "_" + StringUtil.nval((String)stringArray3[8], (String)"_DEFALUT_"));
                execQueue.setTemplateName(HybsSystem.url2absPath(stringArray3[9]) + HybsConst.FS + stringArray3[10]);
                execQueue.setPrinterName(stringArray3[11]);
                execQueue.setFglocal("1".equals(stringArray3[12]));
                execQueue.setFgcut("1".equals(stringArray3[13]));
                execQueue.setManager(this);
                ExecThreadManager.insertQueue(execQueue);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void set(ExecQueue execQueue) {
        DBTableModelCreator dBTableModelCreator;
        DBTableModel dBTableModel;
        DBTableModel dBTableModel2;
        String string = execQueue.getSystemId();
        String string2 = execQueue.getLang();
        String string3 = execQueue.getListId();
        String string4 = execQueue.getYkno();
        ResourceManager resourceManager = null;
        resourceManager = execQueue.isFglocal() ? ResourceFactory.newInstance(string, string2, false) : ResourceFactory.newInstance(string2);
        DBTableModel dBTableModel3 = new DBTableModelCreator(string, string3, string4, "H", resourceManager).getTable();
        if (dBTableModel3 != null && dBTableModel3.getRowCount() > 0) {
            execQueue.setHeader(dBTableModel3);
        }
        if ((dBTableModel2 = new DBTableModelCreator(string, string3, string4, "F", resourceManager).getTable()) != null && dBTableModel2.getRowCount() > 0) {
            execQueue.setFooter(dBTableModel2);
        }
        if ((dBTableModel = (dBTableModelCreator = new DBTableModelCreator(string, string3, string4, "B", resourceManager)).getTable()) == null) {
            execQueue.addMsg("[ERROR]QM;DBTableModel doesn't exists! maybe Layout-Table(GE52) or Report-Data(GE51) is not configured...");
            execQueue.setError();
            throw new OgRuntimeException();
        }
        if (dBTableModel.getRowCount() <= 0) {
            execQueue.addMsg("[ERROR]QM;Database Body row count is Zero." + string4);
            execQueue.setError();
            throw new OgRuntimeException();
        }
        if (dBTableModel.isOverflow()) {
            execQueue.addMsg("[ERROR]QM;Database is Overflow. [" + dBTableModel.getRowCount() + "]");
            execQueue.addMsg("[ERROR]QM;Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow");
            execQueue.setError();
            throw new OgRuntimeException();
        }
        execQueue.setBody(dBTableModel);
        execQueue.setBodyTypes(dBTableModelCreator.getBodyTypes());
    }

    @Override
    public void execute(ExecQueue execQueue) {
        this.status(execQueue, 3);
    }

    @Override
    public void complete(ExecQueue execQueue) {
        this.status(execQueue, 2);
    }

    @Override
    public void error(ExecQueue execQueue) {
        this.status(execQueue, 8);
        this.insertErrorMsg(execQueue);
    }

    private void status(ExecQueue execQueue, int n) {
        block2: {
            String string = DateSet.getDate((String)"yyyyMMddHHmmss");
            String[] stringArray = new String[]{String.valueOf(n), execQueue.getThreadId(), HybsSystem.sys("HOST_NAME"), String.valueOf(execQueue.getExecRowCnt()), String.valueOf(execQueue.getExecPagesCnt()), string, execQueue.getSystemId(), execQueue.getYkno()};
            try {
                DBUtil.dbExecute((String)SQL_UPDATE_GE50, (String[])stringArray, (ApplicationInfo)APP_INFO, (String)DBID);
            }
            catch (Throwable throwable) {
                execQueue.addMsg("\u72b6\u6cc1C\u3092\u66f4\u65b0\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61");
                execQueue.addMsg(ThrowUtil.ogStackTrace((Throwable)throwable));
                LogWriter.log((String)"\u72b6\u6cc1C\u3092\u66f4\u65b0\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61");
                LogWriter.log((Throwable)throwable);
                String[] stringArray2 = new String[]{String.valueOf(8), string, execQueue.getSystemId(), execQueue.getYkno()};
                DBUtil.dbExecute((String)SQL_UPDATE_GE50_ERR, (String[])stringArray2, (ApplicationInfo)APP_INFO, (String)DBID);
                if (n == 8) break block2;
                this.insertErrorMsg(execQueue);
            }
        }
    }

    private void insertErrorMsg(ExecQueue execQueue) {
        String string = execQueue.getMsg();
        if (string.length() > 1300) {
            string = string.substring(string.length() - 1300, string.length());
        }
        String string2 = DateSet.getDate((String)"yyyyMMddHHmmss");
        String[] stringArray = new String[]{execQueue.getSystemId(), execQueue.getYkno(), string, string2, string2, "UNKNOWN", "UNKNOWN", "UNKNOWN"};
        DBUtil.dbExecute((String)SQL_INSERT_GE56, (String[])stringArray, (ApplicationInfo)APP_INFO, (String)DBID);
    }

    static {
        if (USE_DB_APPLICATION_INFO) {
            APP_INFO = new ApplicationInfo();
            APP_INFO.setClientInfo("ReportDaemon", HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            APP_INFO.setModuleInfo("ReportDaemon", "QueueManager", "QueueManager");
        } else {
            APP_INFO = null;
        }
    }

    public static final class DBTableModelCreator {
        private static final String SQL_SELECT_GE52 = " select CLM, START_POS, USE_LENGTH from GE52 where SYSTEM_ID = ? and LISTID = ? and KBTEXT = ? and FGJ = '1' and FGUSE = '1' order by SEQ";
        private static final String SQL_SELECT_GE51 = " select KBTEXT,TEXT_DATA from GE51 where SYSTEM_ID = ? and YKNO = ? and KBTEXT like ? || '%' and FGJ = '1' order by SYSTEM_ID,YKNO,EDNO";
        private static final String ENCODE = HybsSystem.sys("DB_ENCODE");
        private String[] kbtxt;
        private final String systemId;
        private final String listId;
        private final String ykno;
        private final String kbtext;
        private final ResourceManager resource;

        public DBTableModelCreator(String string, String string2, String string3, String string4, ResourceManager resourceManager) {
            this.systemId = string;
            this.listId = string2;
            this.ykno = string3;
            this.kbtext = string4;
            this.resource = resourceManager;
        }

        public DBTableModel getTable() {
            String[] stringArray = new String[]{this.systemId, this.listId, this.kbtext};
            String[][] stringArray2 = DBUtil.dbExecute((String)SQL_SELECT_GE52, (String[])stringArray, (ApplicationInfo)APP_INFO, (String)DBID);
            if (stringArray2 == null || stringArray2.length == 0) {
                return null;
            }
            String[] stringArray3 = new String[]{this.systemId, this.ykno, this.kbtext};
            String[][] stringArray4 = DBUtil.dbExecute((String)SQL_SELECT_GE51, (String[])stringArray3, (ApplicationInfo)APP_INFO, (String)DBID);
            if (stringArray4 == null || stringArray4.length == 0) {
                return null;
            }
            String[] stringArray5 = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray5[i] = stringArray2[i][0];
            }
            String[][] stringArray6 = new String[stringArray4.length][stringArray2.length];
            this.kbtxt = new String[stringArray4.length];
            for (int i = 0; i < stringArray4.length; ++i) {
                this.kbtxt[i] = stringArray4[i][0];
                byte[] byArray = StringUtil.makeByte((String)UnicodeCorrecter.correctToCP932((String)stringArray4[i][1], (String)ENCODE), (String)ENCODE);
                for (int j = 0; j < stringArray2.length; ++j) {
                    int n = Integer.parseInt(stringArray2[j][1]) - 1;
                    int n2 = Integer.parseInt(stringArray2[j][2]);
                    if (n >= byArray.length) {
                        stringArray6[i][j] = "";
                        continue;
                    }
                    if (n + n2 > byArray.length) {
                        n2 = byArray.length - n;
                    }
                    stringArray6[i][j] = StringUtil.rTrim((String)StringUtil.makeString((byte[])byArray, (int)n, (int)n2, (String)ENCODE));
                }
            }
            return DBTableModelUtil.makeDBTable(stringArray5, stringArray6, this.resource);
        }

        public String[] getBodyTypes() {
            return this.kbtxt;
        }
    }
}

