/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.xml.HybsXMLSave;

public final class XMLFileLoader {
    private static final String ENCODE = "UTF-8";
    private final Connection connection;
    private final boolean useTimeStamp;
    private Writer log = FileUtil.getLogWriter("System.out");
    private final List<File> fileList = new ArrayList<File>();
    private Map<String, String> afterMap;
    private final int[] crudCnt = new int[]{0, 0, 0, 0};
    public static final int INS = 0;
    public static final int DEL = 1;
    public static final int UPD = 2;
    public static final int DDL = 3;

    public XMLFileLoader(Connection connection, boolean bl) {
        this.connection = connection;
        this.useTimeStamp = bl;
    }

    public void setLogWriter(Writer writer) {
        this.log = writer;
    }

    public void setAfterMap(Map<String, String> map) {
        this.afterMap = map;
    }

    public int[] getCRUDCount() {
        return (int[])this.crudCnt.clone();
    }

    public void loadClassPathFiles(String string) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                this.println("      XMLFileLoader Scan:[ " + uRL + " ]");
                String string2 = uRL.getFile().replaceAll("%23%23", "##");
                if ("jar".equals(uRL.getProtocol())) {
                    String string3 = string2.substring(string2.indexOf(58) + 1, string2.lastIndexOf(33));
                    this.loadJarFile(new File(string3));
                    continue;
                }
                this.loadXMLDir(new File(string2));
            }
            Closer.commit(this.connection);
        }
        catch (SQLException sQLException) {
            String string4 = "SQL\u5b9f\u884c\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + sQLException.getMessage();
            Closer.rollback(this.connection);
            throw new OgRuntimeException(string4, sQLException);
        }
        catch (IOException iOException) {
            String string5 = "XML\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u53d6\u308a\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + iOException.getMessage();
            throw new OgRuntimeException(string5, iOException);
        }
        finally {
            this.setZeroTimeStamp();
        }
    }

    public void loadXMLFiles(File file) {
        try {
            if (file != null && file.exists()) {
                this.println("      XMLFileLoader Scan:[ " + file + " ]");
                this.loadXMLDir(file);
            }
            Closer.commit(this.connection);
        }
        catch (SQLException sQLException) {
            String string = "SQL\u5b9f\u884c\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + sQLException.getMessage();
            Closer.rollback(this.connection);
            throw new OgRuntimeException(string, sQLException);
        }
        catch (IOException iOException) {
            String string = "XML\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u53d6\u308a\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + iOException.getMessage();
            throw new OgRuntimeException(string, iOException);
        }
        finally {
            this.setZeroTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarFile(File file) throws SQLException, IOException {
        if (!this.useTimeStamp || file.lastModified() > 0L) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string = jarEntry.getName();
                    if (jarEntry.isDirectory() || !string.endsWith(".xml")) continue;
                    String string2 = string.substring(string.lastIndexOf(47) + 1, string.lastIndexOf(46));
                    InputStream inputStream = null;
                    try {
                        inputStream = jarFile.getInputStream(jarEntry);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, ENCODE));
                        this.loadXML(bufferedReader, string2, string);
                    }
                    finally {
                        Closer.ioClose(inputStream);
                    }
                }
                this.fileList.add(file);
            }
            catch (Throwable throwable) {
                Closer.zipClose(jarFile);
                throw throwable;
            }
            Closer.zipClose(jarFile);
        }
    }

    private void loadXMLDir(File file) throws SQLException, IOException {
        if (file.isDirectory()) {
            Object[] objectArray = file.listFiles();
            if (objectArray != null) {
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    this.loadXMLDir((File)object);
                }
            }
        } else if (!this.useTimeStamp || file.lastModified() > 0L) {
            String string = file.getName();
            if (string.endsWith(".xml")) {
                String string2 = string.substring(string.lastIndexOf(47) + 1, string.lastIndexOf(46));
                this.println("        " + file);
                BufferedReader bufferedReader = FileUtil.getBufferedReader(file, ENCODE);
                this.loadXML(bufferedReader, string2, file.getPath());
                this.fileList.add(file);
            } else if (string.endsWith(".zip") || string.endsWith(".jar")) {
                this.loadJarFile(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXML(BufferedReader bufferedReader, String string, String string2) throws SQLException, UnsupportedEncodingException {
        try {
            HybsXMLSave hybsXMLSave = new HybsXMLSave(this.connection, string);
            hybsXMLSave.onExecErrException(false);
            hybsXMLSave.setAfterMap(this.afterMap);
            hybsXMLSave.insertXML(bufferedReader);
            int n = hybsXMLSave.getInsertCount();
            int n2 = hybsXMLSave.getDeleteCount();
            int n3 = hybsXMLSave.getUpdateCount();
            int n4 = hybsXMLSave.getDDLCount();
            this.crudCnt[0] = this.crudCnt[0] + n;
            this.crudCnt[1] = this.crudCnt[1] + n2;
            this.crudCnt[2] = this.crudCnt[2] + n3;
            this.crudCnt[3] = this.crudCnt[3] + n4;
            String string3 = hybsXMLSave.getTableName();
            this.println("          File=[" + string2 + "] TABLE=[" + string3 + "] DEL=[" + n2 + "] INS=[" + n + "] UPD=[" + n3 + "] DDL=[" + n4 + "]");
            String string4 = hybsXMLSave.getErrorMessage();
            if (!string4.isEmpty()) {
                this.println(string4);
            }
        }
        finally {
            Closer.ioClose(bufferedReader);
        }
    }

    private void setZeroTimeStamp() {
        if (this.useTimeStamp) {
            for (File file : this.fileList) {
                if (file.setLastModified(0L)) continue;
                String string = "\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7\u306e\u66f8\u304d\u63db\u3048\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002file=" + file;
                System.err.println(string);
            }
        }
    }

    private void println(String string) {
        if (this.log != null) {
            try {
                this.log.write(string);
                this.log.write(HybsConst.CR);
            }
            catch (IOException iOException) {
                String string2 = string + " \u304c\u3001\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + iOException.getMessage();
                System.err.println(string2);
                System.err.println(ThrowUtil.ogStackTrace(iOException));
            }
        }
    }
}

