/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.IllegalWriteException;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import org.opengion.fukurou.mail.MailCharset;
import org.opengion.fukurou.mail.MailCharsetFactory;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;

public class MailTX {
    private static final String AUTH_PBS = "POP_BEFORE_SMTP";
    private static final String AUTH_SMTPA = "SMTP_AUTH";
    public static final String MAILER = "openGion Mail Ver 6.0";
    private final String charset;
    private String[] filename;
    private String message;
    private Session session;
    private MimeMultipart mmPart;
    private MimeMessage mimeMsg;
    private MailCharset mcSet;

    public MailTX(String string) {
        this(string, "ISO-2022-JP");
    }

    public MailTX(String string, String string2) {
        this(string, string2, null, null, null, null, null, false, false);
    }

    public MailTX(String string, String string2, String string3, String string4, String string5, final String string6, final String string7, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("host \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("charset \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        this.charset = string2;
        this.mcSet = MailCharsetFactory.newInstance(string2);
        System.setProperty("mail.mime.splitlongparameters", "false");
        System.setProperty("mail.mime.encodeparameters", "false");
        Properties properties = new Properties();
        properties.setProperty("mail.mime.charset", string2);
        properties.setProperty("mail.mime.decodetext.strict", "false");
        properties.setProperty("mail.mime.address.strict", "false");
        properties.setProperty("mail.smtp.host", string);
        properties.setProperty("mail.smtp.localhost", string);
        properties.setProperty("mail.host", string);
        if (string3 != null && string3.length() > 0) {
            properties.setProperty("mail.smtp.port", string3);
        }
        Authenticator authenticator = null;
        if (AUTH_SMTPA.equals(string4)) {
            properties.setProperty("mail.smtp.auth", "true");
            properties.setProperty("mail.transport.protocol", "smtps");
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string6, string7);
                }
            };
        }
        if (bl || bl2) {
            properties.setProperty("mail.smtp.starttls.enable", "true");
            properties.setProperty("mail.smtp.starttls.required", "true");
        }
        if (bl2) {
            properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail.smtp.socketFactory.fallback", "false");
            properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(string3));
            properties.setProperty("mail.transport.protocol", "smtps");
        }
        this.session = Session.getInstance((Properties)properties, authenticator);
        if (AUTH_PBS.equals(string4)) {
            try {
                int n = string5 == null || string5.isEmpty() || string7 == null || string7.isEmpty() ? -1 : Integer.parseInt(string5);
                Store store = this.session.getStore("pop3");
                store.connect(string, n, string6, string7);
                store.close();
            }
            catch (MessagingException messagingException) {
                String string8 = "POP3 Auth Exception: " + string + "/" + string6;
                throw new OgRuntimeException(string8, messagingException);
            }
        }
        this.mimeMsg = new MimeMessage(this.session);
    }

    public void sendmail() {
        try {
            this.mimeMsg.setSentDate(new Date());
            if (this.filename == null || this.filename.length == 0) {
                this.mcSet.setTextContent(this.mimeMsg, this.message);
            } else {
                this.mmPart = new MimeMultipart();
                this.mimeMsg.setContent((Multipart)this.mmPart);
                this.addMmpText(this.message);
                for (int i = 0; i < this.filename.length; ++i) {
                    this.addMmpFile(this.filename[i]);
                }
            }
            this.mimeMsg.setHeader("X-Mailer", MAILER);
            this.mimeMsg.setHeader("Content-Transfer-Encoding", this.mcSet.getBit());
            Transport.send((Message)this.mimeMsg);
        }
        catch (AddressException addressException) {
            String string = "Address Exception: " + addressException.getMessage();
            throw new OgRuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void reset() {
        this.mimeMsg = new MimeMessage(this.session);
    }

    public void setFrom(String string) {
        try {
            if (string != null) {
                this.mimeMsg.setFrom((Address)this.getAddress(string));
            }
        }
        catch (AddressException addressException) {
            String string2 = "Address Exception: " + addressException.getMessage();
            throw new OgRuntimeException(string2, addressException);
        }
        catch (MessagingException messagingException) {
            String string3 = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string3, messagingException);
        }
    }

    public void setTo(String ... stringArray) {
        try {
            if (stringArray != null && stringArray.length > 0) {
                this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: " + addressException.getMessage();
            throw new OgRuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void setCc(String ... stringArray) {
        try {
            if (stringArray != null && stringArray.length > 0) {
                this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: " + addressException.getMessage();
            throw new OgRuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void setBcc(String ... stringArray) {
        try {
            if (stringArray != null && stringArray.length > 0) {
                this.mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: " + addressException.getMessage();
            throw new OgRuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void clearTo() {
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])((InternetAddress[])null));
        }
        catch (IllegalWriteException | IllegalStateException throwable) {
            String string = "Address Exception: " + throwable.getMessage();
            throw new OgRuntimeException(string, throwable);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void clearCc() {
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])((InternetAddress[])null));
        }
        catch (IllegalWriteException | IllegalStateException throwable) {
            String string = "Address Exception: " + throwable.getMessage();
            throw new OgRuntimeException(string, throwable);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void clearBcc() {
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])((InternetAddress[])null));
        }
        catch (IllegalWriteException | IllegalStateException throwable) {
            String string = "Address Exception: " + throwable.getMessage();
            throw new OgRuntimeException(string, throwable);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void setReplyTo(String ... stringArray) {
        try {
            if (stringArray != null && stringArray.length > 0) {
                this.mimeMsg.setReplyTo((Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: " + addressException.getMessage();
            throw new OgRuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
    }

    public void setSubject(String string) {
        try {
            if (string != null) {
                this.mimeMsg.setSubject(this.mcSet.encodeWord(string));
            }
        }
        catch (AddressException addressException) {
            String string2 = "Address Exception: " + addressException.getMessage();
            throw new OgRuntimeException(string2, addressException);
        }
        catch (MessagingException messagingException) {
            String string3 = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string3, messagingException);
        }
    }

    public void setFilename(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.filename = new String[n];
            System.arraycopy(stringArray, 0, this.filename, 0, n);
        }
    }

    public void setMessage(String string) {
        this.message = string == null ? HybsConst.CR : string + HybsConst.CR;
    }

    public void setDebug(boolean bl) {
        this.session.setDebug(bl);
    }

    private void addMmpFile(String string) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            FileDataSource fileDataSource = new FileDataSource(string);
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
            mimeBodyPart.setFileName(MimeUtility.encodeText((String)fileDataSource.getName(), (String)this.charset, (String)"B"));
            mimeBodyPart.setHeader("Content-Transfer-Encoding", "base64");
            this.mmPart.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "Multipart UnsupportedEncodingException: " + unsupportedEncodingException.getMessage();
            throw new OgRuntimeException(string2, unsupportedEncodingException);
        }
        catch (MessagingException messagingException) {
            String string3 = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string3, messagingException);
        }
    }

    private void addMmpText(String string) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(string, this.charset);
            mimeBodyPart.setHeader("Content-Transfer-Encoding", this.mcSet.getBit());
            this.mmPart.addBodyPart((BodyPart)mimeBodyPart, 0);
        }
        catch (MessagingException messagingException) {
            String string2 = "MessagingException: " + messagingException.getMessage();
            throw new OgRuntimeException(string2, messagingException);
        }
    }

    private InternetAddress getAddress(String string) {
        InternetAddress internetAddress;
        int n = string.indexOf(60);
        if (n >= 0) {
            String string2 = string.substring(n + 1, string.indexOf(62)).trim();
            String string3 = string.substring(0, n).trim();
            internetAddress = this.mcSet.getAddress(string2, string3);
        } else {
            try {
                internetAddress = new InternetAddress(string);
            }
            catch (AddressException addressException) {
                String string4 = "\u6307\u5b9a\u306e\u30a2\u30c9\u30ec\u30b9\u3092\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002adrs=" + string + " , msg=" + addressException.getMessage();
                throw new OgRuntimeException(string4, addressException);
            }
        }
        return internetAddress;
    }

    private InternetAddress[] getAddress(String ... stringArray) {
        InternetAddress[] internetAddressArray = new InternetAddress[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            internetAddressArray[i] = this.getAddress(stringArray[i]);
        }
        return internetAddressArray;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.mail.MailTX <from> <to> <host> [<file> ....]");
            return;
        }
        String string = stringArray[2];
        MailTX mailTX = new MailTX(string, "ISO-2022-JP");
        mailTX.setFrom(stringArray[0]);
        String[] stringArray3 = new String[]{stringArray[1]};
        mailTX.setTo(stringArray3);
        if (stringArray.length > 3) {
            stringArray2 = new String[stringArray.length - 3];
            System.arraycopy(stringArray, 3, stringArray2, 0, stringArray2.length);
            mailTX.setFilename(stringArray2);
        }
        mailTX.setSubject("\u30e1\u30fc\u30eb\u9001\u4fe1\u30c6\u30b9\u30c8");
        stringArray2 = "\u3053\u308c\u306f\u30c6\u30b9\u30c8\u30e1\u30fc\u30eb\u3067\u3059\u3002" + HybsConst.CR + "\u3046\u307e\u304f\u53d7\u4fe1\u3067\u304d\u307e\u3057\u305f\u304b?" + HybsConst.CR;
        mailTX.setMessage((String)stringArray2);
        mailTX.sendmail();
    }
}

