/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.GUIData;

final class GUIDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select GUIKEY,GUILVL,LABEL_CLM,ADDRESS,SEQNO,GROUPS,'' as CLASSIFY,ROLES,RWMODE,TARGET,PARAM,KBLINK,DYUPD,SYSTEM_ID,KBSAKU from GEA11 where SYSTEM_ID = ? and FGJ='1' order by KBSAKU,SEQNO,GUIKEY";
    private final Map<String, GUIData> guiMap = Collections.synchronizedMap(new LinkedHashMap());
    private final String[] SYS_ARRAY;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    GUIDataLoader(String[] stringArray) {
        this.SYS_ARRAY = stringArray;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYS_ARRAY[0], HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("GUIDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        this.loadDBResource();
    }

    private void loadDBResource() {
        int n = this.SYS_ARRAY.length;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            String string = this.SYS_ARRAY[i];
            String[] stringArray = new String[]{string};
            String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            int n3 = stringArray2.length;
            n2 += n3;
            String string2 = "";
            for (int j = 0; j < n3; ++j) {
                String[] stringArray3 = stringArray2[j];
                int n4 = Integer.parseInt(stringArray3[1]);
                if (n4 == 2) {
                    string2 = stringArray3[0];
                } else if (n4 >= 3) {
                    stringArray3[6] = string2;
                }
                if ((n4 == 1 || n4 == 2) && StringUtil.isEmpty((CharSequence[])new CharSequence[]{stringArray3[3]})) {
                    stringArray3[7] = null;
                }
                String string3 = stringArray3[0] + "_" + stringArray3[7];
                this.guiMap.put(string3, new GUIData(stringArray3));
                int n5 = i;
                nArray[n5] = nArray[n5] + 1;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("  ").append(this.SYS_ARRAY[0]).append("  GUIDataLoader [").append(n2).append("] Map=[").append(this.guiMap.size()).append("] ");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.SYS_ARRAY[i]).append("=[").append(nArray[i]).append("] ");
        }
        stringBuilder.append("loaded.");
        System.out.println(stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUIData[] getAllData() {
        Map<String, GUIData> map = this.guiMap;
        synchronized (map) {
            if (this.guiMap.isEmpty()) {
                this.loadDBResource();
            }
            return this.guiMap.values().toArray(new GUIData[this.guiMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, GUIData> map = this.guiMap;
        synchronized (map) {
            this.guiMap.clear();
        }
    }
}

