/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.column;

import java.text.DecimalFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

public class Renderer_UNIT
extends AbstractRenderer {
    private static final String VERSION = "7.2.3.1 (2020/04/17)";
    private static final DecimalFormat FMT1 = new DecimalFormat("#,##0");
    private final String unit;
    private final long division;

    public Renderer_UNIT() {
        this("", 1L);
    }

    private Renderer_UNIT(String string, long l) {
        this.unit = string;
        this.division = l;
    }

    public CellRenderer newInstance(DBColumn dBColumn) {
        String string = StringUtil.nval((String)dBColumn.getRendererParam(), (String)"");
        long l = 1L;
        if (!string.isEmpty()) {
            char c = string.charAt(0);
            int n = string.length() >= 2 && string.charAt(1) == 'B' ? 1024 : 1000;
            switch (c) {
                case 'K': {
                    l = n;
                    break;
                }
                case 'M': {
                    l = n * n;
                    break;
                }
                case 'G': {
                    l = n * n * n;
                    break;
                }
                case 'T': {
                    l = n * n * n * n;
                    break;
                }
                default: {
                    l = 1L;
                }
            }
        }
        return new Renderer_UNIT(string, l);
    }

    public String getValue(String string) {
        return this.getValue(string, true);
    }

    public String getWriteValue(String string) {
        return this.getValue(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValue(String string, boolean bl) {
        Object object = string == null || string.trim().isEmpty() ? "0" : string;
        long l = (Long.parseLong((String)object) + this.division - 1L) / this.division;
        DecimalFormat decimalFormat = FMT1;
        synchronized (decimalFormat) {
            object = FMT1.format(l) + " " + this.unit;
        }
        if (!bl) {
            return object;
        }
        if (StringUtil.startsChar((CharSequence)object, (char)'-')) {
            object = "<span class=\"minus\">" + (String)object + "</span>";
        }
        return object;
    }
}

